/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseCashBreakdown;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DataProvider;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"cashDrawer"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class CashBreakdown
extends BaseCashBreakdown
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    public Currency getCurrency() {
        return DataProvider.get().getCurrency(this.getCurrencyId());
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            this.setCurrencyId(null);
        } else {
            this.setCurrencyId(currency.getId());
        }
    }

    public String getCurrencyName() {
        return this.getCurrency().getName();
    }

    public void setCurrencyName(String string) {
    }

    @XmlTransient
    public CashDrawer getCashDrawer() {
        String string = this.getCashDrawerId();
        if (StringUtils.isNotEmpty((String)string)) {
            return CashDrawerDAO.getInstance().get(string);
        }
        return null;
    }

    public void setCashDrawer(CashDrawer cashDrawer) {
        if (cashDrawer != null) {
            this.setCashDrawerId(cashDrawer.getId());
        } else {
            this.setCashDrawerId(null);
        }
    }

    @Override
    public Double getBalance() {
        CashDrawer cashDrawer = this.getCashDrawer();
        return cashDrawer == null || cashDrawer.getReportTime() == null ? super.getBalance() : super.getTotalAmount();
    }
}

