/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseGratuity;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"ticket"})
public class Gratuity
extends BaseGratuity {
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private transient Ticket ticket;
    private Double transactionTipsAmount;

    public Gratuity() {
    }

    public Gratuity(String string) {
        super(string);
    }

    public void calculateTransactionTips() {
        try {
            this.transactionTipsAmount = 0.0;
            String string = this.getTicketId();
            if (StringUtils.isEmpty((String)string)) {
                return;
            }
            Ticket ticket = TicketDAO.getInstance().loadCouponsAndTransactions(string);
            if (ticket == null) {
                return;
            }
            Set<PosTransaction> set = ticket.getTransactions();
            if (set != null && set.size() > 0) {
                for (PosTransaction posTransaction : set) {
                    if (posTransaction.isVoided().booleanValue()) continue;
                    if (posTransaction instanceof RefundTransaction) {
                        this.transactionTipsAmount = this.transactionTipsAmount - posTransaction.getTipsAmount();
                        continue;
                    }
                    this.transactionTipsAmount = this.transactionTipsAmount + posTransaction.getTipsAmount();
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public Double getTransactionTipsAmount() {
        if (this.transactionTipsAmount == null) {
            this.calculateTransactionTips();
        }
        return this.transactionTipsAmount;
    }

    public Ticket getTicket() {
        if (this.ticket == null && StringUtils.isNotEmpty((String)this.getTicketId())) {
            this.ticket = (Ticket)DataProvider.get().getObjectOf(Ticket.class, (Serializable)((Object)this.getTicketId()));
        }
        return this.ticket;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean bl) {
        this.syncEdited = bl;
    }
}

