/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"uniqueId"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class InventoryUnit
extends BaseInventoryUnit
implements IUnit,
TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private InventoryUnitGroup unitGroup;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public InventoryUnit() {
    }

    public InventoryUnit(String string) {
        super(string);
    }

    public InventoryUnit(String string, String string2) {
        super(string, string2);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public String getUniqueCode() {
        return super.getCode();
    }

    public InventoryUnitGroup getUnitGroup() {
        String string = this.getUnitGroupId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (this.unitGroup != null && string.equals(this.unitGroup.getId())) {
            return this.unitGroup;
        }
        this.unitGroup = InventoryUnitGroupDAO.getInstance().get(string);
        return this.unitGroup;
    }

    @XmlTransient
    public void setUnitGroup(InventoryUnitGroup inventoryUnitGroup) {
        this.unitGroup = inventoryUnitGroup;
    }

    public String getUniqueId() {
        return ("unit_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public double getBaseUnitConversionValue() {
        double d = 0.0;
        List<InventoryUnit> list = this.getUnitGroup().getUnits();
        if (list != null && list.size() > 0) {
            for (InventoryUnit inventoryUnit : list) {
                if (!inventoryUnit.isBaseUnit().booleanValue()) continue;
                d = inventoryUnit.getConversionRate();
                break;
            }
        }
        return d * this.getConversionRate();
    }
}

