/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.base.BaseKitchenTicket;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

public class KitchenTicket
extends BaseKitchenTicket {
    private static final long serialVersionUID = 1L;
    private String customerName;
    private Printer printer;
    private Ticket parentTicket;
    private Boolean filterItem;
    private Integer sortOrder;

    public KitchenTicket() {
    }

    public KitchenTicket(String string) {
        super(string);
    }

    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    public List<KitchenTicketItem> getModifiersForTicketItem(String string) {
        ArrayList<KitchenTicketItem> arrayList = new ArrayList<KitchenTicketItem>();
        List<KitchenTicketItem> list = this.getTicketItems();
        if (list != null) {
            for (KitchenTicketItem kitchenTicketItem : list) {
                if (!kitchenTicketItem.isModifierItem().booleanValue() || !string.equals(kitchenTicketItem.getTicketItemId())) continue;
                arrayList.add(kitchenTicketItem);
            }
        }
        return arrayList;
    }

    public List<KitchenTicketItem> getCookingInstructionForTicketItem(String string) {
        ArrayList<KitchenTicketItem> arrayList = new ArrayList<KitchenTicketItem>();
        List<KitchenTicketItem> list = this.getTicketItems();
        if (list != null) {
            for (KitchenTicketItem kitchenTicketItem : list) {
                if (!kitchenTicketItem.isCookingInstruction().booleanValue() || !string.equals(kitchenTicketItem.getTicketItemId())) continue;
                arrayList.add(kitchenTicketItem);
            }
        }
        return arrayList;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public List<Printer> getPrinters() {
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        PrinterGroup printerGroup = this.getPrinterGroup();
        if (printerGroup == null) {
            arrayList.addAll(posPrinters.getKitchenPrinters());
            return arrayList;
        }
        List<String> list = printerGroup.getPrinterNames();
        List<Printer> list2 = posPrinters.getKitchenPrinters();
        for (Printer printer : list2) {
            if (!list.contains(printer.getVirtualPrinter().getName())) continue;
            arrayList.add(printer);
        }
        return arrayList;
    }

    @Override
    public List<KitchenTicketItem> getTicketItems() {
        List<KitchenTicketItem> list = super.getTicketItems();
        if (list == null) {
            list = new ArrayList<KitchenTicketItem>();
            super.setTicketItems(list);
        }
        return list;
    }

    public static List<KitchenTicket> fromTicket(Ticket ticket, boolean bl) {
        return KitchenTicket.fromTicket(ticket, bl, null);
    }

    public static List<KitchenTicket> fromTicket(Ticket ticket, boolean bl, List<TicketItem> list) {
        Object object;
        Object object2;
        boolean bl2;
        HashMap<Printer, KitchenTicket> hashMap = new HashMap<Printer, KitchenTicket>();
        ArrayList<KitchenTicket> arrayList = new ArrayList<KitchenTicket>(4);
        Ticket ticket2 = (Ticket)SerializationUtils.clone((Serializable)ticket);
        boolean bl3 = bl2 = list == null;
        if (list == null) {
            list = ticket2.getTicketItems();
        }
        if (list == null) {
            return arrayList;
        }
        OrderType orderType = ticket.getOrderType();
        for (TicketItem object32 : list) {
            object2 = object32.getPrinters(orderType);
            if (bl && object32.isPrintedToKitchen().booleanValue() || !object32.isShouldPrintToKitchen().booleanValue()) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                Printer printer = (Printer)object.next();
                KitchenTicket kitchenTicket = (KitchenTicket)hashMap.get(printer);
                if (kitchenTicket == null) {
                    kitchenTicket = new KitchenTicket();
                    kitchenTicket.setPrinterGroup(object32.getPrinterGroup());
                    kitchenTicket.setTicketId(ticket.getId());
                    kitchenTicket.setTokenNo(ticket.getTokenNo());
                    kitchenTicket.setCreateDate(StoreDAO.getServerTimestamp());
                    kitchenTicket.setOrderType(orderType);
                    if (ticket.getTableNumbers() != null) {
                        kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                    }
                    kitchenTicket.setServerName(ticket.getOwner().getFirstName());
                    kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                    if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                        kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                    }
                    kitchenTicket.setPrinter(printer);
                    VirtualPrinter virtualPrinter = printer.getVirtualPrinter();
                    if (virtualPrinter != null) {
                        kitchenTicket.setPrinterName(virtualPrinter.getName());
                    }
                    hashMap.put(printer, kitchenTicket);
                }
                KitchenTicket.addKitchenItem(object32, kitchenTicket);
                KitchenTicket.includeModifiers(object32, kitchenTicket);
                object32.setPrintedToKitchen(true);
                KitchenTicket.includeCookintInstructions(object32, kitchenTicket);
            }
        }
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object2 = (KitchenTicket)iterator.next();
            ((KitchenTicket)object2).setParentTicket(ticket);
            ((KitchenTicket)object2).setFilterItem(bl);
            arrayList.add((KitchenTicket)object2);
            object = ticket.getProperty("KITCHEN_TICKET_NUMBER");
            object = object == null ? "1" : String.valueOf(Integer.valueOf((String)object) + 1);
            ticket.addProperty("KITCHEN_TICKET_NUMBER", (String)object);
            ((BaseKitchenTicket)object2).setSequenceNumber(Integer.valueOf((String)object));
        }
        if (!bl2) {
            ticket.markPrintedToKitchen(list);
        } else {
            ticket.markPrintedToKitchen();
        }
        return arrayList;
    }

    private static void addKitchenItem(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
        kitchenTicketItem.setTicketItemId(ticketItem.getId());
        kitchenTicketItem.setMenuItemCode(ticketItem.getItemCode());
        kitchenTicketItem.setVoided(ticketItem.isVoided());
        kitchenTicketItem.setVoidedItemId(ticketItem.getVoidedItemId());
        kitchenTicketItem.setMenuItemName(ticketItem.getNameDisplay());
        kitchenTicketItem.setPrintKitchenSticker(ticketItem.isPrintKitchenSticker());
        if (ticketItem.getMenuItem() == null) {
            kitchenTicketItem.setMenuItemGroupName("MISC.");
            kitchenTicketItem.setSortOrder(10001);
        } else {
            kitchenTicketItem.setMenuItemGroupName(ticketItem.getGroupName());
            kitchenTicketItem.setSortOrder(ticketItem.getTableRowNum());
        }
        kitchenTicketItem.setCourseId(ticketItem.getCourseId());
        kitchenTicketItem.setCourseName(ticketItem.getCourseName());
        kitchenTicketItem.setUnitName(ticketItem.getUnitName());
        kitchenTicketItem.setQuantity(ticketItem.getQuantity());
        kitchenTicketItem.setKitchenStatusValue(KitchenStatus.WAITING);
        kitchenTicketItem.setKitchenTicket(kitchenTicket);
        kitchenTicketItem.setSeat(ticketItem.isTreatAsSeat());
        kitchenTicketItem.setSeatNumber(ticketItem.getSeatNumber());
        kitchenTicket.addToticketItems(kitchenTicketItem);
    }

    private static void includeCookintInstructions(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        List<TicketItemCookingInstruction> list = ticketItem.getCookingInstructions();
        if (list != null) {
            for (TicketItemCookingInstruction ticketItemCookingInstruction : list) {
                KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
                kitchenTicketItem.setCookingInstruction(true);
                kitchenTicketItem.setTicketItemId(ticketItem.getId());
                kitchenTicketItem.setMenuItemName(ticketItemCookingInstruction.getNameDisplay());
                if (ticketItem.getMenuItem() == null) {
                    kitchenTicketItem.setMenuItemGroupName("MISC.");
                    kitchenTicketItem.setSortOrder(10001);
                } else {
                    kitchenTicketItem.setMenuItemGroupName(ticketItem.getGroupName());
                }
                kitchenTicketItem.setKitchenTicket(kitchenTicket);
                kitchenTicket.addToticketItems(kitchenTicketItem);
            }
        }
    }

    private static void includeModifiers(TicketItem ticketItem, KitchenTicket kitchenTicket) {
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (!ticketItemModifier.isShouldPrintToKitchen().booleanValue()) continue;
                KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
                kitchenTicketItem.setTicketItemId(ticketItem.getId());
                kitchenTicketItem.setTicketItemModifierId(ticketItemModifier.getId());
                kitchenTicketItem.setModifierItem(true);
                kitchenTicketItem.setMenuItemName(ticketItemModifier.getNameDisplay(true));
                if (ticketItem.getMenuItem() == null) {
                    kitchenTicketItem.setMenuItemGroupName("MISC.");
                    kitchenTicketItem.setSortOrder(10001);
                } else {
                    kitchenTicketItem.setMenuItemGroupName(ticketItem.getGroupName());
                }
                kitchenTicketItem.setQuantity(ticketItemModifier.getItemQuantity());
                kitchenTicketItem.setKitchenStatusValue(KitchenStatus.WAITING);
                kitchenTicketItem.setKitchenTicket(kitchenTicket);
                kitchenTicket.addToticketItems(kitchenTicketItem);
                ticketItemModifier.setPrintedToKitchen(true);
            }
        }
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String string) {
        this.customerName = string;
    }

    @XmlTransient
    @JsonIgnore
    public Ticket getParentTicket() {
        if (this.parentTicket == null) {
            this.parentTicket = TicketDAO.getInstance().get(this.getTicketId());
        }
        return this.parentTicket;
    }

    public void setParentTicket(Ticket ticket) {
        this.parentTicket = ticket;
    }

    public Boolean isFilterItem() {
        return this.filterItem;
    }

    public void setFilterItem(Boolean bl) {
        this.filterItem = bl;
    }

    public void setOrderType(OrderType orderType) {
        if (orderType != null) {
            super.setOrderTypeId(orderType.getId());
        } else {
            super.setOrderTypeId(null);
        }
    }

    public OrderType getOrderType() {
        if (StringUtils.isEmpty((String)this.getOrderTypeId())) {
            return null;
        }
        return DataProvider.get().getOrderType(this.getOrderTypeId());
    }

    public void setSortOrder(Integer n) {
        this.sortOrder = n;
    }

    public Integer getSortOrder() {
        return this.sortOrder == null ? 0 : this.sortOrder;
    }
}

