/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuItemModifierSpec;
import com.floreantpos.model.dao.ModifierGroupDAO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="menuItemModifierSpec")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"defaultModifiers", "modifiers", "modifierGroup"})
public class MenuItemModifierSpec
extends BaseMenuItemModifierSpec
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private ModifierGroup modifierGroup;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public MenuItemModifierSpec() {
    }

    public MenuItemModifierSpec(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menuitem_modifiergroup_" + this.toString() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @XmlTransient
    public List<MenuItemModifierPageItem> getMenuItemModifierPageItemsAsList() {
        return new ArrayList<MenuItemModifierPageItem>(this.getMenuItemModifierPageItemsAsSet());
    }

    @XmlTransient
    public Set<MenuItemModifierPageItem> getMenuItemModifierPageItemsAsSet() {
        Set<MenuItemModifierPage> set = this.getModifierPages();
        HashSet<MenuItemModifierPageItem> hashSet = new HashSet<MenuItemModifierPageItem>();
        if (set != null) {
            for (MenuItemModifierPage menuItemModifierPage : set) {
                if (menuItemModifierPage.getPageItems() == null) continue;
                for (MenuItemModifierPageItem menuItemModifierPageItem : menuItemModifierPage.getPageItems()) {
                    hashSet.add(menuItemModifierPageItem);
                }
            }
        }
        return hashSet;
    }

    @XmlTransient
    public Set<MenuModifier> getModifiers() {
        Set<MenuItemModifierPage> set = this.getModifierPages();
        HashSet<MenuModifier> hashSet = new HashSet<MenuModifier>();
        if (set != null) {
            for (MenuItemModifierPage menuItemModifierPage : set) {
                if (menuItemModifierPage.getPageItems() == null) continue;
                for (MenuItemModifierPageItem menuItemModifierPageItem : menuItemModifierPage.getPageItems()) {
                    MenuModifier menuModifier = menuItemModifierPageItem.getMenuModifier();
                    if (menuModifier == null) continue;
                    menuModifier.setPageItemId(menuItemModifierPageItem.getId());
                    hashSet.add(menuModifier);
                }
            }
        }
        return hashSet;
    }

    public boolean hasMenuItemModifierPageItem() {
        Set<MenuItemModifierPage> set = this.getModifierPages();
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (MenuItemModifierPage menuItemModifierPage : set) {
            List<MenuItemModifierPageItem> list = menuItemModifierPage.getPageItems();
            if (list == null && list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return super.getName();
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Set<MenuModifier> getDefaultModifiers() {
        HashSet<MenuModifier> hashSet = new HashSet<MenuModifier>();
        List<DefaultMenuModifier> list = super.getDefaultModifierList();
        if (list != null) {
            for (DefaultMenuModifier defaultMenuModifier : list) {
                hashSet.add(defaultMenuModifier.getModifier());
            }
        }
        return hashSet;
    }

    public ModifierGroup getModifierGroup() {
        if (this.modifierGroup != null) {
            return this.modifierGroup;
        }
        String string = super.getModifierGroupId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.modifierGroup = ModifierGroupDAO.getInstance().get(string);
        return this.modifierGroup;
    }

    public void setModifierGroup(ModifierGroup modifierGroup) {
        this.modifierGroup = modifierGroup;
        String string = null;
        if (modifierGroup != null) {
            string = modifierGroup.getId();
        }
        this.setModifierGroupId(string);
    }

    public MenuItemModifierSpec deepClone() throws Exception {
        Serializable serializable;
        Object object;
        MenuItemModifierSpec menuItemModifierSpec = new MenuItemModifierSpec();
        BeanUtils.copyProperties((Object)menuItemModifierSpec, (Object)this);
        menuItemModifierSpec.setId(null);
        menuItemModifierSpec.setModifierPages(null);
        menuItemModifierSpec.setDefaultModifierList(null);
        Set<MenuItemModifierPage> set = this.getModifierPages();
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                serializable = (MenuItemModifierPage)object.next();
                menuItemModifierSpec.addTomodifierPages(((MenuItemModifierPage)serializable).deepClone());
            }
        }
        if ((object = this.getDefaultModifierList()) != null) {
            serializable = new ArrayList(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DefaultMenuModifier defaultMenuModifier = (DefaultMenuModifier)iterator.next();
                DefaultMenuModifier defaultMenuModifier2 = new DefaultMenuModifier();
                BeanUtils.copyProperties((Object)defaultMenuModifier2, (Object)defaultMenuModifier);
                serializable.add(defaultMenuModifier2);
            }
            menuItemModifierSpec.setDefaultModifierList((List<DefaultMenuModifier>)((Object)serializable));
        }
        return menuItemModifierSpec;
    }
}

