/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseTicketDiscount;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.NumberUtil;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"itemCode"})
public class TicketDiscount
extends BaseTicketDiscount
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    private String ticketId;

    public TicketDiscount() {
    }

    public TicketDiscount(String string) {
        super(string);
    }

    public TicketDiscount(String string, String string2, double d, double d2, int n, Ticket ticket) {
        this.setId(string);
        this.setDiscountId(string);
        this.setName(string2);
        this.setCouponQuantity(d);
        this.setValue(d2);
        this.setType(n);
        this.setTicket(ticket);
        this.setTicketId(ticket.getId());
    }

    @Override
    public Double getCouponQuantity() {
        Double d = super.getCouponQuantity();
        if (d == 0.0) {
            return 1.0;
        }
        return d;
    }

    @Override
    public String getNameDisplay() {
        double d = this.getCouponQuantity();
        String string = d > 1.0 ? NumberUtil.trimDecilamIfNotNeeded(d) + "x " + this.getName() : this.getName().trim();
        return string;
    }

    @Override
    public String getItemCode() {
        return null;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public Boolean isPrintedToKitchen() {
        return false;
    }

    @Override
    public Double getUnitPriceDisplay() {
        return null;
    }

    @Override
    public String getItemQuantityDisplay() {
        return null;
    }

    @Override
    public Double getTaxAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public Double getTotalAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public Double getSubTotalAmountDisplay() {
        return -this.getTotalDiscountAmount().doubleValue();
    }

    @Override
    public Double getSubTotalAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public void setDiscountAmount(Double d) {
    }

    @Override
    public Double getDiscountAmount() {
        return null;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return null;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(PROP_DISCOUNT_ID, (Object)this.getDiscountId());
        jSONObject.put(PROP_NAME, (Object)this.getName());
        jSONObject.put(PROP_TYPE, (Object)this.getType());
        jSONObject.put(PROP_AUTO_APPLY, (Object)this.isAutoApply());
        jSONObject.put(PROP_COUPON_QUANTITY, (Object)this.getCouponQuantity());
        jSONObject.put(PROP_MINIMUM_AMOUNT, (Object)this.getMinimumAmount());
        jSONObject.put(PROP_VALUE, (Object)this.getValue());
        jSONObject.put(PROP_TOTAL_DISCOUNT_AMOUNT, (Object)this.getTotalDiscountAmount());
        return jSONObject;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String string) {
        this.ticketId = string;
    }
}

