/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.TipsCashoutReportData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TipsCashoutReport {
    private String server;
    private Date fromDate;
    private Date toDate;
    private Date reportTime;
    private int cashTipsCount;
    private double cashTipsAmount;
    private int chargedTipsCount;
    private double chargedTipsAmount;
    private double declaredTipsAmount;
    private double totalTips;
    private double averageTips;
    private double paidTips;
    private double tipsDue;
    private List<TipsCashoutReportData> datas;

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date date) {
        this.fromDate = date;
    }

    public Date getReportTime() {
        return this.reportTime;
    }

    public void setReportTime(Date date) {
        this.reportTime = date;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date date) {
        this.toDate = date;
    }

    public void addReportData(TipsCashoutReportData tipsCashoutReportData) {
        if (this.datas == null) {
            this.datas = new ArrayList<TipsCashoutReportData>();
        }
        this.datas.add(tipsCashoutReportData);
    }

    public List<TipsCashoutReportData> getDatas() {
        return this.datas;
    }

    public void calculateOthers() {
        if (this.datas == null) {
            return;
        }
        for (TipsCashoutReportData tipsCashoutReportData : this.datas) {
            this.cashTipsAmount += tipsCashoutReportData.getCashTips().doubleValue();
            this.chargedTipsAmount += tipsCashoutReportData.getChargedTips().doubleValue();
            this.declaredTipsAmount += tipsCashoutReportData.getDeclareTipsAmount().doubleValue();
            this.totalTips += tipsCashoutReportData.getCashTips() + tipsCashoutReportData.getChargedTips();
            this.tipsDue += tipsCashoutReportData.getCashTips() + tipsCashoutReportData.getChargedTips() - tipsCashoutReportData.getTipsPaidAmount();
        }
        this.averageTips = this.totalTips / (double)this.datas.size();
    }

    public double getAverageTips() {
        return this.averageTips;
    }

    public void setAverageTips(double d) {
        this.averageTips = d;
    }

    public int getCashTipsCount() {
        return this.cashTipsCount;
    }

    public void setCashTipsCount(int n) {
        this.cashTipsCount = n;
    }

    public int getChargedTipsCount() {
        return this.chargedTipsCount;
    }

    public void setChargedTipsCount(int n) {
        this.chargedTipsCount = n;
    }

    public double getPaidTips() {
        return this.paidTips;
    }

    public void setPaidTips(double d) {
        this.paidTips = d;
    }

    public double getTotalTips() {
        return this.totalTips;
    }

    public void setTotalTips(double d) {
        this.totalTips = d;
    }

    public double getCashTipsAmount() {
        return this.cashTipsAmount;
    }

    public void setCashTipsAmount(double d) {
        this.cashTipsAmount = d;
    }

    public double getChargedTipsAmount() {
        return this.chargedTipsAmount;
    }

    public void setChargedTipsAmount(double d) {
        this.chargedTipsAmount = d;
    }

    public double getTipsDue() {
        return this.tipsDue;
    }

    public void setTipsDue(double d) {
        this.tipsDue = d;
    }

    public double getDeclaredTipsAmount() {
        return this.declaredTipsAmount;
    }

    public void setDeclaredTipsAmount(double d) {
        this.declaredTipsAmount = d;
    }
}

