/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.Messages;
import com.floreantpos.model.Printer;
import com.floreantpos.model.base.BaseVirtualPrinter;
import java.util.Iterator;
import java.util.List;

public class VirtualPrinter
extends BaseVirtualPrinter {
    private static final long serialVersionUID = 1L;
    public static final int REPORT = 0;
    public static final int RECEIPT = 1;
    public static final int KITCHEN = 2;
    public static final int PACKING = 3;
    public static final int KITCHEN_DISPLAY = 4;
    public static final int LABEL = 5;
    public static final int STICKER = 6;
    private static Printer kdsPrinter;
    public static final String[] PRINTER_TYPE_NAMES;

    public VirtualPrinter() {
    }

    public VirtualPrinter(String string) {
        super(string);
    }

    public VirtualPrinter(String string, String string2) {
        super(string, string2);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof VirtualPrinter)) {
            return false;
        }
        VirtualPrinter virtualPrinter = (VirtualPrinter)object;
        return this.getName().equalsIgnoreCase(virtualPrinter.getName());
    }

    public String getDisplayName() {
        return PRINTER_TYPE_NAMES[this.getType()];
    }

    public static Printer getKdsPrinter() {
        if (kdsPrinter == null) {
            VirtualPrinter virtualPrinter = new VirtualPrinter();
            virtualPrinter.setName("kds");
            virtualPrinter.setType(4);
            kdsPrinter = new Printer(virtualPrinter, "kds");
        }
        return kdsPrinter;
    }

    @Override
    public String toString() {
        String string = this.getName();
        List<String> list = this.getOrderTypeNames();
        if (list != null && list.size() > 0) {
            string = string + " (";
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                string = string + string2;
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
            string = string + ")";
        }
        return string;
    }

    static {
        PRINTER_TYPE_NAMES = new String[]{Messages.getString("VirtualPrinter.0"), Messages.getString("VirtualPrinter.1"), Messages.getString("VirtualPrinter.2"), Messages.getString("VirtualPrinter.3"), "", Messages.getString("VirtualPrinter.5"), Messages.getString("VirtualPrinter.6")};
    }
}

