/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseAttendenceHistory;
import com.floreantpos.model.dao.BaseAttendenceHistoryDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.report.PayrollReportData;
import com.floreantpos.report.WeeklyPayrollReportData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class AttendenceHistoryDAO
extends BaseAttendenceHistoryDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public List<User> findNumberOfClockedInUserAtHour(Date date, Date date2, int n, Terminal terminal) {
        Session session = null;
        ArrayList<User> arrayList = new ArrayList<User>();
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date2));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_HOUR, (Object)new Short((short)n)));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            for (Object e : list) {
                AttendenceHistory attendenceHistory = (AttendenceHistory)e;
                if (!attendenceHistory.isClockedOut().booleanValue()) {
                    arrayList.add(attendenceHistory.getUser());
                    continue;
                }
                if (attendenceHistory.getClockOutHour() < n) continue;
                arrayList.add(attendenceHistory.getUser());
            }
            ArrayList<User> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.2"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List<User> findNumberOfClockedInUserAtShift(Date date, Date date2, Shift shift, Terminal terminal) {
        Session session = null;
        ArrayList<User> arrayList = new ArrayList<User>();
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date2));
            if (shift != null) {
                criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_SHIFT_ID, (Object)shift.getId()));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            for (Object e : list) {
                AttendenceHistory attendenceHistory = (AttendenceHistory)e;
                arrayList.add(attendenceHistory.getUser());
            }
            ArrayList<User> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.5"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttendenceHistory findHistoryByClockedInTime(User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            AttendenceHistory attendenceHistory = this.findHistoryByClockedInTime(user, session);
            return attendenceHistory;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public AttendenceHistory findHistoryByClockedInTime(User user, Session session) {
        Criteria criteria = session.createCriteria(AttendenceHistory.class);
        if (user != null) {
            criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
        }
        criteria.add(Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME));
        criteria.addOrder(Order.desc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
        criteria.setFirstResult(0);
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (AttendenceHistory)list.get(0);
        }
        return null;
    }

    public List<PayrollReportData> findPayroll(Date date, Date date2, User user) {
        ArrayList<PayrollReportData> arrayList = new ArrayList<PayrollReportData>();
        try (Session session = null;){
            List<Object> list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            this.populateReportDataList(arrayList, criteria.list());
            if (user != null) {
                list = user.getLinkedUser();
                for (User user2 : list) {
                    if (user2.getId().equals(user.getId())) continue;
                    criteria = session.createCriteria(AttendenceHistory.class);
                    criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
                    criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user2.getId()));
                    this.populateReportDataList(arrayList, criteria.list());
                }
            }
            list = arrayList;
            return list;
        }
    }

    private void populateReportDataList(ArrayList<PayrollReportData> arrayList, List list) {
        for (AttendenceHistory attendenceHistory : list) {
            PayrollReportData payrollReportData = new PayrollReportData();
            payrollReportData.setFrom(attendenceHistory.getClockInTime());
            payrollReportData.setTo(attendenceHistory.getClockOutTime());
            payrollReportData.setDate(attendenceHistory.getClockInTime());
            payrollReportData.setUser(attendenceHistory.getUser());
            payrollReportData.calculate();
            arrayList.add(payrollReportData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WeeklyPayrollReportData> findWeeklyPayroll(Date date, Date date2, User user, int n) {
        Session session = null;
        ArrayList<WeeklyPayrollReportData> arrayList = new ArrayList<WeeklyPayrollReportData>();
        ArrayList<Date[]> arrayList2 = new ArrayList<Date[]>();
        try {
            Date date3;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            Date[] dateArray = new Date[2];
            dateArray[0] = date;
            while (!date.after(date2)) {
                int n2 = calendar.get(7);
                int n3 = n2 - (n - 1);
                calendar.add(5, 1);
                if (n3 != 0 && !calendar.getTime().after(date2)) continue;
                calendar.add(5, -1);
                dateArray[1] = date3 = calendar.getTime();
                arrayList2.add(dateArray);
                dateArray = new Date[2];
                calendar.add(5, 1);
                dateArray[0] = date = calendar.getTime();
            }
            for (Date[] dateArray2 : arrayList2) {
                criteria = session.createCriteria(AttendenceHistory.class);
                date3 = DateUtil.startOfDay(dateArray2[0]);
                Date date4 = DateUtil.endOfDay(dateArray2[1]);
                criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date3));
                criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date4));
                criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
                criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                if (user != null) {
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
                }
                arrayList.addAll(this.populateWeeklyPayrollReportDataList(criteria.list(), date3, date4, n));
                if (user == null) continue;
                List<User> list = user.getLinkedUser();
                for (User user2 : list) {
                    if (user2.getId().equals(user.getId())) continue;
                    criteria = session.createCriteria(AttendenceHistory.class);
                    criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
                    criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user2.getId()));
                    arrayList.addAll(this.populateWeeklyPayrollReportDataList(criteria.list(), date3, date4, n));
                }
            }
            ArrayList<WeeklyPayrollReportData> arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private List<WeeklyPayrollReportData> populateWeeklyPayrollReportDataList(List list, Date date, Date date2, int n) {
        WeeklyPayrollReportData weeklyPayrollReportData;
        Object object2;
        HashMap<String, WeeklyPayrollReportData> hashMap = new HashMap<String, WeeklyPayrollReportData>();
        for (Object object2 : list) {
            weeklyPayrollReportData = (WeeklyPayrollReportData)hashMap.get(((AttendenceHistory)object2).getUser().getId());
            if (weeklyPayrollReportData == null) {
                weeklyPayrollReportData = new WeeklyPayrollReportData();
                weeklyPayrollReportData.setFirstDayOfWeek(n);
                hashMap.put(((AttendenceHistory)object2).getUser().getId(), weeklyPayrollReportData);
            }
            weeklyPayrollReportData.setTotalWorkHourMs(weeklyPayrollReportData.getTotalWorkHourMs() + (((BaseAttendenceHistory)object2).getClockOutTime().getTime() - ((BaseAttendenceHistory)object2).getClockInTime().getTime()));
            weeklyPayrollReportData.setFromDateOfWeek(date);
            weeklyPayrollReportData.setToDateOfWeek(date2);
            weeklyPayrollReportData.setUser(((AttendenceHistory)object2).getUser());
        }
        Collection collection = hashMap.values();
        object2 = collection.iterator();
        while (object2.hasNext()) {
            weeklyPayrollReportData = (WeeklyPayrollReportData)object2.next();
            weeklyPayrollReportData.calculateTotalHour();
        }
        return new ArrayList<WeeklyPayrollReportData>(collection);
    }

    public List<AttendanceReportData> findAttendance(Date date, Date date2, User user) {
        ArrayList<AttendanceReportData> arrayList = new ArrayList<AttendanceReportData>();
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME), (Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2)));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            List list = criteria.list();
            for (AttendenceHistory attendenceHistory : list) {
                AttendanceReportData attendanceReportData = new AttendanceReportData();
                attendanceReportData.setClockIn(attendenceHistory.getClockInTime());
                attendanceReportData.setClockOut(attendenceHistory.getClockOutTime());
                attendanceReportData.setUser(attendenceHistory.getUser());
                attendanceReportData.setName(attendenceHistory.getUser().getFirstName());
                attendanceReportData.calculate();
                arrayList.add(attendanceReportData);
            }
            ArrayList<AttendanceReportData> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public List<AttendenceHistory> findHistory(Date date, Date date2, User user) {
        try (Session session = null;){
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_ID));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<AttendenceHistory> findAttendanceHistory(Date date, Date date2, User user) {
        try (Session session = null;){
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)date2));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_ID));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public void saveOrUpdateAttendenceHistoryList(List<AttendenceHistory> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (AttendenceHistory attendenceHistory : list) {
                AttendenceHistory attendenceHistory2 = this.get(attendenceHistory.getId());
                if (attendenceHistory2 != null) {
                    long l = attendenceHistory2.getVersion();
                    PropertyUtils.copyProperties((Object)attendenceHistory2, (Object)attendenceHistory);
                    attendenceHistory2.setVersion(l);
                    attendenceHistory2.setUpdateLastUpdateTime(bl);
                    attendenceHistory2.setUpdateSyncTime(bl2);
                    this.update(attendenceHistory2, session);
                    continue;
                }
                attendenceHistory.setUpdateLastUpdateTime(bl);
                attendenceHistory.setUpdateSyncTime(bl2);
                this.save(attendenceHistory, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

