/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseCashDrawerDAO;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class CashDrawerDAO
extends BaseCashDrawerDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCashDrawerReport(PaginationSupport paginationSupport, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)date2));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findReports(Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)date2));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession storeSession, Boolean bl) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            if (bl != null) {
                criteria.add(bl != false ? Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME) : Restrictions.isNotNull((String)CashDrawer.PROP_REPORT_TIME));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCashDrawerIds(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)CashDrawer.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSumOfOpeningBalance(StoreSession storeSession) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
            Double d = (Double)criteria.uniqueResult();
            if (d == null) {
                double d2 = 0.0;
                return d2;
            }
            double d3 = d;
            return d3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByUnSyncStoreOperationData(StoreSession storeSession) {
        if (storeSession == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Criterion criterion = Restrictions.isNull((String)CashDrawer.PROP_LAST_UPDATE_TIME);
            Criterion criterion2 = Restrictions.isNull((String)CashDrawer.PROP_LAST_SYNC_TIME);
            PropertyExpression propertyExpression = Restrictions.gtProperty((String)CashDrawer.PROP_LAST_UPDATE_TIME, (String)CashDrawer.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{criterion, criterion2, propertyExpression}));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCashDrawer(List<CashDrawer> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CashDrawer cashDrawer : list) {
                CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
                CashDrawer cashDrawer2 = cashDrawerDAO.get(cashDrawer.getId());
                String string = cashDrawer.getAssignedUserId();
                if (cashDrawer2 != null) {
                    long l = cashDrawer2.getVersion();
                    PropertyUtils.copyProperties((Object)cashDrawer2, (Object)cashDrawer);
                    cashDrawer2.setVersion(l);
                    cashDrawer2.setAssignedUserId(string);
                    cashDrawer2.setUpdateLastUpdateTime(bl);
                    cashDrawer2.setUpdateSyncTime(bl2);
                    this.update(cashDrawer2, session);
                    continue;
                }
                cashDrawer.setUpdateLastUpdateTime(bl);
                cashDrawer.setUpdateSyncTime(bl2);
                this.save(cashDrawer, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findStaffBank(Date date, Date date2, User user) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_TYPE, (Object)DrawerType.STAFF_BANK.getTypeNumber()));
            criteria.add(Restrictions.between((String)CashDrawer.PROP_START_TIME, (Object)date, (Object)date2));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_ASSIGNED_USER_ID, (Object)user.getId()));
            }
            if (!(list = criteria.list()).isEmpty()) {
                for (CashDrawer cashDrawer : list) {
                    CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
                    cashDrawerReportService.populateReport();
                }
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }
}

