/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.BaseCurrencyDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class CurrencyDAO
extends BaseCurrencyDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOrUpdate(Currency currency) {
        Transaction transaction = null;
        try (Session session = null;){
            List<Currency> list;
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (currency.isMain().booleanValue() && (list = this.getMainCurrencies(session, currency.getId())) != null && list.size() > 0) {
                for (Currency currency2 : list) {
                    currency2.setMain(false);
                    this.update(currency2, session);
                }
            }
            this.saveOrUpdate(currency, session);
            transaction.commit();
        }
    }

    public void saveOrUpdateCurrency(List<Currency> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Currency currency : list) {
                Currency currency2 = this.get(currency.getId());
                if (currency2 != null) {
                    long l = currency2.getVersion();
                    PropertyUtils.copyProperties((Object)currency2, (Object)currency);
                    currency2.setVersion(l);
                    currency2.setUpdateLastUpdateTime(bl);
                    currency2.setUpdateSyncTime(bl2);
                    this.update(currency2, session);
                    continue;
                }
                currency.setUpdateLastUpdateTime(bl);
                currency.setUpdateSyncTime(bl2);
                this.save(currency, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        Currency currency = (Currency)object;
        if (currency == null) {
            throw new PosException(Messages.getString("CurrencyDAO.0"));
        }
        if (currency.isMain().booleanValue()) {
            throw new PosException(Messages.getString("CurrencyDAO.1"));
        }
        currency.setDeleted(true);
        this.update(currency, session);
    }

    @Override
    public List<Currency> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<Currency> getMainCurrencies(Session session, String string) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Currency.PROP_MAIN, (Object)Boolean.TRUE));
        if (string != null) {
            criteria.add((Criterion)Restrictions.ne((String)Currency.PROP_ID, (Object)string));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        return criteria.list();
    }
}

