/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseInventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class InventoryTransactionDAO
extends BaseInventoryTransactionDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction initialize(InventoryTransaction inventoryTransaction) {
        if (inventoryTransaction == null || inventoryTransaction.getId() == null) {
            return inventoryTransaction;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryTransaction);
            InventoryTransaction inventoryTransaction2 = inventoryTransaction;
            return inventoryTransaction2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventoryStock(InventoryTransaction inventoryTransaction, Session session) {
        this.adjustInventoryStock(inventoryTransaction, session, true, true);
    }

    public void adjustInventoryStock(InventoryTransaction inventoryTransaction, Session session, boolean bl, boolean bl2) {
        MenuItem menuItem = inventoryTransaction.getMenuItem();
        double d = menuItem.getBaseUnitQuantity(inventoryTransaction.getUnit());
        String string = "";
        if (menuItem.getUnit() != null) {
            string = menuItem.getUnit().getCode();
        }
        inventoryTransaction.setBaseUnit(string);
        inventoryTransaction.setBaseUnitQuantity(d);
        InventoryLocation inventoryLocation = null;
        InventoryLocation inventoryLocation2 = null;
        InventoryStock inventoryStock = null;
        double d2 = 0.0;
        PosLog.info(this.getClass(), menuItem.getDisplayName() + " |" + (Object)((Object)inventoryTransaction.getTransactionType()) + "| |" + inventoryTransaction.getQuantity() + "| " + inventoryTransaction.getReason());
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.IN) {
            inventoryLocation2 = inventoryTransaction.getToInventoryLocation();
            inventoryStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getToLocationId(), inventoryTransaction.getUnit(), session);
            d2 = this.createStockItem(inventoryTransaction, session, menuItem, d, inventoryStock, inventoryLocation2);
            this.saveOrUpdate(inventoryTransaction, session);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d2, bl, bl2, session);
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.OUT) {
            inventoryLocation = inventoryTransaction.getFromInventoryLocation();
            inventoryStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getFromLocationId(), inventoryTransaction.getUnit(), session);
            d2 = this.createStockItem(inventoryTransaction, session, menuItem, d, inventoryStock, inventoryLocation);
            InventoryTransactionDAO.getInstance().saveOrUpdate(inventoryTransaction, session);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d2, bl, bl2, session);
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.UNCHANGED) {
            inventoryLocation = inventoryTransaction.getFromInventoryLocation();
            inventoryLocation2 = inventoryTransaction.getToInventoryLocation();
            this.createStockItemForTransfer(inventoryTransaction, session, menuItem, d, inventoryTransaction.getFromLocationId(), inventoryTransaction.getToLocationId());
            InventoryTransactionDAO.getInstance().saveOrUpdate(inventoryTransaction, session);
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.CONVERSION) {
            inventoryLocation = inventoryTransaction.getFromInventoryLocation();
            inventoryLocation2 = inventoryTransaction.getToInventoryLocation();
            InventoryStock inventoryStock2 = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getFromLocationId(), inventoryTransaction.getUnit(), session);
            InventoryStock inventoryStock3 = InventoryStockDAO.getInstance().getInventoryStock(menuItem, inventoryTransaction.getToLocationId(), inventoryTransaction.getBaseUnit(), session);
            this.createConversionStockItem(inventoryTransaction, session, menuItem, d, inventoryStock2, inventoryStock3, inventoryLocation2);
            InventoryTransactionDAO.getInstance().saveOrUpdate(inventoryTransaction, session);
        }
    }

    private void createStockItemForTransfer(InventoryTransaction inventoryTransaction, Session session, MenuItem menuItem, double d, String string, String string2) {
        InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
        InventoryStock inventoryStock = inventoryStockDAO.getInventoryStock(menuItem, string, inventoryTransaction.getUnit(), session);
        InventoryStock inventoryStock2 = inventoryStockDAO.getInventoryStock(menuItem, string2, inventoryTransaction.getUnit(), session);
        if (inventoryStock == null) {
            return;
        }
        if (inventoryStock2 == null) {
            inventoryStock2 = new InventoryStock();
            inventoryStock2.setMenuItem(menuItem);
            inventoryStock2.setLocationId(string2);
            inventoryStock2.setUnit(inventoryTransaction.getUnit());
        }
        inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() - inventoryTransaction.getQuantity());
        inventoryStock2.setQuantityInHand(inventoryStock2.getQuantityInHand() + inventoryTransaction.getQuantity());
        if (inventoryStock.getQuantityInHand() == 0.0) {
            inventoryStockDAO.delete(inventoryStock, session);
        } else {
            inventoryStockDAO.saveOrUpdate(inventoryStock, session);
        }
        inventoryStockDAO.saveOrUpdate(inventoryStock2, session);
    }

    private double createStockItem(InventoryTransaction inventoryTransaction, Session session, MenuItem menuItem, double d, InventoryStock inventoryStock, InventoryLocation inventoryLocation) {
        if (inventoryStock == null) {
            inventoryStock = new InventoryStock();
            inventoryStock.setMenuItem(menuItem);
            inventoryStock.setLocationId(inventoryLocation.getId());
            inventoryStock.setUnit(inventoryTransaction.getUnit());
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.IN) {
            inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() + inventoryTransaction.getQuantity());
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.OUT) {
            inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() - inventoryTransaction.getQuantity());
        }
        double d2 = 0.0;
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.IN) {
            d2 += d * inventoryTransaction.getQuantity();
        }
        if (inventoryTransaction.getTransactionType() == InventoryTransactionType.OUT) {
            d2 -= d * inventoryTransaction.getQuantity();
        }
        InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
        if (inventoryStock.getQuantityInHand() == 0.0) {
            inventoryStockDAO.delete(inventoryStock, session);
        } else {
            inventoryStockDAO.saveOrUpdate(inventoryStock, session);
        }
        return d2;
    }

    private void createConversionStockItem(InventoryTransaction inventoryTransaction, Session session, MenuItem menuItem, double d, InventoryStock inventoryStock, InventoryStock inventoryStock2, InventoryLocation inventoryLocation) {
        if (inventoryStock2 == null) {
            inventoryStock2 = new InventoryStock();
            inventoryStock2.setMenuItem(menuItem);
            inventoryStock2.setLocationId(inventoryLocation.getId());
            inventoryStock2.setUnit(inventoryTransaction.getBaseUnit());
        }
        inventoryStock2.setQuantityInHand(inventoryStock2.getQuantityInHand() + inventoryTransaction.getQuantity() * d);
        inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() - inventoryTransaction.getQuantity());
        InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
        if (inventoryStock.getQuantityInHand() == 0.0) {
            inventoryStockDAO.delete(inventoryStock, session);
        } else {
            inventoryStockDAO.saveOrUpdate(inventoryStock, session);
        }
        inventoryStockDAO.saveOrUpdate(inventoryStock2, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInventoryTransaction(InventoryTransaction inventoryTransaction) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.adjustInventoryStock(inventoryTransaction, session);
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInventoryTransactionList(List<InventoryTransaction> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryTransaction inventoryTransaction : list) {
                this.adjustInventoryStock(inventoryTransaction, session);
                if (inventoryTransaction.getReason().equals("PURCHASE")) {
                    InventoryVendorItemsDAO.getInstance().saveItems(inventoryTransaction, session);
                    continue;
                }
                if (!inventoryTransaction.getReason().equals("NEW STOCK")) continue;
                InventoryVendorItemsDAO.getInstance().saveItems(inventoryTransaction, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInventoryTransfer(InventoryTransaction inventoryTransaction, InventoryTransaction inventoryTransaction2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            InventoryStockDAO inventoryStockDAO = InventoryStockDAO.getInstance();
            InventoryStock inventoryStock = inventoryStockDAO.getInventoryStock(inventoryTransaction.getMenuItem(), inventoryTransaction.getToLocationId(), inventoryTransaction.getUnit());
            if (inventoryStock == null) {
                inventoryStock = new InventoryStock();
                inventoryStock.setMenuItem(inventoryTransaction.getMenuItem());
                inventoryStock.setLocationId(inventoryTransaction.getToLocationId());
                inventoryStock.setQuantityInHand(inventoryTransaction.getQuantity());
                inventoryStock.setUnit(inventoryTransaction.getUnit());
            } else {
                inventoryStock.setQuantityInHand(inventoryStock.getQuantityInHand() + inventoryTransaction.getQuantity());
            }
            InventoryStock inventoryStock2 = inventoryStockDAO.getInventoryStock(inventoryTransaction2.getMenuItem(), inventoryTransaction2.getFromLocationId(), inventoryTransaction2.getUnit());
            if (inventoryStock2 == null) {
                inventoryStock2 = new InventoryStock();
                inventoryStock2.setMenuItem(inventoryTransaction2.getMenuItem());
                inventoryStock2.setLocationId(inventoryTransaction2.getFromLocationId());
                inventoryStock2.setQuantityInHand(inventoryTransaction2.getQuantity());
                inventoryStock2.setUnit(inventoryTransaction2.getUnit());
            } else {
                inventoryStock2.setQuantityInHand(inventoryStock2.getQuantityInHand() - inventoryTransaction2.getQuantity());
            }
            this.saveOrUpdate(inventoryTransaction, session);
            this.saveOrUpdate(inventoryTransaction2, session);
            inventoryStockDAO.saveOrUpdate(inventoryStock, session);
            inventoryStockDAO.saveOrUpdate(inventoryStock2, session);
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            InventoryTransaction inventoryTransaction = this.get(string, session);
            MenuItem menuItem = inventoryTransaction.getMenuItem();
            menuItem.setAvailableUnit(menuItem.getAvailableUnit() - inventoryTransaction.getQuantity());
            MenuItemDAO.getInstance().saveOrUpdate(menuItem, session);
            this.delete(inventoryTransaction, session);
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            transaction.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction getInventoryTransaction(int n) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.createAlias(InventoryTransaction.PROP_REFERENCE_NO, "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)n));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                InventoryTransaction inventoryTransaction = null;
                return inventoryTransaction;
            }
            InventoryTransaction inventoryTransaction = (InventoryTransaction)list.get(0);
            return inventoryTransaction;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurchaseOrder getPurchaseOrderId(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(PurchaseOrder.class);
            criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_ORDER_ID, (Object)string));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                PurchaseOrder purchaseOrder = null;
                return purchaseOrder;
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)list.get(0);
            return purchaseOrder;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactionsByType(String string, List<Integer> list, MenuGroup menuGroup, MenuCategory menuCategory, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "menuItem");
            criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date, (Object)date2));
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)InventoryTransaction.PROP_TYPE, list));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"menuItem.name", (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)"menuItem.sku", (Object)string)));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_GROUP_ID), (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_CATEGORY_ID), (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)"menuItem.name"));
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction findOpeningBalance(MenuItem menuItem, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_MENU_ITEM, (Object)menuItem));
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
            List list = criteria.list();
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (InventoryTransaction inventoryTransaction2 : list) {
                d += inventoryTransaction2.getQuantity().doubleValue();
                d3 += inventoryTransaction2.getTotal().doubleValue();
            }
            d2 = d3 / d;
            if (Double.isNaN(d2)) {
                d2 = 0.0;
            }
            inventoryTransaction.setQuantity(d);
            inventoryTransaction.setTotal(d3);
            inventoryTransaction.setUnitCost(d2);
            InventoryTransaction inventoryTransaction3 = inventoryTransaction;
            return inventoryTransaction3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactionsForAvgCosting(MenuGroup menuGroup, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "menuItem");
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_MENU_ITEM));
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String string, Object object, Date date, Date date2) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date, (Object)date2));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + string + "%")));
            }
            if (object instanceof InventoryLocation) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)((InventoryLocation)object).getId()));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void getInventoryTransactions(PaginationSupport paginationSupport, String string, Object object, Date date, Date date2) {
        Session session = null;
        Criteria criteria = null;
        session = this.getSession();
        criteria = session.createCriteria(InventoryTransaction.class);
        criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date, (Object)date2));
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
            criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + string + "%")));
        }
        if (object instanceof InventoryLocation) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)((InventoryLocation)object).getId()));
        }
        criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
        criteria.setMaxResults(paginationSupport.getPageSize());
        List list = criteria.list();
        paginationSupport.setRows(list);
        criteria.setProjection(Projections.rowCount());
        Number number = (Number)criteria.uniqueResult();
        if (number != null) {
            paginationSupport.setNumRows(number.intValue());
        }
    }

    public List<InventoryTransaction> getInventoryTransactionsByItemName(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.getSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + string + "%")));
            }
            if ((list = criteria.list()) == null || list.size() == 0) {
                return null;
            }
            return list;
        }
        catch (Exception exception) {
            return criteria.list();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket getTicketId(int n) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)n));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                Ticket ticket = null;
                return ticket;
            }
            Ticket ticket = (Ticket)list.get(0);
            return ticket;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findItemAvgCost(MenuItem menuItem) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_MENU_ITEM, (Object)menuItem));
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            calendar.set(5, 1);
            Date date = DateUtil.startOfDay(calendar.getTime());
            calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMaximum(5));
            Date date2 = DateUtil.endOfDay(calendar.getTime());
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_QUANTITY));
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_TOTAL));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            Object[] objectArray = (Object[])list.get(0);
            double d = 0.0;
            if (objectArray[0] != null) {
                d = ((Number)objectArray[0]).doubleValue();
            }
            double d2 = 0.0;
            if (objectArray[1] != null) {
                d2 = ((Number)objectArray[1]).doubleValue();
            }
            if (d == 0.0) {
                double d3 = 0.0;
                return d3;
            }
            double d4 = d2 / d;
            return d4;
        }
        finally {
            this.closeSession(session);
        }
    }

    public double findItemAvgCost(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
        criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)string));
        criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        Date date = DateUtil.startOfDay(calendar.getTime());
        calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        Date date2 = DateUtil.endOfDay(calendar.getTime());
        criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_QUANTITY));
        projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_TOTAL));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        Object[] objectArray = (Object[])list.get(0);
        double d = 0.0;
        if (objectArray[0] != null) {
            d = ((Number)objectArray[0]).doubleValue();
        }
        double d2 = 0.0;
        if (objectArray[1] != null) {
            d2 = ((Number)objectArray[1]).doubleValue();
        }
        if (d == 0.0) {
            return 0.0;
        }
        return d2 / d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactions(String string, InventoryTransactionType inventoryTransactionType) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (inventoryTransactionType != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)inventoryTransactionType.getType()));
            }
            if (string != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)string));
            }
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findUnsyncedByTicketId(String string) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (string != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TICKET_ID, (Object)string));
                list = Restrictions.isNull((String)InventoryTransaction.PROP_LAST_UPDATE_TIME);
                Criterion criterion = Restrictions.isNull((String)InventoryTransaction.PROP_LAST_SYNC_TIME);
                PropertyExpression propertyExpression = Restrictions.gtProperty((String)InventoryTransaction.PROP_LAST_UPDATE_TIME, (String)InventoryTransaction.PROP_LAST_SYNC_TIME);
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{list, criterion, propertyExpression}));
            }
            list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

