/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.dao.BaseInventoryUnitDAO;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryUnitDAO
extends BaseInventoryUnitDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        InventoryUnit inventoryUnit = (InventoryUnit)object;
        if (this.isInventoryUnitUsed(inventoryUnit)) {
            throw new PosException("This unit is in use and cannot be deleted.");
        }
        super.delete(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(InventoryUnit inventoryUnit, String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(InventoryUnit.class);
            if (inventoryUnit.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)InventoryUnit.PROP_ID, (Object)inventoryUnit.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)string).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null && number.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(PackagingUnit.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)string).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            number = (Number)criteria.uniqueResult();
            if (number != null && number.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryUnit> findByGroupId(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_UNIT_GROUP_ID, (Object)string));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnit findByCode(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                InventoryUnit inventoryUnit = (InventoryUnit)list.get(0);
                return inventoryUnit;
            }
            criteria = session.createCriteria(PackagingUnit.class);
            criteria.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_CODE, (Object)string));
            list = criteria.list();
            if (list != null && !list.isEmpty()) {
                PackagingUnit packagingUnit = (PackagingUnit)list.get(0);
                return packagingUnit;
            }
            criteria = session.createCriteria(InventoryStockUnit.class);
            criteria.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_CODE, (Object)string));
            list = criteria.list();
            if (list != null && !list.isEmpty()) {
                InventoryStockUnit inventoryStockUnit = (InventoryStockUnit)list.get(0);
                return inventoryStockUnit;
            }
            IUnit iUnit = null;
            return iUnit;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryUnit findByName(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                InventoryUnit inventoryUnit = (InventoryUnit)list.get(0);
                return inventoryUnit;
            }
            InventoryUnit inventoryUnit = null;
            return inventoryUnit;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInventoryUnitUsed(InventoryUnit inventoryUnit) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_UNIT_NAME, (Object)inventoryUnit.getCode()));
            criteria.setProjection(Projections.rowCount());
            Object object = criteria.uniqueResult();
            if (POSUtil.getInteger(object) > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(InventoryStock.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_UNIT, (Object)inventoryUnit.getCode()));
            criteria.setProjection(Projections.rowCount());
            Object object2 = criteria.uniqueResult();
            if (POSUtil.getInteger(object2) > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_UNIT, (Object)inventoryUnit.getCode()));
            criteria.setProjection(Projections.rowCount());
            Object object3 = criteria.uniqueResult();
            if (POSUtil.getInteger(object3) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    public void saveOrUpdateInventoryUnits(List<InventoryUnit> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryUnit inventoryUnit : list) {
                InventoryUnit inventoryUnit2 = this.get(inventoryUnit.getId());
                if (inventoryUnit2 != null) {
                    long l = inventoryUnit2.getVersion();
                    PropertyUtils.copyProperties((Object)inventoryUnit2, (Object)inventoryUnit);
                    inventoryUnit2.setVersion(l);
                    inventoryUnit2.setUpdateLastUpdateTime(bl);
                    inventoryUnit2.setUpdateSyncTime(bl2);
                    this.update(inventoryUnit2, session);
                    continue;
                }
                inventoryUnit.setUpdateLastUpdateTime(bl);
                inventoryUnit.setUpdateSyncTime(bl2);
                this.save(inventoryUnit, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

