/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.BaseInventoryUnitGroupDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class InventoryUnitGroupDAO
extends BaseInventoryUnitGroupDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)object;
        List<InventoryUnit> list = inventoryUnitGroup.getUnits();
        if (!list.isEmpty() && list != null) {
            throw new PosException("Group is not empty and cannot be deleted");
        }
        super.delete(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryUnitGroup findByName(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            InventoryUnitGroup inventoryUnitGroup = this.findByName(string, session);
            return inventoryUnitGroup;
        }
        finally {
            this.closeSession(session);
        }
    }

    public InventoryUnitGroup findByName(String string, Session session) {
        if (session == null) {
            session = this.getSession();
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)InventoryUnitGroup.PROP_NAME, (Object)string));
        return (InventoryUnitGroup)criteria.uniqueResult();
    }

    public void saveOrUpdateInventoryUnitGroups(List<InventoryUnitGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryUnitGroup inventoryUnitGroup : list) {
                InventoryUnitGroup inventoryUnitGroup2 = this.get(inventoryUnitGroup.getId());
                if (inventoryUnitGroup2 != null) {
                    long l = inventoryUnitGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)inventoryUnitGroup2, (Object)inventoryUnitGroup);
                    inventoryUnitGroup2.setVersion(l);
                    inventoryUnitGroup2.setUpdateLastUpdateTime(bl);
                    inventoryUnitGroup2.setUpdateSyncTime(bl2);
                    this.update(inventoryUnitGroup2, session);
                    continue;
                }
                inventoryUnitGroup.setUpdateLastUpdateTime(bl);
                inventoryUnitGroup.setUpdateSyncTime(bl2);
                this.save(inventoryUnitGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

