/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableTicket;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.base.BaseShopTableTicket;
import com.floreantpos.model.dao.BaseShopTableDAO;
import com.floreantpos.model.dao.BaseShopTableStatusDAO;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.util.CopyUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ShopTableStatusDAO
extends BaseShopTableStatusDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        ShopTableStatus shopTableStatus = (ShopTableStatus)object;
        shopTableStatus.setLastUpdateTime(new Date());
        this.updateTime(shopTableStatus);
        Serializable serializable = super.save(object, session);
        this.publishOnMqtt(shopTableStatus);
        return serializable;
    }

    @Override
    protected void update(Object object, Session session) {
        ShopTableStatus shopTableStatus = (ShopTableStatus)object;
        shopTableStatus.setLastUpdateTime(new Date());
        this.updateTime(shopTableStatus);
        super.update(object, session);
        this.publishOnMqtt(shopTableStatus);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        ShopTableStatus shopTableStatus = (ShopTableStatus)object;
        shopTableStatus.setLastUpdateTime(new Date());
        this.updateTime(shopTableStatus);
        super.saveOrUpdate(object, session);
        this.publishOnMqtt(shopTableStatus);
    }

    private void publishOnMqtt(ShopTableStatus shopTableStatus) {
        if (!shopTableStatus.isShouldPublishMqtt()) {
            return;
        }
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "1");
    }

    public void addTicketsToShopTableStatus(List<Integer> list, List<Ticket> list2, Session session) {
        if (list == null || list.isEmpty() || list2 == null) {
            return;
        }
        for (Integer n : list) {
            ShopTableStatus shopTableStatus = this.get(n);
            if (shopTableStatus == null) {
                shopTableStatus = new ShopTableStatus();
                shopTableStatus.setId(n);
            }
            shopTableStatus.setTableStatus(TableStatus.Serving);
            shopTableStatus.addToTableTickets(list2);
            if (session == null) {
                this.saveOrUpdate(shopTableStatus);
                continue;
            }
            this.saveOrUpdate(shopTableStatus, session);
        }
    }

    public void removeTicketFromShopTableStatus(Ticket ticket, Session session) {
        if (ticket == null) {
            return;
        }
        List<Integer> list = ticket.getTableNumbers();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Integer n : list) {
            Comparable comparable;
            Object object;
            ShopTableStatus shopTableStatus;
            ShopTableStatus shopTableStatus2 = shopTableStatus = session == null ? this.get(n) : this.get(n, session);
            if (shopTableStatus == null) {
                return;
            }
            List<ShopTableTicket> list2 = shopTableStatus.getTicketNumbers();
            if (list2 != null) {
                object = list2.iterator();
                while (object.hasNext()) {
                    comparable = object.next();
                    if (!((BaseShopTableTicket)comparable).getTicketId().equals(ticket.getId())) continue;
                    object.remove();
                }
            }
            shopTableStatus.setTicketNumbers(list2);
            if (list2 == null || list2.isEmpty()) {
                shopTableStatus.setTicketNumbers(null);
                shopTableStatus.setTableStatus(TableStatus.Available);
                shopTableStatus.removeProperty("seat.time");
            }
            if ((comparable = ((BaseShopTableDAO)(object = ShopTableDAO.getInstance())).get(n)) != null && ((BaseShopTable)comparable).getCurrentBookingId() != null) {
                BookingInfoDAO bookingInfoDAO = BookingInfoDAO.getInstance();
                BookingInfo bookingInfo = bookingInfoDAO.get(((BaseShopTable)comparable).getCurrentBookingId());
                if (bookingInfo != null) {
                    bookingInfo.setStatus("close");
                    bookingInfo.setClosed(true);
                    bookingInfoDAO.saveOrUpdate(bookingInfo);
                }
                ((BaseShopTable)comparable).setCurrentBookingId(null);
                ((BaseShopTable)comparable).setCustomerName(null);
                ((ShopTable)comparable).removeProperty("RES_NO");
                ((BaseShopTableDAO)object).update((ShopTable)comparable, session);
            }
            shopTableStatus.setShouldPublishMqtt(ticket.isShouldPublishMqtt());
            if (session == null) {
                ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus);
                continue;
            }
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
        }
    }

    public void saveShopTableStatus(ShopTableStatus shopTableStatus, boolean bl, boolean bl2) throws Exception {
        if (shopTableStatus == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            ShopTableStatus shopTableStatus2 = this.get(shopTableStatus.getId());
            if (shopTableStatus2 == null) {
                shopTableStatus.setUpdateLastUpdateTime(bl);
                shopTableStatus.setUpdateSyncTime(bl2);
                this.save(shopTableStatus, session);
            }
            transaction.commit();
        }
    }

    public ShopTableStatus updateVersionOfShopTableStatus(ShopTableStatus shopTableStatus) throws Exception {
        ShopTableStatus shopTableStatus2 = ShopTableStatusDAO.getInstance().get(shopTableStatus.getId());
        if (shopTableStatus2 != null) {
            long l = shopTableStatus2.getVersion();
            CopyUtil.deepCopy(shopTableStatus);
            shopTableStatus.setVersion(l);
        }
        return shopTableStatus;
    }

    public void saveOrUpdateShopTableStatus(List<ShopTableStatus> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : list) {
                shopTableStatus.setShouldPublishMqtt(false);
                ShopTableStatus shopTableStatus2 = this.get(shopTableStatus.getId());
                if (shopTableStatus2 != null) {
                    long l = shopTableStatus2.getVersion();
                    CopyUtil.deepCopy(shopTableStatus);
                    shopTableStatus.setVersion(l);
                    shopTableStatus.setUpdateLastUpdateTime(bl);
                    shopTableStatus.setUpdateSyncTime(bl2);
                    this.update(shopTableStatus, session);
                    continue;
                }
                shopTableStatus.setUpdateLastUpdateTime(bl);
                shopTableStatus.setUpdateSyncTime(bl2);
                this.save(shopTableStatus, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findOpenTickets(ShopTableStatus shopTableStatus) {
        return this.findTickets(shopTableStatus, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTickets(ShopTableStatus shopTableStatus, Boolean bl) {
        if (shopTableStatus == null) {
            return null;
        }
        List<String> list = shopTableStatus.getListOfTicketNumbers();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add(Restrictions.in((String)Ticket.PROP_ID, list));
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false));
            }
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }
}

