/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.Messages;
import com.floreantpos.model.dao.StoreDAO;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DateUtil {
    private static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("hh:mm a");
    private static final SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd MMM yy, hh:mm a");
    private static final SimpleDateFormat dateFormat3 = new SimpleDateFormat("MMM d h:mm:ss a");
    private static final SimpleDateFormat dateFormat4 = new SimpleDateFormat("MM/dd/YYYY");
    private static final SimpleDateFormat dateFormat5 = new SimpleDateFormat("dd MMM yy");
    private static final SimpleDateFormat dateFormat6 = new SimpleDateFormat("MMM dd, hh:mm a");
    private static final SimpleDateFormat dateFormat7 = new SimpleDateFormat("dd MMM, hh:mm:ss a");
    private static final SimpleDateFormat usFormat = new SimpleDateFormat("MM/dd/yy hh:mm a");
    private static final SimpleDateFormat dateFormat9 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static final DateFormat localeFormat = DateFormat.getDateInstance(3);

    public static String formatDateAsLocale(Date date) {
        String string = localeFormat.format(date);
        return string;
    }

    public static String formatReportDateAsString(Date date) {
        String string = usFormat.format(date);
        return string;
    }

    public static String formatDateAsString(Date date) {
        String string = dateFormat9.format(date);
        return string;
    }

    public static String formatDateAsUTCString(Date date) {
        dateFormat9.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = dateFormat9.format(date);
        return string;
    }

    public static Date parseByFullDate(String string) throws Exception {
        return dateFormat9.parse(string);
    }

    public static String formatFullDateAsString(Date date) {
        String string = dateFormat5.format(date);
        return string;
    }

    public static Date parseBySortDate(String string) throws Exception {
        return dateFormat5.parse(string);
    }

    public static Date startOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date == null ? new Date() : date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date == null ? new Date() : date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date startOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(5, 1);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(5, calendar.getActualMaximum(5));
        return new Date(calendar.getTimeInMillis());
    }

    public static Date copyTime(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        calendar.setTime(date);
        calendar.set(11, n);
        calendar.set(12, n2);
        return calendar.getTime();
    }

    public static boolean between(Date date, Date date2, Date date3) {
        if (date == null || date2 == null) {
            return false;
        }
        return !(!date3.equals(date) && !date3.after(date) || !date3.equals(date2) && !date3.before(date2));
    }

    public static String formatSmall(Date date) {
        return dateFormat6.format(date);
    }

    public static String getReportDate() {
        String string = dateFormat3.format(new Date());
        return string;
    }

    public static boolean isToday(Date date) {
        return DateUtil.isSameDay(date, Calendar.getInstance().getTime());
    }

    public static boolean isToday(Calendar calendar) {
        return DateUtil.isSameDay(calendar, Calendar.getInstance());
    }

    public static String formatAsTodayDate(Date date) {
        String string = dateFormat1.format(date);
        return Messages.getString("DateUtil.2") + " " + string;
    }

    public static String formatFullDateAndTimeAsString(Date date) {
        String string = dateFormat2.format(date);
        return string;
    }

    public static String formatFullDateAndTimeWithoutYearAsString(Date date) {
        String string = dateFormat7.format(date);
        return string;
    }

    public static boolean isSameDay(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtil.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static String getOnlyFormattedTime(Date date) {
        String string = dateFormat1.format(date);
        return string;
    }

    public static String getOnlyFormattedDate(Date date) {
        String string = dateFormat4.format(date);
        return string;
    }

    public static String getElapsedTime(Date date, Date date2) {
        DateTime dateTime = new DateTime((Object)date);
        DateTime dateTime2 = new DateTime((Object)date2);
        Interval interval = new Interval((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
        long l = interval.toDuration().getStandardDays();
        long l2 = interval.toDuration().getStandardHours();
        long l3 = interval.toDuration().getStandardMinutes();
        long l4 = interval.toDuration().getStandardSeconds();
        String string = l + "d, ";
        String string2 = (l2 %= 24L) + "hr, ";
        String string3 = (l3 %= 60L) + "mn";
        String string4 = (l4 %= 60L) + "secs";
        String string5 = "";
        String string6 = string + string2 + string3 + string5;
        String string7 = string2 + string3 + string5;
        String string8 = string3 + string5;
        String string9 = string4 + string5;
        if (l != 0L) {
            return string6;
        }
        if (l2 != 0L) {
            return string7;
        }
        if (l3 != 0L) {
            return string8;
        }
        if (l4 != 0L) {
            return string9;
        }
        return "not printed yet";
    }

    public static Calendar getLocalTimeCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getServerTimeCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(StoreDAO.getServerTimestamp());
        return calendar;
    }

    public static Date getGmtTime() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
    }

    public static Calendar getGmtCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }
}

