/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.CurrencyUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;

public class OpenTicketSummaryReport
extends Report {
    @Override
    public void refresh() throws Exception {
        List<Ticket> list = TicketDAO.getInstance().findOpenTickets(this.getTerminal(), this.getUserType());
        TicketReportModel ticketReportModel = new TicketReportModel();
        ticketReportModel.setItems(list);
        ticketReportModel.calculateGrandTotal();
        ticketReportModel.calculateTotalDue();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("reportTitle", Messages.getString("OpenTicketSummaryReport.0"));
        hashMap.put("reportTime", ReportService.formatFullDate(new Date()));
        String string = "<b>" + Messages.getString("OpenTicketSummaryReport.2") + "</b> " + (this.getUserType() == null ? POSConstants.ALL : this.getUserType().getName());
        string = string + " <b>" + Messages.getString("OpenTicketSummaryReport.5") + "</b> " + (this.getTerminal() == null ? POSConstants.ALL : this.getTerminal().getName());
        string = string + " <b>" + Messages.getString("OpenTicketSummaryReport.8") + "</b> " + Messages.getString("SalesReport.8") + CurrencyUtil.getCurrencyName() + " (" + CurrencyUtil.getCurrencySymbol() + ")";
        hashMap.put("userTypeTerminalCurrency", string);
        hashMap.put("grandTotal", ticketReportModel.getGrandTotalAsString());
        hashMap.put("totalDue", ticketReportModel.getTotalDueAsString());
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("open_ticket_summary_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)ticketReportModel));
        this.viewer = new JRViewer(jasperPrint);
    }

    @Override
    public boolean isDateRangeSupported() {
        return false;
    }

    @Override
    public boolean isTypeSupported() {
        return false;
    }
}

