/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesBalanceReportView
extends JPanel {
    private SimpleDateFormat a = new SimpleDateFormat("dd MMM yyyy, hh:mm a");
    private JXDatePicker b = UiUtil.getCurrentMonthStart();
    private JXDatePicker c = UiUtil.getCurrentMonthEnd();
    private JComboBox d;
    private JButton e;
    private JButton f = new JButton(POSConstants.GO);
    private JPanel g;
    private JComboBox<Date> h;
    private JComboBox<Date> i;

    public SalesBalanceReportView() throws ParseException {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.e = new JButton(POSConstants.TODAYS_REPORT.toUpperCase());
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Date date = new Date();
                    Date date2 = new Date();
                    Date date3 = (Date)SalesBalanceReportView.this.h.getSelectedItem();
                    Date date4 = (Date)SalesBalanceReportView.this.i.getSelectedItem();
                    date = DateUtil.copyTime(date, date3);
                    date2 = DateUtil.copyTime(date2, date4);
                    SalesBalanceReportView.this.a(date, date2);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        this.d = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.d.setModel(new DefaultComboBoxModel(vector));
        TimeComboBox timeComboBox = new TimeComboBox();
        this.h = timeComboBox.getDefaultTimeComboBox();
        this.h.setSelectedIndex(16);
        this.i = timeComboBox.getDefaultTimeComboBox();
        this.i.setSelectedIndex(44);
        jPanel.add(new JLabel(POSConstants.FROM + ":"));
        jPanel.add((Component)this.b);
        jPanel.add(this.h);
        jPanel.add(new JLabel(POSConstants.TO + ":"));
        jPanel.add((Component)this.c);
        jPanel.add(this.i);
        jPanel.add(new JLabel(POSConstants.USER + ":"));
        jPanel.add(this.d);
        jPanel.add((Component)this.f, "width 60!");
        jPanel.add(this.e);
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.g = new JPanel(new BorderLayout());
        jPanel2.add(this.g);
        this.add(jPanel2);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Date date = SalesBalanceReportView.this.b.getDate();
                    Date date2 = SalesBalanceReportView.this.c.getDate();
                    Date date3 = (Date)SalesBalanceReportView.this.h.getSelectedItem();
                    Date date4 = (Date)SalesBalanceReportView.this.i.getSelectedItem();
                    date = DateUtil.copyTime(date, date3);
                    date2 = DateUtil.copyTime(date2, date4);
                    SalesBalanceReportView.this.a(date, date2);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(SalesBalanceReportView.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
    }

    private void a(Date date, Date date2) throws Exception {
        if (date.after(date2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        User user = null;
        if (!this.d.getSelectedItem().equals(POSConstants.ALL)) {
            user = (User)this.d.getSelectedItem();
        }
        ReportService reportService = new ReportService();
        SalesBalanceReport salesBalanceReport = reportService.getSalesBalanceReport(date, date2, user);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("fromTime", date.getTime());
        hashMap.put("toTime", date2.getTime());
        hashMap.put("fromDate", this.a.format(date));
        hashMap.put("toDate", this.a.format(date2));
        hashMap.put("reportTime", this.a.format(new Date()));
        hashMap.put("userName", user == null ? POSConstants.ALL : user.getFullName());
        hashMap.put("grossTaxableSales", NumberUtil.formatNumber(salesBalanceReport.getGrossTaxableSalesAmount()));
        hashMap.put("grossNonTaxableSales", NumberUtil.formatNumber(salesBalanceReport.getGrossNonTaxableSalesAmount()));
        hashMap.put("discounts", NumberUtil.formatNumber(salesBalanceReport.getDiscountAmount()));
        hashMap.put("netSales", NumberUtil.formatNumber(salesBalanceReport.getNetSalesAmount()));
        hashMap.put("salesTaxes", NumberUtil.formatNumber(salesBalanceReport.getSalesTaxAmount()));
        hashMap.put("totalRevenues", NumberUtil.formatNumber(salesBalanceReport.getTotalRevenueAmount()));
        hashMap.put("giftCertSold", NumberUtil.formatNumber(salesBalanceReport.getGiftCertSalesAmount()));
        hashMap.put("payIns", NumberUtil.formatNumber(salesBalanceReport.getPayInsAmount()));
        hashMap.put("cashTips", NumberUtil.formatNumber(salesBalanceReport.getCashTipsAmount()));
        hashMap.put("chargedTips", NumberUtil.formatNumber(salesBalanceReport.getChargedTipsAmount()));
        hashMap.put("grossReceipts", NumberUtil.formatNumber(salesBalanceReport.getGrossReceiptsAmount()));
        hashMap.put("cashReceipts", NumberUtil.formatNumber(salesBalanceReport.getCashReceiptsAmount()));
        hashMap.put("creditCardReceipts", NumberUtil.formatNumber(salesBalanceReport.getCreditCardReceiptsAmount()));
        hashMap.put("debitCardReceipts", NumberUtil.formatNumber(salesBalanceReport.getDebitCardReceiptsAmount()));
        hashMap.put("memberPaymentReceipts", NumberUtil.formatNumber(salesBalanceReport.getMemberPaymentAmount()));
        hashMap.put("customPayment", NumberUtil.formatNumber(salesBalanceReport.getCustomPaymentAmount()));
        hashMap.put("grossTipsPaid", NumberUtil.formatNumber(salesBalanceReport.getGrossTipsPaidAmount()));
        hashMap.put("arReceipts", NumberUtil.formatNumber(salesBalanceReport.getArReceiptsAmount()));
        hashMap.put("giftCertReceipts", NumberUtil.formatNumber(salesBalanceReport.getGiftCertReceipts()));
        hashMap.put("cashBack", NumberUtil.formatNumber(salesBalanceReport.getCashBackAmount()));
        hashMap.put("cashRefund", NumberUtil.formatNumber(salesBalanceReport.getCashRefundAmount()));
        hashMap.put("receiptDiff", NumberUtil.formatNumber(salesBalanceReport.getReceiptDiffAmount()));
        hashMap.put("cashPayout", NumberUtil.formatNumber(salesBalanceReport.getCashPayoutAmount()));
        hashMap.put("cashAccountable", NumberUtil.formatNumber(salesBalanceReport.getCashAccountableAmount()));
        hashMap.put("drawerPulls", NumberUtil.formatNumber(salesBalanceReport.getDrawerPullsAmount()));
        hashMap.put("coCurrent", NumberUtil.formatNumber(salesBalanceReport.getCoCurrentAmount()));
        hashMap.put("coPrevious", NumberUtil.formatNumber(salesBalanceReport.getCoPreviousAmount()));
        hashMap.put("coOverShort", NumberUtil.formatNumber(salesBalanceReport.getOverShortAmount()));
        hashMap.put("serviceCharge", NumberUtil.formatNumber(salesBalanceReport.getServiceChargeAmnt()));
        hashMap.put("toleranceAmount", NumberUtil.formatNumber(salesBalanceReport.getToleranceAmount(), true));
        hashMap.put("days", String.valueOf((int)((double)(date2.getTime() - date.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1));
        hashMap.put("visaCreditCardSum", NumberUtil.formatNumber(salesBalanceReport.getVisaCreditCardAmount()));
        hashMap.put("mastercardSum", NumberUtil.formatNumber(salesBalanceReport.getMasterCardAmount()));
        hashMap.put("amexSum", NumberUtil.formatNumber(salesBalanceReport.getAmexAmount()));
        hashMap.put("discoverySum", NumberUtil.formatNumber(salesBalanceReport.getDiscoveryAmount()));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_balance_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JREmptyDataSource());
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.g.removeAll();
        this.g.add((Component)jRViewer);
        this.g.revalidate();
    }
}

