/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.ui.ticket.TicketItemRowCreator;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class TicketDataSource
extends AbstractReportDataSource {
    public TicketDataSource() {
        super(new String[]{"itemName", "itemQty", "itemSubtotal"});
    }

    public TicketDataSource(Ticket ticket) {
        super(new String[]{"itemName", "itemQty", "itemSubtotal"});
        this.a(ticket);
    }

    private void a(Ticket ticket) {
        Collections.sort(ticket.getTicketItems(), new Comparator<TicketItem>(){

            @Override
            public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                return ticketItem.isVoided().compareTo(ticketItem2.isVoided());
            }
        });
        ArrayList<ITicketItem> arrayList = new ArrayList<ITicketItem>();
        LinkedHashMap<String, ITicketItem> linkedHashMap = new LinkedHashMap<String, ITicketItem>();
        TicketItemRowCreator.calculateTicketRows(ticket, linkedHashMap, true, false, true);
        arrayList.addAll(linkedHashMap.values());
        this.setRows(arrayList);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Comparable comparable;
        ITicketItem iTicketItem = (ITicketItem)this.rows.get(n);
        if (iTicketItem instanceof TicketItem) {
            comparable = (TicketItem)iTicketItem;
            comparable.setIncludeVoidQuantity(true);
        }
        switch (n2) {
            case 0: {
                return iTicketItem.getNameDisplay();
            }
            case 1: {
                return "";
            }
            case 2: {
                comparable = iTicketItem.getSubTotalAmountDisplay();
                if (comparable == null) {
                    return null;
                }
                return NumberUtil.formatNumberAcceptNegative((Double)comparable);
            }
        }
        return null;
    }
}

