/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.base.BaseStoreSession;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PosTransactionService {
    private static PosTransactionService a = new PosTransactionService();

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user) throws Exception {
        this.settleTicket(ticket, posTransaction, user, null);
    }

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user, PostPaymentProcessor postPaymentProcessor) throws Exception {
        Object object;
        if (user == null) {
            user = Application.getCurrentUser();
        }
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Session session = null;
        Transaction transaction = null;
        try {
            Object object2;
            object = StoreDAO.getServerTimestamp();
            session = TerminalDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            if (terminal.isEnableMultiCurrency().booleanValue()) {
                session.saveOrUpdate((Object)user.getActiveDrawerPullReport());
            }
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + posTransaction.getAmount());
            if (ticket.isSourceOnline()) {
                ticket.setDueAmount(ticket.getTotalAmountWithTips() - ticket.getPaidAmount());
            } else {
                ticket.calculatePrice();
            }
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setPaid(true);
                this.a(ticket, (Date)object);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(user.getActiveDrawerPullReport());
            posTransaction.setTransactionTime((Date)object);
            posTransaction.setCustomerId(ticket.getCustomerId());
            StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
            if (storeSessionControl != null && (object2 = storeSessionControl.getCurrentData()) != null) {
                posTransaction.setStoreSessionId(((BaseStoreSession)object2).getId());
            }
            ticket.setCashier(user);
            if (posTransaction.getAmount() > 0.0) {
                ticket.addTotransactions(posTransaction);
            }
            this.a(ticket, posTransaction);
            this.b(ticket, posTransaction);
            posTransaction.calculateTaxAmount();
            posTransaction.calculateServiceChargeAmount();
            if (ticket.getOrderType() != null && ticket.getOrderType().getName() == "BAR_TAB") {
                ticket.removeProperty("payment_method");
                ticket.removeProperty("card_name");
                ticket.removeProperty("card_transaction_id");
                ticket.removeProperty("card_tracks");
                ticket.removeProperty("card_reader");
                ticket.removeProperty("advance_payment");
                ticket.removeProperty("card_number");
                ticket.removeProperty("card_exp_year");
                ticket.removeProperty("card_exp_month");
                ticket.removeProperty("card_auth_code");
            }
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (postPaymentProcessor != null) {
                postPaymentProcessor.paymentDone(posTransaction, session);
            }
            if ((object2 = ticket.getProperty("cardNumber")) != null) {
                GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber((String)object2);
                posTransaction.setTransactionType(TransactionType.CREDIT.name());
                posTransaction.setGiftCertNumber((String)object2);
                Double d = ticket.getTotalAmountWithTips();
                giftCard.setBalance(giftCard.getBalance() + d);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                PosLog.error(PosTransactionService.class, exception2);
                exception2.printStackTrace();
            }
            throw exception;
        }
        finally {
            TerminalDAO.getInstance().closeSession(session);
        }
        object = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId();
        object = (String)object + ";" + POSConstants.TOTAL + ":" + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
        ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.SETTLE_CHECK, (String)object);
    }

    private void a(Ticket ticket, PosTransaction posTransaction) {
        double d;
        double d2 = 0.0;
        Currency currency = CurrencyUtil.getMainCurrency();
        if (currency != null) {
            d2 = currency.getTolerance();
        }
        if (ticket.getRoundedDueAmount() == 0.0 || ticket.getRoundedDueAmount() <= d2) {
            posTransaction.setToleranceAmount(ticket.getToleranceAmount());
        }
        if ((d = NumberUtil.round(posTransaction.getTenderAmount() - posTransaction.getAmount())) == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        double d3 = store.isAllowPenyRounding() ? (double)Math.round(d * 100.0 / 5.0) * 5.0 / 100.0 : d;
        double d4 = d - d3;
        if (Math.abs(d3) <= d2) {
            posTransaction.setToleranceAmount(d);
            posTransaction.setChangeAmount(0.0);
        } else {
            posTransaction.setToleranceAmount(d4);
            posTransaction.setChangeAmount(d3);
        }
        posTransaction.setAmount(posTransaction.getAmount() + posTransaction.getToleranceAmount());
    }

    public void settleBarTabTicket(Ticket ticket, PosTransaction posTransaction, boolean bl, User user) throws Exception {
        Object object;
        Application application = Application.getInstance();
        Terminal terminal = application.refreshAndGetTerminal();
        Session session = null;
        Transaction transaction = null;
        GenericDAO genericDAO = new GenericDAO();
        try {
            object = StoreDAO.getServerTimestamp();
            session = genericDAO.createNewSession();
            transaction = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + posTransaction.getAmount());
            ticket.calculatePrice();
            if (bl) {
                ticket.setPaid(true);
                this.a(ticket, (Date)object);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(user.getActiveDrawerPullReport());
            posTransaction.setTransactionTime((Date)object);
            ticket.setCashier(user);
            ticket.addTotransactions(posTransaction);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            genericDAO.closeSession(session);
        }
        object = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId();
        object = (String)object + ";" + POSConstants.TOTAL + ":" + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
        ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.SETTLE_CHECK, (String)object);
    }

    private void a(Ticket ticket, Date date) {
        OrderType orderType = ticket.getOrderType();
        if (orderType.isCloseOnPaid().booleanValue() || orderType.isBarTab().booleanValue()) {
            ticket.setClosed(true);
            ticket.setClosingDate(date);
        }
    }

    private void b(Ticket ticket, PosTransaction posTransaction) {
        double d = ticket.getGratuityAmount();
        if (d <= 0.0) {
            return;
        }
        double d2 = 0.0;
        Set<PosTransaction> set = ticket.getTransactions();
        if (set != null && set.size() > 0) {
            for (PosTransaction posTransaction2 : set) {
                if (posTransaction2 instanceof RefundTransaction || posTransaction2.isVoided().booleanValue()) continue;
                d2 += posTransaction2.getTipsAmount().doubleValue();
            }
        }
        double d3 = d - d2;
        double d4 = d3 + ticket.getPaidAmount() - ticket.getTotalAmountWithTips();
        if (d3 > 0.0) {
            if (ticket.getDueAmount() == 0.0) {
                posTransaction.setTipsAmount(d3);
            } else if (d4 > 0.0) {
                Double d5 = posTransaction.getAmount();
                if (d4 > d5) {
                    posTransaction.setTipsAmount(d5);
                } else {
                    posTransaction.setTipsAmount(NumberUtil.roundToTwoDigit(d4));
                }
            }
        }
    }

    public void voidTicket(Ticket ticket, User user) throws Exception {
        Terminal terminal = Application.getInstance().getTerminal();
        ticket.setVoidedBy(user);
        ticket.setTerminal(terminal);
        ticket.calculatePrice();
        TicketDAO.getInstance().voidTicket(ticket);
        try {
            ReceiptPrintService.printVoidTicket(ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double a(PosTransaction posTransaction) {
        double d = 0.0;
        String string = posTransaction.getProperty("REFUNDED_AMOUNT");
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NumberUtil.roundToTwoDigit(posTransaction.getAmount() - d);
    }

    public double refundTicket(Ticket ticket, double d, Double d2, User user, List<PosTransaction> list, boolean bl) throws Exception {
        return this.refundTicket(ticket, d, d2, user, list, bl, null);
    }

    public double refundTicket(Ticket ticket, double d, Double d2, User user, List<PosTransaction> list, boolean bl, String string) throws Exception {
        double d3 = d;
        boolean bl2 = false;
        if (list == null || list.isEmpty()) {
            RefundTransaction refundTransaction = this.createRefundTransaction(ticket, null, d);
            refundTransaction.setUser(user);
            if (StringUtils.isEmpty((String)string)) {
                refundTransaction.setPaymentType(PaymentType.CASH);
            } else {
                refundTransaction.setPaymentType(PaymentType.GIFT_CERTIFICATE);
            }
            ticket.addTotransactions(refundTransaction);
            ticket.setRefunded(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            ticket.setCashier(user);
            ticket.calculateRefundAmount();
            ticket.setRefundableAmount(0.0);
            ticket.calculatePrice();
            Session session = null;
            Transaction transaction = null;
            try {
                GiftCard giftCard;
                session = TicketDAO.getInstance().createNewSession();
                transaction = session.beginTransaction();
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (bl2) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                if (StringUtils.isNotEmpty((String)string) && (giftCard = GiftCardDAO.getInstance().get(string, session)) != null) {
                    giftCard.setBalance(giftCard.getBalance() + refundTransaction.getAmount());
                    GiftCardDAO.getInstance().update(giftCard, session);
                }
                transaction.commit();
            }
            catch (Exception exception) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw exception;
            }
            finally {
                TicketDAO.getInstance().closeSession(session);
            }
            return d;
        }
        if (list.size() > 1) {
            for (PosTransaction posTransaction : list) {
                if (this.a(posTransaction) != d) continue;
                list = new ArrayList<PosTransaction>();
                list.add(posTransaction);
                break;
            }
        }
        for (PosTransaction posTransaction : list) {
            double d4 = this.a(posTransaction);
            if (d4 > d3) {
                d4 = d3;
            }
            if (!(d4 <= d3)) continue;
            double d5 = d2 * d4 / d;
            this.refundTicket(ticket, d4, d5, user, posTransaction, bl, string);
            if (!posTransaction.isRefunded()) continue;
            d3 -= d4;
            if (!(posTransaction instanceof CustomerAccountTransaction)) continue;
            bl2 = true;
        }
        if (d != d3) {
            PosTransaction posTransaction;
            ticket.setRefunded(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            ticket.setCashier(user);
            ticket.calculateRefundAmount();
            ticket.setRefundableAmount(ticket.getRefundableAmount() - d - d3);
            ticket.calculatePrice();
            this.a(ticket);
            Session session = null;
            posTransaction = null;
            try {
                session = TicketDAO.getInstance().createNewSession();
                posTransaction = session.beginTransaction();
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (bl2) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                posTransaction.commit();
            }
            catch (Exception exception) {
                if (posTransaction != null) {
                    posTransaction.rollback();
                }
                throw exception;
            }
            finally {
                TicketDAO.getInstance().closeSession(session);
            }
        }
        return d - d3;
    }

    private void a(Ticket ticket) {
        BasePosTransaction basePosTransaction = null;
        Iterator<PosTransaction> iterator = ticket.getTransactions().iterator();
        while (iterator.hasNext()) {
            PosTransaction posTransaction = iterator.next();
            if (!(posTransaction instanceof RefundTransaction) || posTransaction.getId() != null || posTransaction.getPaymentType() != PaymentType.CASH) continue;
            if (basePosTransaction != null) {
                basePosTransaction.setAmount(basePosTransaction.getAmount() + posTransaction.getAmount());
                basePosTransaction.setTipsAmount(basePosTransaction.getTipsAmount() + posTransaction.getTipsAmount());
                basePosTransaction.setTaxAmount(basePosTransaction.getTaxAmount() + posTransaction.getTaxAmount());
                iterator.remove();
                continue;
            }
            if (posTransaction.getId() != null) continue;
            basePosTransaction = (RefundTransaction)posTransaction;
        }
    }

    public void refundTicket(Ticket ticket, double d, double d2, User user, PosTransaction posTransaction, boolean bl) throws Exception {
        this.refundTicket(ticket, d, d2, user, posTransaction, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refundTicket(Ticket ticket, double d, double d2, User user, PosTransaction posTransaction, boolean bl, String string) throws Exception {
        Object object;
        Object object2;
        if (d <= 0.0) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (StringUtils.isNotEmpty((String)string)) {
            object2 = GiftCardConfig.getPaymentGateway();
            object = object2.getProcessor();
            object.refund(string, d);
        } else if (!bl) {
            if (posTransaction != null) {
                if (posTransaction instanceof CustomerAccountTransaction) {
                    Customer customer = ticket.getCustomer();
                    if (customer == null) {
                        throw new PosException(Messages.getString("PosTransactionService.1"));
                    }
                    customer.setBalance(customer.getBalance() + d);
                    posTransaction.setRefunded(true);
                } else if (posTransaction instanceof CreditCardTransaction) {
                    double d3 = posTransaction.getAmount();
                    CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
                    try {
                        posTransaction.setAmount(d);
                        if (d3 == d) {
                            cardProcessor.voidTransaction(posTransaction);
                            bl3 = posTransaction.isVoided();
                        }
                        if (!bl3) {
                            cardProcessor.refundTransaction(posTransaction, d);
                            bl2 = posTransaction.isRefunded();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            cardProcessor.refundTransaction(posTransaction, d);
                            bl2 = posTransaction.isRefunded();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    finally {
                        posTransaction.setAmount(d3);
                    }
                }
            }
            if (posTransaction instanceof CreditCardTransaction && !bl2 && !bl3) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosTransactionService.2"));
                throw new PosException(Messages.getString("PosTransactionService.2"));
            }
        }
        object2 = null;
        object2 = StringUtils.isNotEmpty((String)string) ? PaymentType.GIFT_CERTIFICATE : (bl ? PaymentType.CASH : posTransaction.getPaymentType());
        object = this.createRefundTransaction(ticket, posTransaction, d);
        ((PosTransaction)object).setPaymentType((PaymentType)((Object)object2));
        ((PosTransaction)object).setUser(user);
        ((PosTransaction)object).setServer(ticket.getOwner());
        ((BasePosTransaction)object).setTaxAmount(d2);
        if (posTransaction instanceof CustomerAccountTransaction) {
            ((BasePosTransaction)object).setCustomerId(ticket.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)string)) {
            ((BasePosTransaction)object).setGiftCertNumber(string);
        }
        ticket.addTotransactions((PosTransaction)object);
        posTransaction.setRefunded(true);
    }

    public RefundTransaction createRefundTransaction(Ticket ticket, PosTransaction posTransaction, double d) {
        RefundTransaction refundTransaction = new RefundTransaction();
        refundTransaction.setAmount(d);
        refundTransaction.setTicket(ticket);
        refundTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        refundTransaction.setTransactionType(TransactionType.DEBIT.name());
        refundTransaction.setCashDrawer(Application.getCurrentUser().getActiveDrawerPullReport());
        refundTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        refundTransaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        if (posTransaction == null) {
            return refundTransaction;
        }
        refundTransaction.setCardExpMonth(posTransaction.getCardExpMonth());
        refundTransaction.setCardHolderName(posTransaction.getCardHolderName());
        refundTransaction.setCardAuthCode(posTransaction.getCardAuthCode());
        refundTransaction.setCardMerchantGateway(posTransaction.getCardMerchantGateway());
        refundTransaction.setCardNumber(posTransaction.getCardNumber());
        refundTransaction.setCardTrack(posTransaction.getCardTrack());
        refundTransaction.setCardTransactionId(posTransaction.getCardTransactionId());
        refundTransaction.setCardReader(posTransaction.getCardReader());
        refundTransaction.setCardType(posTransaction.getCardType());
        refundTransaction.addProperty("REFUNDED_TRANSACTION_ID", posTransaction.getId());
        String string = posTransaction.getProperty("REFUNDED_AMOUNT");
        double d2 = 0.0;
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                d2 = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        posTransaction.addProperty("REFUNDED_AMOUNT", String.valueOf(d + d2));
        if (posTransaction.getTipsAmount() > 0.0) {
            double d3;
            double d4;
            double d5;
            String string2 = posTransaction.getProperty("REFUNDED_TIPS_AMOUNT");
            double d6 = 0.0;
            if (StringUtils.isNotEmpty((String)string)) {
                try {
                    d6 = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((d5 = (d4 = d2 + d) - (d3 = posTransaction.getAmount() - posTransaction.getTipsAmount()) - d6) > 0.0) {
                refundTransaction.setTipsAmount(d5);
                posTransaction.addProperty("REFUNDED_TIPS_AMOUNT", String.valueOf(d5 + d6));
                Gratuity gratuity = ticket.getGratuity();
                gratuity.setAmount(gratuity.getAmount() - d5);
            }
        }
        return refundTransaction;
    }

    public double refundTicket(Ticket ticket, PosTransaction posTransaction, double d, Double d2, User user, Session session) throws Exception {
        ticket.addTotransactions(posTransaction);
        ticket.setRefunded(true);
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        ticket.setCashier(user);
        ticket.calculateRefundAmount();
        ticket.setRefundableAmount(0.0);
        ticket.calculatePrice();
        TicketDAO.getInstance().saveOrUpdate(ticket, session);
        return d;
    }

    public void bookBartabTicket(Ticket ticket, PosTransaction posTransaction, boolean bl) throws Exception {
        Object object;
        Application application = Application.getInstance();
        User user = Application.getCurrentUser();
        Terminal terminal = application.refreshAndGetTerminal();
        Session session = null;
        Transaction transaction = null;
        GenericDAO genericDAO = new GenericDAO();
        try {
            object = new Date();
            session = genericDAO.createNewSession();
            transaction = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.calculatePrice();
            if (bl) {
                ticket.setPaid(true);
                this.a(ticket, (Date)object);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setTransactionTime((Date)object);
            ticket.addTotransactions(posTransaction);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            transaction.commit();
            genericDAO.closeSession(session);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                try {
                    transaction.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
            catch (Throwable throwable) {
                genericDAO.closeSession(session);
                throw throwable;
            }
        }
        object = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId();
        object = (String)object + ";" + POSConstants.TOTAL + ":" + NumberUtil.formatNumber(ticket.getTotalAmount());
        ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.SETTLE_CHECK, (String)object);
    }

    public static PosTransactionService getInstance() {
        return a;
    }
}

