/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.CashDrawerReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class DrawerAndStaffBankReportHistoryDialog
extends POSDialog {
    private TitlePanel a;
    private JTable b;
    private DrawerReportTableModel c;
    private List<CashDrawer> d;
    private DefaultListSelectionModel e;
    private User f;
    private PosButton g;
    private Terminal h;
    private JLabel i;
    private StoreSession j;

    public DrawerAndStaffBankReportHistoryDialog(JFrame jFrame, User user, StoreSession storeSession) {
        super((Frame)jFrame, true);
        this.setTitle(Messages.getString("DrawerAndStaffBankReportHistoryDialog.0"));
        this.f = user;
        this.j = storeSession;
        this.c();
        this.initData();
        this.a();
    }

    public void initData() {
        this.h = Application.getInstance().getTerminal();
        this.e = new DefaultListSelectionModel();
        this.e.setSelectionMode(0);
        this.b.getSelectionModel().setSelectionMode(0);
        this.b.setDefaultRenderer(Object.class, new TableRenderer());
        this.c = new DrawerReportTableModel();
        this.b.setModel(this.c);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                CashDrawer cashDrawer = (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.c.getRowData(n);
                DrawerAndStaffBankReportHistoryDialog.this.a(cashDrawer);
                DrawerAndStaffBankReportHistoryDialog.this.a();
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.b, abstractAction, 5){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.b.getBackground());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(2, 10, 2, 10, this.b.getBackground());
        CompoundBorder compoundBorder = new CompoundBorder(matteBorder, this.g.getBorder());
        CompoundBorder compoundBorder2 = new CompoundBorder(matteBorder2, this.g.getBorder());
        buttonColumn.setUnselectedBorder(compoundBorder);
        buttonColumn.setFocusBorder(compoundBorder2);
        this.b();
    }

    private void a() {
        if (this.j == null) {
            return;
        }
        this.d = new ArrayList<CashDrawer>();
        List<CashDrawer> list = CashDrawerDAO.getInstance().findByStoreOperationData(this.j);
        for (CashDrawer cashDrawer : list) {
            this.d.add(cashDrawer);
        }
        this.c.setItems(this.d);
        this.c.fireTableDataChanged();
        this.i.setText(NumberUtil.formatNumber(this.c.getTotalCashDeposit()));
    }

    private void b() {
        this.b.setAutoResizeMode(4);
        this.a(0, PosUIManager.getSize(200));
        this.a(1, PosUIManager.getSize(100));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.b.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void c() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a = new TitlePanel();
        TransparentPanel transparentPanel2 = new TransparentPanel();
        TransparentPanel transparentPanel3 = new TransparentPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        JSeparator jSeparator = new JSeparator();
        this.g = new PosButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.b = new JTable();
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        transparentPanel.setLayout(new BorderLayout(5, 5));
        transparentPanel.add((Component)jSeparator, "North");
        this.g.setText(POSConstants.SAVE_BUTTON_TEXT);
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerAndStaffBankReportHistoryDialog.this.a(actionEvent);
            }
        });
        transparentPanel3.add(this.g);
        transparentPanel.add((Component)transparentPanel3, "Center");
        this.getContentPane().add((Component)transparentPanel, "South");
        transparentPanel2.setLayout(new BorderLayout());
        transparentPanel2.add((Component)this.a, "North");
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 15, 10, 15), jScrollPane.getBorder()));
        jScrollPane.setViewportView(this.b);
        transparentPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 20 0 20"));
        this.i = new JLabel();
        Font font = new Font(null, 1, 14);
        this.i.setFont(font);
        JLabel jLabel = new JLabel(Messages.getString("DrawerAndStaffBankReportHistoryDialog.2"));
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jPanel.add((Component)this.i, "gapright 20");
        transparentPanel2.add((Component)jPanel, "South");
        this.getContentPane().add((Component)transparentPanel2, "Center");
        this.setSize(PosUIManager.getSize(830, 550));
    }

    private void a(CashDrawer cashDrawer) {
        if (cashDrawer == null) {
            return;
        }
        if (cashDrawer.getDrawerType() == DrawerType.STAFF_BANK) {
            this.b(cashDrawer);
        } else {
            this.c(cashDrawer);
        }
    }

    private void b(CashDrawer cashDrawer) {
        try {
            CashDrawerReportDialog cashDrawerReportDialog = new CashDrawerReportDialog(this.f, cashDrawer);
            cashDrawerReportDialog.setTitle(Messages.getString("DrawerAndStaffBankReportHistoryDialog.4"));
            cashDrawerReportDialog.showInfoOnly(true);
            cashDrawerReportDialog.refreshReport();
            cashDrawerReportDialog.setDefaultCloseOperation(2);
            cashDrawerReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void c(CashDrawer cashDrawer) {
        try {
            if (cashDrawer.getTerminal() == null) {
                return;
            }
            CashDrawerReportDialog cashDrawerReportDialog = new CashDrawerReportDialog(this.f, cashDrawer);
            cashDrawerReportDialog.setTitle(POSConstants.DRAWER_PULL_BUTTON_TEXT);
            cashDrawerReportDialog.showInfoOnly(true);
            cashDrawerReportDialog.refreshReport();
            cashDrawerReportDialog.setDefaultCloseOperation(2);
            cashDrawerReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void setInfo(String string) {
        this.a.setTitle(string);
    }

    private void a(ActionEvent actionEvent) {
        this.dispose();
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat b = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setIcon(null);
            if (n2 == 0) {
                object2 = (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.d.get(n);
                Terminal terminal = ((CashDrawer)object2).getTerminal();
                if (((CashDrawer)object2).getDrawerType() != DrawerType.STAFF_BANK && terminal != null && terminal.getId().intValue() == DrawerAndStaffBankReportHistoryDialog.this.h.getId().intValue()) {
                    jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
                }
            }
            if (object instanceof Date) {
                object2 = this.b.format(object);
                jLabel.setText((String)object2);
                jLabel.setHorizontalAlignment(4);
            }
            if (n2 == 3 || n2 == 4 || object instanceof Double) {
                jLabel.setHorizontalAlignment(4);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
            if (n2 == 1 || n2 == 2) {
                jLabel.setHorizontalAlignment(0);
            }
            return jLabel;
        }
    }

    class DrawerReportTableModel
    extends ListTableModel<CashDrawer> {
        private double b;

        public DrawerReportTableModel() {
            super(new String[]{Messages.getString("DrawerAndStaffBankReportHistoryDialog.5"), Messages.getString("Type"), Messages.getString("DrawerAndStaffBankReportHistoryDialog.7"), Messages.getString("DrawerAndStaffBankReportHistoryDialog.8"), Messages.getString("DrawerAndStaffBankReportHistoryDialog.9"), ""});
        }

        public void setItems(List<CashDrawer> list) {
            double d = 0.0;
            if (list != null) {
                for (CashDrawer cashDrawer : list) {
                    d += cashDrawer.getCashToDeposit().doubleValue();
                }
            }
            this.setTotalCashDeposit(d);
            this.setRows(list);
        }

        public double getTotalCashDeposit() {
            return this.b;
        }

        public void setTotalCashDeposit(double d) {
            this.b = d;
        }

        @Override
        public int getRowCount() {
            if (DrawerAndStaffBankReportHistoryDialog.this.d == null) {
                return 0;
            }
            int n = DrawerAndStaffBankReportHistoryDialog.this.d.size();
            return n;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 5;
        }

        public CashDrawer getSelectedRow() {
            int n = DrawerAndStaffBankReportHistoryDialog.this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            n = DrawerAndStaffBankReportHistoryDialog.this.b.convertRowIndexToModel(n);
            return (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.c.getRowData(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (DrawerAndStaffBankReportHistoryDialog.this.d == null) {
                return "";
            }
            CashDrawer cashDrawer = (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.d.get(n);
            User user = cashDrawer.getAssignedUser();
            switch (n2) {
                case 0: {
                    if (cashDrawer.getDrawerType() == DrawerType.DRAWER) {
                        return Messages.getString("DrawerAndStaffBankReportHistoryDialog.11") + cashDrawer.getTerminal();
                    }
                    return cashDrawer.getAssignedUser();
                }
                case 1: {
                    return cashDrawer.getDrawerType().toString();
                }
                case 2: {
                    if (user != null) {
                        return cashDrawer.getReportTime() == null ? Messages.getString("DrawerAndStaffBankReportHistoryDialog.12") : Messages.getString("DrawerAndStaffBankReportHistoryDialog.13");
                    }
                }
                case 3: {
                    if (user != null) {
                        return NumberUtil.formatNumber(cashDrawer.getCashToDeposit());
                    }
                }
                case 4: {
                    if (user != null) {
                        return NumberUtil.formatNumber(cashDrawer.getDrawerAccountable());
                    }
                }
                case 5: {
                    return Messages.getString("DrawerAndStaffBankReportHistoryDialog.14");
                }
            }
            return "";
        }
    }
}

