/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BaseAttribute;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AttributesSelectionDialog;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.model.AttributeEntryForm;
import com.floreantpos.util.NumericGlobalIdGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class VariantAttributesSelectionDialog
extends OkCancelOptionDialog {
    private JXTable b = new JXTable();
    private VariantAttributeModel c = new VariantAttributeModel();
    private List<AttributeGroup> d;
    private JButton e;
    private List<MenuItem> f = new ArrayList<MenuItem>();
    private List<MenuItem> g;
    List<Attribute> a = new ArrayList<Attribute>();
    private final List<Attribute> h;
    private MenuItem i;
    private JComboBox j;

    public VariantAttributesSelectionDialog(List<MenuItem> list) {
        this.f = list;
        this.h = AttributeDAO.getInstance().findAll();
        this.b();
        this.setTitle(Messages.getString("VariantAttributesSelectionDialog.0"));
        this.setCaption(Messages.getString("VariantAttributesSelectionDialog.0"));
        this.b.setModel((TableModel)this.c);
        this.a();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                Attribute attribute = (Attribute)VariantAttributesSelectionDialog.this.c.getRowData(n);
                VariantAttributesSelectionDialog.this.c.deleteItem(attribute);
                VariantAttributesSelectionDialog.this.c.fireTableRowsDeleted(n, n);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.b, abstractAction, 1){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                posButton.setIcon(IconFactory.getIcon("/ui_icons/", "delete-icon.png"));
                posButton.setOpaque(false);
                posButton.setBorder(null);
                return posButton;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        this.c();
    }

    private void a() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (this.f != null) {
            for (MenuItem menuItem : this.f) {
                if (menuItem.getAttributes() == null) continue;
                for (Attribute attribute : menuItem.getAttributes()) {
                    if (arrayList.contains(attribute)) continue;
                    arrayList.add(attribute);
                }
            }
        }
        Collections.sort(arrayList, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute attribute, Attribute attribute2) {
                return attribute.getGroup().getName().compareTo(attribute2.getGroup().getName());
            }
        });
        this.c.setRows(arrayList);
    }

    public void setParentMenuItem(MenuItem menuItem) {
        this.i = menuItem;
    }

    private void b() {
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("aligny top,ins 0 10 0 10", "[100%]", ""));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx,ins 2"));
        this.j = new JComboBox(new ComboBoxModel(new ArrayList()));
        this.j.setOpaque(false);
        this.j.setBorder(null);
        this.j.setEditable(true);
        this.j.setEditor(new CustomComboBoxEditor());
        this.j.setRenderer(new ColorCellRenderer());
        this.j.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    // empty if block
                }
            }
        });
        this.j.setUI(new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                return new JButton(){

                    @Override
                    public int getWidth() {
                        return 0;
                    }
                };
            }
        });
        this.j.remove(this.getComponent(0));
        this.f();
        jPanel2.add((Component)new JLabel(Messages.getString("VariantAttributesSelectionDialog.8")), "split 3,h 30!");
        jPanel2.add((Component)this.j, "growx,h 30!");
        JButton jButton = new JButton(Messages.getString("SELECT"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariantAttributesSelectionDialog.this.d();
            }
        });
        jPanel2.add((Component)jButton, "h 30!");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("VariantAttributesSelectionDialog.14")));
        this.b.setTableHeader(null);
        this.b.setRowHeight(30);
        this.b.setRowSelectionAllowed(false);
        this.b.setCellSelectionEnabled(false);
        jPanel3.add((Component)new JScrollPane((Component)this.b), "grow,span,wrap");
        jPanel.add((Component)jPanel2, "growx,span 2,aligny top,wrap");
        jPanel.add((Component)jPanel3, "grow,aligny top");
    }

    private void c() {
        this.b.setAutoResizeMode(4);
        this.a(1, PosUIManager.getSize(50));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.b.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void d() {
        AttributesSelectionDialog attributesSelectionDialog = new AttributesSelectionDialog(this.c.getRows());
        attributesSelectionDialog.setSize(PosUIManager.getSize(500, 440));
        attributesSelectionDialog.open();
        if (attributesSelectionDialog.isCanceled()) {
            return;
        }
        List<Attribute> list = attributesSelectionDialog.getSelectedAttributeList();
        if (list == null) {
            return;
        }
        Collections.sort(list, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute attribute, Attribute attribute2) {
                return attribute.getGroup().getName().compareTo(attribute2.getGroup().getName());
            }
        });
        this.c.setRows(list);
    }

    private void e() {
        Attribute attribute = new Attribute();
        CustomComboBoxEditor customComboBoxEditor = (CustomComboBoxEditor)this.j.getEditor();
        String string = ((CustomComboBoxEditor.AttributePanel)customComboBoxEditor.getEditorComponent()).getText();
        attribute.setName(string);
        AttributeEntryForm attributeEntryForm = new AttributeEntryForm(attribute);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(attributeEntryForm);
        beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 400));
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        Attribute attribute2 = (Attribute)attributeEntryForm.getBean();
        this.c.addItem(attribute2);
    }

    @Override
    public void doOk() {
        List<Attribute> list = this.c.getRows();
        if (list == null || list.isEmpty()) {
            this.g = new ArrayList<MenuItem>();
        } else {
            String string;
            List<Attribute> list2;
            LinkedHashMap<String, MenuItem> linkedHashMap = new LinkedHashMap<String, MenuItem>();
            this.g = this.a(list);
            if (this.f != null) {
                for (MenuItem menuItem : this.f) {
                    menuItem.setName(menuItem.getVariantName());
                    list2 = menuItem.getAttributes();
                    Collections.sort(list2, new Comparator<Attribute>(){

                        @Override
                        public int compare(Attribute attribute, Attribute attribute2) {
                            return attribute.getId().compareTo(attribute2.getId());
                        }
                    });
                    string = "";
                    for (Attribute attribute : list2) {
                        string = string + attribute.getName() + "-";
                    }
                    linkedHashMap.put(string, menuItem);
                }
            }
            if (this.g != null) {
                for (MenuItem menuItem : this.g) {
                    menuItem.setName(menuItem.getVariantName());
                    list2 = menuItem.getAttributes();
                    Collections.sort(list2, new Comparator<Attribute>(){

                        @Override
                        public int compare(Attribute attribute, Attribute attribute2) {
                            return attribute.getId().compareTo(attribute2.getId());
                        }
                    });
                    string = "";
                    for (Attribute attribute : list2) {
                        string = string + attribute.getName() + "-";
                    }
                    MenuItem menuItem2 = (MenuItem)linkedHashMap.get(string);
                    if (menuItem2 != null) {
                        menuItem.setBarcode(menuItem2.getBarcode());
                        menuItem.setPrice(menuItem2.getPrice());
                        menuItem.setVisible(menuItem2.isVisible());
                    }
                    Collections.sort(list2, new Comparator<Attribute>(){

                        @Override
                        public int compare(Attribute attribute, Attribute attribute2) {
                            return attribute.getGroup().getId().compareTo(attribute2.getGroup().getId());
                        }
                    });
                }
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private List<MenuItem> a(List<Attribute> list) {
        HashMap<AttributeGroup, ArrayList<Attribute>> hashMap = new HashMap<AttributeGroup, ArrayList<Attribute>>();
        for (Attribute serializable2 : list) {
            ArrayList<Attribute> arrayList = (ArrayList<Attribute>)hashMap.get(serializable2.getGroup());
            if (arrayList == null) {
                arrayList = new ArrayList<Attribute>();
                hashMap.put(serializable2.getGroup(), arrayList);
            }
            arrayList.add(serializable2);
        }
        for (AttributeGroup attributeGroup : hashMap.keySet()) {
            if (attributeGroup.getAttributes() == null) continue;
        }
        Iterator<Attribute> iterator = list.toArray();
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        int n = hashMap.size();
        int n2 = ((Iterator<Attribute>)iterator).length;
        this.a(arrayList, (Object[])iterator, n2, n);
        return arrayList;
    }

    private void f() {
        try {
            Field field = BasicComboBoxUI.class.getDeclaredField("popup");
            field.setAccessible(true);
            BasicComboPopup basicComboPopup = (BasicComboPopup)field.get(this.j.getUI());
            Field field2 = BasicComboPopup.class.getDeclaredField("scroller");
            field2.setAccessible(true);
            JScrollPane jScrollPane = (JScrollPane)field2.get(basicComboPopup);
            jScrollPane.getViewport().getView().addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    Object object;
                    Object object2 = VariantAttributesSelectionDialog.this.j.getSelectedItem();
                    if (object2 instanceof Attribute) {
                        object = (Attribute)object2;
                        if (((BaseAttribute)object).getId() != null) {
                            if (VariantAttributesSelectionDialog.this.c.getRows().contains(object)) {
                                return;
                            }
                            VariantAttributesSelectionDialog.this.c.addItem(object);
                        } else {
                            VariantAttributesSelectionDialog.this.e();
                        }
                    }
                    VariantAttributesSelectionDialog.this.j.hidePopup();
                    object = (CustomComboBoxEditor)VariantAttributesSelectionDialog.this.j.getEditor();
                    ((CustomComboBoxEditor.AttributePanel)((CustomComboBoxEditor)object).getEditorComponent()).selectAll();
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }
            });
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    void a(List list, Object[] objectArray, int n, int n2, int n3, Object[] objectArray2, int n4) {
        if (n3 == n2) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
            for (int i = 0; i < n2; ++i) {
                object = (Attribute)objectArray2[i];
                if (arrayList.contains(((BaseAttribute)object).getGroup().getId())) {
                    return;
                }
                arrayList.add(((BaseAttribute)object).getGroup().getId());
                arrayList2.add((Attribute)object);
            }
            MenuItem menuItem = new MenuItem();
            menuItem.setName(this.i.getName());
            menuItem.setParentMenuItem(this.i);
            menuItem.setMenuGroupId(this.i.getMenuGroupId());
            menuItem.setMenuGroupName(this.i.getMenuGroupName());
            menuItem.setMenuCategoryId(this.i.getMenuCategoryId());
            menuItem.setMenuCategoryName(this.i.getMenuCategoryName());
            menuItem.setUnit(this.i.getUnit());
            menuItem.setVariant(true);
            menuItem.setInventoryItem(this.i.isInventoryItem());
            menuItem.setAttributes(arrayList2);
            object = NumericGlobalIdGenerator.generateGlobalId();
            menuItem.setBarcode((String)object);
            menuItem.setSku((String)object);
            list.add(menuItem);
            return;
        }
        if (n4 >= n) {
            return;
        }
        objectArray2[n3] = objectArray[n4];
        this.a(list, objectArray, n, n2, n3 + 1, objectArray2, n4 + 1);
        this.a(list, objectArray, n, n2, n3, objectArray2, n4 + 1);
    }

    void a(List list, Object[] objectArray, int n, int n2) {
        Object[] objectArray2 = new Object[n2];
        this.a(list, objectArray, n, n2, 0, objectArray2, 0);
    }

    public List<MenuItem> getVariants() {
        return this.g;
    }

    class CustomComboBoxEditor
    implements ComboBoxEditor {
        AttributePanel a = new AttributePanel();

        @Override
        public void setItem(Object object) {
            if (object != null) {
                this.a.setText(object.toString());
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.a;
        }

        @Override
        public Object getItem() {
            return this.a.getText();
        }

        @Override
        public void selectAll() {
            this.a.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
        }

        class AttributePanel
        extends JPanel {
            JTextField a;

            public AttributePanel() {
                this.setLayout(new BorderLayout());
                this.a = new JTextField("");
                this.a.setColumns(20);
                this.a.setRequestFocusEnabled(true);
                this.a.requestFocus();
                this.a.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                    }

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 27) {
                            return;
                        }
                        if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38) {
                            if (!VariantAttributesSelectionDialog.this.j.isPopupVisible()) {
                                VariantAttributesSelectionDialog.this.j.showPopup();
                            }
                            return;
                        }
                        String string = (String)CustomComboBoxEditor.this.getItem();
                        AttributePanel.this.comboFilter(string);
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                    }
                });
                this.a.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        AttributePanel.this.selectAll();
                    }
                });
                this.a.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = VariantAttributesSelectionDialog.this.j.getSelectedItem();
                        if (object instanceof Attribute) {
                            Attribute attribute = (Attribute)object;
                            if (attribute.getId() != null) {
                                if (!VariantAttributesSelectionDialog.this.c.getRows().contains(attribute)) {
                                    VariantAttributesSelectionDialog.this.c.addItem(attribute);
                                }
                            } else {
                                VariantAttributesSelectionDialog.this.e();
                            }
                        }
                        AttributePanel.this.setText("");
                        VariantAttributesSelectionDialog.this.j.hidePopup();
                    }
                });
                this.add(this.a);
            }

            public void comboFilter(String string) {
                if (string.isEmpty() && VariantAttributesSelectionDialog.this.j.isPopupVisible()) {
                    VariantAttributesSelectionDialog.this.j.hidePopup();
                    return;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Serializable serializable : VariantAttributesSelectionDialog.this.h) {
                    if (!((BaseAttribute)serializable).getName().toLowerCase().startsWith(string.toLowerCase())) continue;
                    arrayList.add(serializable);
                }
                Attribute attribute = new Attribute();
                attribute.setName(Messages.getString("VariantAttributesSelectionDialog.30"));
                attribute.setGroup(new AttributeGroup());
                arrayList.add(attribute);
                if (arrayList.size() > 0) {
                    Serializable serializable;
                    serializable = (ComboBoxModel)VariantAttributesSelectionDialog.this.j.getModel();
                    ((ComboBoxModel)serializable).removeAllElements();
                    for (Object e : arrayList) {
                        ((ComboBoxModel)serializable).addElement(e);
                    }
                    this.setText(string);
                }
                if (!VariantAttributesSelectionDialog.this.j.isPopupVisible()) {
                    VariantAttributesSelectionDialog.this.j.showPopup();
                }
                this.resize();
            }

            public void resize() {
                Accessible accessible = VariantAttributesSelectionDialog.this.j.getAccessibleContext().getAccessibleChild(0);
                BasicComboPopup basicComboPopup = (BasicComboPopup)accessible;
                JList<Object> jList = basicComboPopup.getList();
                Dimension dimension = jList.getPreferredSize();
                dimension.width = this.a.getWidth() + 20;
                int n = dimension.height / VariantAttributesSelectionDialog.this.j.getItemCount();
                int n2 = VariantAttributesSelectionDialog.this.j.getMaximumRowCount() * n;
                dimension.height = Math.min(dimension.height, n2);
                Container container = SwingUtilities.getAncestorOfClass(JScrollPane.class, jList);
                JScrollPane jScrollPane = (JScrollPane)container;
                jScrollPane.setPreferredSize(dimension);
                jScrollPane.setMaximumSize(dimension);
                Dimension dimension2 = basicComboPopup.getSize();
                dimension2.width = this.a.getWidth();
                dimension2.height = dimension.height + 2;
                Container container2 = basicComboPopup.getParent();
                container2.setSize(dimension2);
                ((Component)container2).validate();
                container2.repaint();
                Window window = SwingUtilities.windowForComponent(VariantAttributesSelectionDialog.this.j);
                Window window2 = SwingUtilities.windowForComponent(basicComboPopup);
                if (window2 != window) {
                    window2.pack();
                }
            }

            public void setText(String string) {
                if (string.equals(Messages.getString("VariantAttributesSelectionDialog.30"))) {
                    return;
                }
                this.a.setText(string);
            }

            public String getText() {
                return this.a.getText();
            }

            public void setIcon(Icon icon) {
                this.repaint();
            }

            public void selectAll() {
                this.a.selectAll();
            }

            public void addActionListener(ActionListener actionListener) {
            }

            public void removeActionListener(ActionListener actionListener) {
            }
        }
    }

    public class VariantAttributeModel
    extends ListTableModel<Attribute> {
        public VariantAttributeModel() {
            super(new String[]{"Name", ""});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Attribute attribute = (Attribute)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return attribute.getGroup() + " : " + attribute.getName();
                }
                case 1: {
                    return "";
                }
            }
            return null;
        }
    }

    class ColorCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private Dimension c = new Dimension(0, 30);
        Border a = new EmptyBorder(5, 30, 5, 5);

        ColorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setBackground(Color.WHITE);
            jLabel.setBorder(this.a);
            jLabel.setHorizontalAlignment(2);
            if (object instanceof Attribute && ((Attribute)object).getId() != null) {
                Attribute attribute = (Attribute)object;
                jLabel.setText("  " + attribute.getGroup() + ": " + attribute.getName());
                if (bl2 || bl) {
                    jLabel.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.1f));
                    jLabel.setBorder(new LineBorder(Color.DARK_GRAY));
                    jLabel.setForeground(Color.BLUE);
                } else {
                    jLabel.setForeground(Color.BLACK);
                    jLabel.setBorder(null);
                }
            } else {
                jLabel.setForeground(new Color(201, 244, 236));
                jLabel.setBorder(null);
                jLabel.setHorizontalAlignment(0);
                jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 12));
                jLabel.setBackground(Color.GRAY);
            }
            jLabel.setPreferredSize(this.c);
            return jLabel;
        }
    }
}

