/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.model.util.ZipCodeUtil;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class QuickCustomerForm
extends BeanEditor<Customer> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private FixedLengthTextField e;
    private FixedLengthTextField f;
    private QwertyKeyPad g;
    public boolean isKeypad;
    private FixedLengthTextField h;
    private FixedLengthTextField i;

    public QuickCustomerForm() {
        this.a();
    }

    public QuickCustomerForm(Customer customer) {
        this.isKeypad = true;
        this.a();
        this.setBean(customer);
    }

    public QuickCustomerForm(boolean bl) {
        this.isKeypad = bl;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setOpaque(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("insets 10 10 10 10, fill", "[][fill,grow]", ""));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("QuickCustomerForm.2")));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.18"));
        this.a = new FixedLengthTextField(220);
        this.a.setColumns(60);
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.21"));
        this.c = new FixedLengthTextField(30);
        JLabel jLabel3 = new JLabel(Messages.getString("QuickCustomerForm.3"));
        this.b = new FixedLengthTextField();
        JLabel jLabel4 = new JLabel(Messages.getString("QuickCustomerForm.0"));
        this.e = new FixedLengthTextField(30);
        JLabel jLabel5 = new JLabel(Messages.getString("QuickCustomerForm.4"));
        this.f = new FixedLengthTextField(30);
        JLabel jLabel6 = new JLabel(Messages.getString("QuickCustomerForm.5"));
        this.h = new FixedLengthTextField(30);
        JLabel jLabel7 = new JLabel(Messages.getString("QuickCustomerForm.6"));
        this.i = new FixedLengthTextField(30);
        JLabel jLabel8 = new JLabel("Name");
        this.d = new FixedLengthTextField();
        this.d.setLength(120);
        jPanel.add((Component)jLabel5, "alignx right");
        jPanel.add((Component)this.f, "wrap");
        jPanel.add((Component)jLabel8, "alignx right");
        jPanel.add((Component)this.d, "wrap");
        jPanel.add((Component)jLabel6, "right");
        jPanel.add((Component)this.h, "wrap");
        jPanel.add((Component)jLabel7, "right");
        jPanel.add((Component)this.i, "wrap");
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)this.a, "wrap");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.c, "wrap");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)this.e, "wrap");
        this.g = new QwertyKeyPad();
        this.add((Component)jPanel, "Center");
        if (this.isKeypad) {
            this.add((Component)((Object)this.g), "South");
        }
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuickCustomerForm.this.b();
            }
        });
        this.c.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                QuickCustomerForm.this.b();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.enableCustomerFields(false);
        this.callOrderController();
    }

    public void callOrderController() {
        Vector<FixedLengthTextField> vector = new Vector<FixedLengthTextField>();
        vector.add(this.f);
        vector.add(this.d);
        vector.add(this.h);
        vector.add(this.i);
        vector.add(this.c);
        vector.add(this.b);
        vector.add(this.e);
        vector.add(this.a);
    }

    public void enableCustomerFields(boolean bl) {
        this.d.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.c.setEnabled(bl);
        this.f.setEnabled(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.d.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.c.setEnabled(bl);
        this.f.setEnabled(bl);
    }

    public void setFieldsEditable(boolean bl) {
        this.d.setEditable(bl);
        this.h.setEditable(bl);
        this.i.setEditable(bl);
        this.a.setEditable(bl);
        this.b.setEditable(bl);
        this.c.setEditable(bl);
        this.f.setEditable(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.d.setText("");
        this.h.setText("");
        this.i.setText("");
        this.a.setText("");
        this.b.setText("");
        this.c.setText("");
        this.f.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (Exception exception) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
            return false;
        }
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.d.setText(customer.getName());
        this.h.setText(customer.getEmail());
        this.i.setText(customer.getEmail2());
        this.b.setText(customer.getCity());
        this.c.setText(customer.getZipCode());
        this.f.setText(customer.getMobileNo());
        this.e.setText(customer.getState());
        this.c.setText(customer.getZipCode());
        this.a.setText(customer.getAddress());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String string = this.f.getText();
        String string2 = this.d.getText();
        String[] stringArray = string2.split(" ");
        String string3 = stringArray[0];
        String string4 = string2.substring(string3.length(), string2.length());
        String string5 = this.h.getText();
        String string6 = this.i.getText();
        if (StringUtils.isEmpty((String)string2)) {
            POSMessageDialog.showError(null, Messages.getString("QuickCustomerForm.1"));
            return false;
        }
        if (StringUtils.isNotEmpty((String)string5) && !this.a(string5)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)string6) && !this.a(string6)) {
            return false;
        }
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        customer.setName(string2);
        customer.setFirstName(string3);
        customer.setLastName(string4);
        customer.setEmail(string5);
        customer.setEmail2(string6);
        customer.setAddress(this.a.getText());
        customer.setCity(this.b.getText());
        customer.setState(this.e.getText());
        customer.setZipCode(this.c.getText());
        customer.setMobileNo(string);
        return true;
    }

    private boolean a(String string) {
        boolean bl = EmailValidator.getInstance().isValid(string);
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("QuickCustomerForm.8"));
            return false;
        }
        return bl;
    }

    @Override
    public boolean delete() {
        try {
            Customer customer = (Customer)this.getBean();
            if (customer == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (n != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(customer);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("CustomerForm.54");
    }

    private void b() {
        String string = this.c.getText();
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = ZipCodeUtil.getCity(string);
        String string3 = ZipCodeUtil.getState(string);
        if (StringUtils.isNotEmpty((String)string3)) {
            this.e.setText(string3);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.b.setText(string2);
        }
    }

    public void setPhoneNo(String string) {
        this.f.setText(string);
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> a;

        public MyOwnFocusTraversalPolicy(Vector<Component> vector) {
            this.a = new Vector(vector.size());
            this.a.addAll(vector);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = (this.a.indexOf(component) + 1) % this.a.size();
            return this.a.get(n);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = this.a.indexOf(component) - 1;
            if (n < 0) {
                n = this.a.size() - 1;
            }
            return this.a.get(n);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.a.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.a.lastElement();
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.a.get(0);
        }
    }
}

