/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class NumberSelectionView
extends TransparentPanel
implements ActionListener {
    private TitledBorder a;
    private boolean b;
    private JTextField c;
    private PosButton d;
    private PosButton e;

    public NumberSelectionView() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.c = new JTextField();
        this.c.setText("0");
        this.c.setFont(this.c.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.c.setEditable(false);
        this.c.setBackground(Color.WHITE);
        this.c.setHorizontalAlignment(4);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.c, "Center");
        this.d = new PosButton("+");
        this.d.setFont(new Font("Arial", 0, 30));
        this.d.setFocusable(false);
        jPanel.add((Component)this.d, "East");
        this.d.setPreferredSize(PosUIManager.getSize(60, 45));
        this.e = new PosButton("-");
        this.e.setPreferredSize(PosUIManager.getSize(60, 45));
        this.e.setFont(new Font("Arial", 1, 30));
        this.e.setFocusable(false);
        jPanel.add((Component)this.e, "West");
        this.add((Component)jPanel, "North");
        String[][] stringArrayArray = new String[][]{{"7", "8", "9"}, {"4", "5", "6"}, {"1", "2", "3"}, {".", "0", POSConstants.CLEAR_ALL}};
        String[][] stringArrayArray2 = new String[][]{{"7.png", "8.png", "9.png"}, {"4.png", "5.png", "6.png"}, {"1.png", "2.png", "3.png"}, {"dot.png", "0.png", "clear.png"}};
        JPanel jPanel2 = new JPanel(new GridLayout(4, 3, 5, 5));
        Dimension dimension = PosUIManager.getSize(100, 70);
        for (int i = 0; i < stringArrayArray.length; ++i) {
            for (int j = 0; j < stringArrayArray[i].length; ++j) {
                PosButton posButton = new PosButton();
                ImageIcon imageIcon = IconFactory.getIcon("/ui_icons/", stringArrayArray2[i][j]);
                String string = String.valueOf(stringArrayArray[i][j]);
                if (imageIcon == null) {
                    posButton.setText(string);
                } else {
                    posButton.setIcon(imageIcon);
                    if (POSConstants.CLEAR_ALL.equals(string)) {
                        posButton.setText(string);
                    }
                }
                posButton.setActionCommand(string);
                posButton.setPreferredSize(dimension);
                posButton.addActionListener(this);
                jPanel2.add(posButton);
            }
        }
        this.add((Component)jPanel2, "Center");
        this.a = new TitledBorder("");
        this.a.setTitleJustification(2);
        this.setBorder(this.a);
        this.buttonAction();
        this.setVisibleControlsButton(false);
    }

    public void setVisibleControlsButton(boolean bl) {
        this.d.setVisible(bl);
        this.e.setVisible(bl);
    }

    public void buttonAction() {
        try {
            this.d.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d = Double.parseDouble(NumberSelectionView.this.c.getText());
                    if (d == Math.floor(d) || !Double.isInfinite(d)) {
                        NumberSelectionView.this.c.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                    }
                }
            });
            this.e.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d = Double.parseDouble(NumberSelectionView.this.c.getText());
                    if ((d == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) >= 0.0) {
                        NumberSelectionView.this.c.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
                    }
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(POSConstants.CLEAR_ALL)) {
            this.c.setText("0");
        } else if (string.equals(POSConstants.CLEAR)) {
            String string2 = this.c.getText();
            string2 = string2.length() > 1 ? string2.substring(0, string2.length() - 1) : "0";
            this.c.setText(string2);
        } else if (string.equals(".")) {
            if (this.isDecimalAllowed() && this.c.getText().indexOf(46) < 0) {
                String string3 = this.c.getText() + ".";
                if (!this.a(string3)) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("NumberSelectionView.1"));
                    return;
                }
                this.c.setText(string3);
            }
        } else {
            String string4 = this.c.getText();
            if (string4.equals("0")) {
                this.c.setText(string);
                return;
            }
            string4 = string;
            if (!this.a(string4)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("NumberSelectionView.0"));
                return;
            }
            this.c.replaceSelection(string4);
        }
    }

    private boolean a(String string) {
        if (this.isDecimalAllowed()) {
            try {
                Double.parseDouble(string);
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void setTitle(String string) {
        this.a.setTitle(string);
    }

    public double getValue() {
        return Double.parseDouble(this.c.getText());
    }

    public String getText() {
        return this.c.getText();
    }

    public void setValue(double d) {
        if (this.isDecimalAllowed()) {
            this.c.setText(String.valueOf(d));
        } else {
            this.c.setText(String.valueOf((int)d));
        }
    }

    public boolean isDecimalAllowed() {
        return this.b;
    }

    public void setDecimalAllowed(boolean bl) {
        this.b = bl;
    }
}

