/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.SeatSelectionAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MiscTicketItemDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.dialog.SalesAreaSelectionDialog;
import com.floreantpos.ui.order.CourseOrganizeDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.CategoryView;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.MenuItemView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class OrderView
extends ViewPanel
implements RefreshableView,
TicketEditListener,
PaymentListener {
    private HashMap<String, JComponent> a = new HashMap();
    public static final String VIEW_NAME = "ORDER_VIEW";
    private static OrderView b;
    private Ticket c;
    private CategoryView d = new CategoryView();
    private GroupView e = new GroupView();
    private MenuItemView f = new MenuItemView();
    private TicketView g = new TicketView();
    private TransparentPanel h = new TransparentPanel(new BorderLayout(5, 5));
    private JPanel i = new JPanel(new BorderLayout());
    private JPanel j = this.e();
    private OrderController k = new OrderController(this);
    private JPanel l = new JPanel((LayoutManager)new MigLayout("fill, ins 2, hidemode 3", "fill", "fill"));
    private PosButton m = new PosButton(POSConstants.HOLD_BUTTON_TEXT);
    private PosButton n = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton o = new PosButton(POSConstants.SEND_TO_KITCHEN);
    private PosButton p = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
    private PosButton q = new PosButton(POSConstants.GUEST_NO_BUTTON_TEXT);
    private PosButton r = new PosButton(Messages.getString("OrderView.3"));
    private PosButton s = new PosButton(POSConstants.MISC_BUTTON_TEXT);
    private PosButton t = new PosButton(POSConstants.ORDER_TYPE_BUTTON_TEXT);
    private PosButton u = new PosButton(POSConstants.TABLE_NO_BUTTON_TEXT);
    private PosButton v = new PosButton(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
    private PosButton w = new PosButton(Messages.getString("OrderView.1"));
    private PosButton x = new PosButton(POSConstants.ORGANIZE_COURSE.toUpperCase());
    private PosButton y = new PosButton(Messages.getString("OrderView.2"));
    private PosButton z = new PosButton(Messages.getString("OrderView.5"));
    private SeatSelectionAction A = new SeatSelectionAction();
    private PosButton B = new PosButton(Messages.getString("TicketView.43"));
    private boolean C;
    private boolean D;
    private JTextField E;
    private JTextField F;
    private JTextField G;
    private JTextField H;
    private JTextField I;
    private JTextField J;
    private PaymentView K;

    private OrderView() {
        this.a();
        this.g.getTicketViewerTable().addTicketUpdateListener(this);
        this.k.addTicketUpdateListener(this);
    }

    public void addView(String string, JComponent jComponent) {
        JComponent jComponent2 = this.a.get(string);
        if (jComponent2 != null) {
            return;
        }
        this.h.add((Component)jComponent, string);
    }

    private void a() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(2, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.g);
        jPanel.add((Component)this.j, "South");
        this.i.add(jPanel);
        this.h.setOpaque(false);
        this.h.setBorder(null);
        this.h.add((Component)this.e, "North");
        this.h.add(this.f);
        this.c();
        this.t.setVisible(false);
        this.showView("VIEW_EMPTY");
    }

    private void b() {
        ITicketItem iTicketItem = this.g.getTicketViewerTable().getSelected();
        if (iTicketItem == null) {
            this.B.setEnabled(false);
        } else {
            this.B.setEnabled(iTicketItem.canAddDiscount());
        }
    }

    private void c() {
        this.g.getTicketViewerTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    OrderView.this.b();
                }
            }
        });
        this.z.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doAddSalesArea();
            }
        });
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OrderView.this.g.doFinishOrder();
                }
                catch (StaleStateException staleStateException) {
                    POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OrderView.this.g.isCancelable()) {
                    OrderView.this.g.doCancelOrder();
                    OrderView.this.k.fireTicketEditingFinish(OrderView.this.c);
                    return;
                }
                int n = POSMessageDialog.showYesNoQuestionDialog(null, Messages.getString("OrderView.4"), Messages.getString("CONFIRM"));
                if (n != 0) {
                    return;
                }
                VoidTicketAction voidTicketAction = new VoidTicketAction(OrderView.this.c);
                voidTicketAction.execute();
                if (OrderView.this.c.isVoided().booleanValue()) {
                    OrderView.this.g.doCancelOrder();
                    OrderView.this.g.setAllowToLogOut(true);
                }
                OrderView.this.k.fireTicketEditingFinish(OrderView.this.c);
            }
        });
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.m();
            }
        });
        this.w.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.l();
            }
        });
        this.x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.d();
            }
        });
        this.t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.v.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doAddEditCustomer();
            }
        });
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doInsertMisc(actionEvent);
            }
        });
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.btnCustomerNumberActionPerformed();
            }
        });
        this.A.setSource(this.r);
        this.r.setAction(this.A);
        this.u.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doSetTables();
            }
        });
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.k();
            }
        });
        this.B.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.addDiscount();
            }
        });
        this.y.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doShowDeliveryDialog();
            }
        });
        this.l.add(this.t);
        this.l.add(this.v);
        this.l.add(this.y);
        this.l.add(this.u);
        this.l.add(this.q);
        this.l.add(this.r);
        this.l.add(this.z);
        this.l.add(this.x);
        this.l.add(this.s);
        this.l.add(this.m);
        this.l.add(this.o);
        this.l.add(this.w);
        this.l.add(this.p);
        this.l.add(this.n);
        this.y.setVisible(false);
    }

    private void d() {
        if (DataProvider.get().getCourses().isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.15"));
            return;
        }
        CourseOrganizeDialog courseOrganizeDialog = new CourseOrganizeDialog(this.c);
        courseOrganizeDialog.setSize(950, 650);
        courseOrganizeDialog.open();
        if (courseOrganizeDialog.isCanceled()) {
            return;
        }
        this.g.getTicketViewerTable().updateView();
    }

    private JPanel e() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.E = new JTextField(10);
        this.E.setHorizontalAlignment(11);
        this.E.setEditable(false);
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.F = new JTextField(10);
        this.F.setHorizontalAlignment(11);
        this.F.setEditable(false);
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("Delivery Charge: " + CurrencyUtil.getCurrencySymbol());
        this.G = new JTextField(10);
        this.G.setHorizontalAlignment(11);
        this.G.setEditable(false);
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.H = new JTextField(10);
        this.H.setEditable(false);
        this.H.setHorizontalAlignment(11);
        JLabel jLabel5 = new JLabel();
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.I = new JTextField(10);
        this.I.setEditable(false);
        this.I.setHorizontalAlignment(11);
        JLabel jLabel6 = new JLabel();
        jLabel6.setFont(jLabel6.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        jLabel6.setHorizontalAlignment(4);
        jLabel6.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.J = new JTextField(10);
        this.J.setFont(this.J.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.J.setHorizontalAlignment(11);
        this.J.setEditable(false);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 2 2 3 2,alignx trailing,fill", "[grow]2[]", ""));
        transparentPanel.add((Component)jLabel, "growx,aligny center");
        transparentPanel.add((Component)this.E, "growx,aligny center");
        transparentPanel.add((Component)jLabel2, "newline,growx,aligny center");
        transparentPanel.add((Component)this.F, "growx,aligny center");
        transparentPanel.add((Component)jLabel4, "newline,growx,aligny center");
        transparentPanel.add((Component)this.H, "growx,aligny center");
        transparentPanel.add((Component)jLabel5, "newline,growx,aligny center");
        transparentPanel.add((Component)this.I, "growx,aligny center");
        transparentPanel.add((Component)jLabel6, "newline,growx,aligny center");
        transparentPanel.add((Component)this.J, "growx,aligny center");
        return transparentPanel;
    }

    public void updateTicketSummeryView() {
        Ticket ticket = this.g.getTicket();
        if (ticket == null) {
            this.E.setText("");
            this.F.setText("");
            this.G.setText("");
            this.H.setText("");
            this.J.setText("");
            this.I.setText("");
            return;
        }
        this.E.setText(NumberUtil.formatNumber(ticket.getSubtotalAmount()));
        this.F.setText(NumberUtil.formatNumber(ticket.getDiscountAmount()));
        this.G.setText(NumberUtil.formatNumber(ticket.getDeliveryCharge()));
        if (Application.getInstance().isPriceIncludesTax()) {
            this.H.setText(Messages.getString("TicketView.35"));
        } else {
            this.H.setText(NumberUtil.formatNumber(ticket.getTaxAmount()));
        }
        if (ticket.getGratuity() != null) {
            this.I.setText(NumberUtil.formatNumber(ticket.getGratuity().getAmount()));
        } else {
            this.I.setText("0.00");
        }
        this.J.setText(NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
    }

    protected void doShowDeliveryDialog() {
        try {
            Customer customer = CustomerDAO.getInstance().findById(this.c.getCustomerId());
            OrderServiceFactory.getOrderService().showDeliveryInfo(this.c, this.c.getOrderType(), customer);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doSetTables() {
        try {
            Object object;
            int n;
            boolean bl;
            TableSelectorDialog tableSelectorDialog = TableSelectorFactory.createTableSelectorDialog(this.c.getOrderType());
            tableSelectorDialog.setTitle(Messages.getString("OrderView.18"));
            tableSelectorDialog.getTableSelector().setTicketTransferMode(true);
            tableSelectorDialog.setCreateNewTicket(false);
            this.c.setShouldUpdateTableStatus(true);
            if (this.c != null) {
                tableSelectorDialog.setTicket(this.c);
            }
            tableSelectorDialog.openUndecoratedFullScreen();
            if (tableSelectorDialog.isCanceled()) {
                return;
            }
            List<ShopTable> list = tableSelectorDialog.getSelectedTables();
            if (list.isEmpty()) {
                return;
            }
            boolean bl2 = bl = this.c.getId() == null && TicketDAO.getInstance().isNewTicket(this.c.getId());
            if (!bl && (n = POSMessageDialog.showYesNoQuestionDialog(this, (String)(object = Messages.getString("OrderView.19")), Messages.getString("CONFIRM"))) != 0) {
                return;
            }
            object = new ArrayList();
            for (ShopTable shopTable : list) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    this.c.setSalesArea(salesArea);
                    this.c.setSalesAreaId(salesArea.getId());
                }
                object.add(shopTable.getId());
            }
            if (!bl) {
                ShopTableDAO.getInstance().transferTickets(this.c, (List<Integer>)object);
            } else {
                this.c.setTableNumbers((List<Integer>)object);
            }
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "1");
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doAddSalesArea() {
        try {
            SalesAreaSelectionDialog salesAreaSelectionDialog = new SalesAreaSelectionDialog();
            salesAreaSelectionDialog.open();
            if (salesAreaSelectionDialog.isCanceled()) {
                return;
            }
            SalesArea salesArea = salesAreaSelectionDialog.getSelectedSalesArea();
            this.setFocusable(true);
            this.c.setSalesArea(salesArea);
            this.c.setSalesAreaId(salesArea.getId());
            this.z.setText("<html><center>SALES AREA<br/>" + salesArea.getName() + "</center></html>");
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void btnCustomerNumberActionPerformed() {
        try {
            Ticket ticket = this.c;
            int n = ticket.getNumberOfGuests();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(POSConstants.NUMBER_OF_GUESTS);
            numberSelectionDialog2.setValue(n);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            n = (int)numberSelectionDialog2.getValue();
            if (n == 0) {
                POSMessageDialog.showError(Application.getPosWindow(), POSConstants.GUEST_NUMBER_CANNOT_BE_0);
                return;
            }
            ticket.setNumberOfGuests(n);
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doInsertMisc(ActionEvent actionEvent) {
        try {
            MiscTicketItemDialog miscTicketItemDialog = new MiscTicketItemDialog();
            miscTicketItemDialog.setOrderType(this.c.getOrderType());
            miscTicketItemDialog.pack();
            miscTicketItemDialog.open();
            if (!miscTicketItemDialog.isCanceled()) {
                TicketItem ticketItem = miscTicketItemDialog.getTicketItem();
                ticketItem.setTicket(this.c);
                ticketItem.calculatePrice();
                this.g.addTicketItem(ticketItem);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doAddEditCustomer() {
        try {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.c.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            if (this.c != null) {
                customerSelectorDialog.setTicket(this.c);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (!customerSelectorDialog.isCanceled()) {
                Customer customer = customerSelectorDialog.getSelectedCustomer();
                this.c.setCustomer(customer);
                if (customer != null) {
                    String string = "<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + customer.getName() + "</center></html>";
                    this.v.setText(string);
                }
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void addDiscount() {
        try {
            ITicketItem iTicketItem = this.g.getTicketViewerTable().getSelected();
            if (!(iTicketItem instanceof TicketItem)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.20"));
                return;
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void updateView() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (this.c != null) {
            Object object;
            Object object2;
            List<Integer> list;
            OrderType orderType = this.c.getOrderType();
            if (orderType.isPrepaid().booleanValue()) {
                this.n.setVisible(false);
            } else {
                this.n.setVisible(true);
            }
            if (!orderType.isShouldPrintToKitchen().booleanValue()) {
                this.o.setEnabled(false);
            } else {
                this.o.setEnabled(true);
            }
            if (!orderType.isAllowSeatBasedOrder().booleanValue()) {
                this.r.setVisible(false);
            } else {
                this.r.setVisible(true);
                list = null;
                object2 = this.A.getLastSeat(this.c);
                if (object2 instanceof Integer) {
                    list = (Integer)object2;
                    this.r.putClientProperty("SEAT_NO", list);
                    if (list != null && (Integer)((Object)list) > 0) {
                        this.r.setText(Messages.getString("OrderView.20") + list);
                    } else {
                        this.r.setText(Messages.getString("OrderView.21"));
                    }
                } else if (object2 instanceof TicketItemSeat) {
                    object = (TicketItemSeat)this.A.getLastSeat(this.c);
                    this.r.putClientProperty("SEAT_NO", object);
                    this.r.setText(Messages.getString("OrderView.32"));
                }
            }
            if (!orderType.isShowTableSelection().booleanValue()) {
                this.q.setVisible(false);
                this.u.setVisible(false);
            } else {
                this.q.setVisible(true);
                this.u.setVisible(true);
                if (!terminal.isShowTableNumber()) {
                    this.u.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.c.getTableNames() + "</center><html/>");
                } else {
                    list = this.c.getTableNumbers();
                    if (list != null) {
                        object2 = this.a(this.c.getTableNumbers());
                        this.u.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + (String)object2 + "</center><html/>");
                    } else {
                        this.u.setText(Messages.getString("OrderView.26"));
                    }
                }
                this.q.setText(Messages.getString("OrderView.27") + ": " + String.valueOf(this.c.getNumberOfGuests()));
            }
            if (orderType.isEnableReorder().booleanValue()) {
                this.w.setVisible(true);
            } else {
                this.w.setVisible(false);
            }
            this.x.setVisible(orderType.isEnableCourse());
            list = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (list != null && orderType.isDelivery().booleanValue() && orderType.isRequiredCustomerData().booleanValue()) {
                this.y.setVisible(true);
            }
            if (orderType.isRetailOrder().booleanValue()) {
                this.g.updateView();
                this.updateTicketSummeryView();
                this.K.setTicket(this.c);
                this.f();
            }
            if (this.c.getSalesArea() != null) {
                if (this.c.getSalesArea() != null) {
                    object2 = this.c.getSalesArea().toString();
                    this.z.setText("<html><center>" + Messages.getString("OrderView.38") + "<br>" + (String)object2 + "</center><html/>");
                }
            } else if (this.c.getId() != null) {
                this.z.setText(Messages.getString("OrderView.41"));
            } else {
                object2 = terminal.getSalesArea();
                if (object2 != null) {
                    object = ((SalesArea)object2).toString();
                    this.z.setText("<html><center>" + Messages.getString("OrderView.42") + "<br>" + (String)object + "</center><html/>");
                }
                if (terminal.isFixedSalesArea().booleanValue()) {
                    this.z.setEnabled(false);
                } else {
                    this.z.setEnabled(true);
                }
            }
            if (this.c.getCustomer() != null) {
                this.v.setText("<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + this.c.getCustomer().getName());
            } else {
                this.v.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
            }
        }
    }

    private String a(List<Integer> list) {
        String string = "";
        if (list != null && !list.isEmpty()) {
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                Integer n = iterator.next();
                string = string + n;
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
            return string;
        }
        return string;
    }

    public void showView(String string) {
    }

    public CategoryView getCategoryView() {
        return this.d;
    }

    public void setCategoryView(CategoryView categoryView) {
        this.d = categoryView;
    }

    public GroupView getGroupView() {
        return this.e;
    }

    public void setGroupView(GroupView groupView) {
        this.e = groupView;
    }

    public MenuItemView getItemView() {
        return this.f;
    }

    public void setItemView(MenuItemView menuItemView) {
        this.f = menuItemView;
    }

    public TicketView getTicketView() {
        return this.g;
    }

    public void setTicketView(TicketView ticketView) {
        this.g = ticketView;
    }

    public OrderController getOrderController() {
        return this.k;
    }

    public Ticket getCurrentTicket() {
        return this.c;
    }

    private void a(OrderType orderType) {
        if (orderType.isRetailOrder().booleanValue()) {
            this.h();
        } else {
            this.i();
        }
        this.revalidate();
        this.repaint();
    }

    private void f() {
        this.n.setVisible(false);
        this.p.setVisible(false);
        this.y.setVisible(false);
        this.B.setVisible(false);
        this.q.setVisible(false);
        this.t.setVisible(false);
        this.w.setVisible(false);
        this.z.setVisible(false);
        this.r.setVisible(false);
        this.u.setVisible(false);
        this.o.setVisible(false);
    }

    private void g() {
        this.n.setVisible(true);
        this.p.setVisible(true);
        this.B.setVisible(true);
        this.q.setVisible(true);
        this.m.setVisible(true);
        this.s.setVisible(true);
        this.z.setVisible(true);
        this.r.setVisible(true);
        this.o.setVisible(true);
        this.u.setVisible(true);
    }

    private void h() {
        this.removeAll();
        if (this.K == null) {
            SettleTicketProcessor settleTicketProcessor = new SettleTicketProcessor(null, this);
            settleTicketProcessor.addPaymentListener(this);
            this.K = new PaymentView(settleTicketProcessor, this);
        }
        this.g.showSettleButton(false);
        this.j.setVisible(true);
        this.i.add((Component)this.l, "South");
        this.add((Component)this.i, "Center");
        this.add((Component)this.K, "East");
    }

    private void i() {
        this.removeAll();
        this.g();
        this.j.setVisible(false);
        this.g.showSettleButton(true);
        this.add((Component)this.d, "East");
        this.add((Component)this.i, "West");
        this.add((Component)this.h, "Center");
        this.add((Component)this.l, "South");
    }

    public void setCurrentTicket(Ticket ticket) {
        if (this.c != null && ticket != null) {
            OrderType orderType;
            OrderType orderType2 = this.c.getOrderType();
            if (!orderType2.equals(orderType = ticket.getOrderType())) {
                this.c = ticket;
                this.a(orderType);
            }
        } else if (this.c == null && ticket != null) {
            OrderType orderType = ticket.getOrderType();
            this.a(orderType);
        }
        this.c = ticket;
        this.g.setTicket(ticket);
        if (this.K != null) {
            this.K.setTicket(ticket);
        }
        this.A.clearSelectedSeat();
        this.updateView();
        this.k.fireTicketEditingStart(ticket);
    }

    public static synchronized OrderView getInstance() {
        if (b == null) {
            b = new OrderView();
        }
        return b;
    }

    public void resetView() {
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.j();
            this.g.setVisible(true);
        } else {
            this.g.setVisible(false);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), Messages.getString("OrderView.48"));
            }
        }
        this.setReturnMode(false);
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    private void j() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderView.this.d.initialize();
                }
                catch (Throwable throwable) {
                    POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
    }

    private void k() {
        try {
            if (this.c.getOrderType().isShowTableSelection().booleanValue() && this.c.getOrderType().isRequiredCustomerData().booleanValue()) {
                String string = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("OrderView.9"));
                if (StringUtils.isEmpty((String)string)) {
                    return;
                }
                User user = UserDAO.getInstance().findUserBySecretKey(string);
                if (user == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("OrderView.10"));
                    return;
                }
            }
            if (this.g.getTicket().getTicketItems() == null || this.g.getTicket().getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            this.g.doHoldOrder();
            this.g.setAllowToLogOut(true);
            this.k.fireTicketEditingFinish(this.c);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void l() {
        try {
            List<TicketItem> list;
            Ticket ticket = this.g.getTicket();
            Ticket ticket2 = ticket.clone(ticket);
            List<TicketItem> list2 = ticket2.getTicketItems();
            if (list2 == null || list2.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            Object object = list2.iterator();
            while (object.hasNext()) {
                list = object.next();
                if (((BaseTicketItem)((Object)list)).isPrintedToKitchen().booleanValue()) continue;
                object.remove();
            }
            if (ticket2.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            object = new ReorderDialog(ticket2);
            ((Dialog)object).setTitle(Messages.getString("OrderView.51"));
            ((JDialog)object).setDefaultCloseOperation(2);
            ((Dialog)object).setResizable(false);
            ((POSDialog)object).openFullScreen();
            if (!((POSDialog)object).isCanceled()) {
                list = ((ReorderDialog)object).getTicketItems();
                if (list == null) {
                    return;
                }
                for (TicketItem ticketItem : list) {
                    this.g.addTicketItem(ticketItem);
                }
                OrderController.saveOrder(this.g.getTicket());
                this.g.sendTicketToKitchen();
                this.g.getTicketViewerTable().repaint();
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void m() {
        try {
            PosPrinters posPrinters = DataProvider.get().getPrinters();
            if (posPrinters.getKitchenPrinters().size() == 0 && posPrinters.getStickerPrinters().size() == 0 && !posPrinters.isPrintToKds()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderView.52"));
                return;
            }
            this.g.sendTicketToKitchenByOption(this);
            this.g.updateTicketTitle();
            this.g.getTicketViewerTable().updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket ticket = this.getCurrentTicket();
        if (ticket.getOrderType() != null && ticket.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            return this.A.getSelectedSeatNumber();
        }
        return null;
    }

    public boolean updateSeat(TicketItem ticketItem) {
        return this.A.updateSeatNumber(ticketItem);
    }

    public boolean is_86Mode() {
        return this.C;
    }

    public void set_86Mode(boolean bl) {
        this.C = bl;
    }

    @Override
    public void paymentDone() {
        this.g.doFinishOrder();
        this.updateView();
    }

    @Override
    public void paymentCanceled() {
        if (this.c == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.c.getId()) && this.c.getDueAmount() > 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderView.53"));
            return;
        }
        if (StringUtils.isNotEmpty((String)this.c.getId())) {
            TicketDAO.getInstance().delete(this.c);
        }
        this.c.getTicketItems().clear();
        this.g.doCancelOrder();
        this.updateView();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
    }

    public PaymentView getPaymentView() {
        return this.K;
    }

    @Override
    public void itemAdded(Ticket ticket, TicketItem ticketItem) {
        if (ticket.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.K.updateView();
        }
    }

    @Override
    public void itemRemoved(TicketItem ticketItem) {
        if (this.c.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.K.updateView();
        }
    }

    public boolean isReturnMode() {
        return this.D;
    }

    public void setReturnMode(boolean bl) {
        this.D = bl;
    }

    @Override
    public void refresh() {
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.c.getId());
        this.setCurrentTicket(ticket);
    }
}

