/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.modifier.ModifierGroupSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierGroupView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.modifier.ModifierView;
import com.floreantpos.ui.views.order.modifier.TicketItemModifierTableView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ModifierSelectionDialog
extends POSDialog
implements ModifierGroupSelectionListener,
ModifierSelectionListener {
    private ModifierSelectionModel a;
    private ModifierGroupView b;
    private ModifierView c;
    private TicketItemModifierTableView d;
    private JPanel e = new JPanel(new BorderLayout(5, 5));
    private TransparentPanel f;
    private PosButton g;
    private PosButton h;

    public ModifierSelectionDialog(ModifierSelectionModel modifierSelectionModel) {
        super((Frame)Application.getPosWindow(), true);
        this.a = modifierSelectionModel;
        this.b();
        this.a();
    }

    private void a() {
        MenuItem menuItem = this.a.getMenuItem();
        if (this.a.getTicketItem().getTicketItemModifiers() == null) {
            List<MenuItemModifierSpec> list = menuItem.getMenuItemModiferSpecs();
            Multiplier multiplier = MultiplierDAO.getInstance().getDefaultMutltiplier();
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                List<DefaultMenuModifier> list2;
                if (!menuItemModifierSpec.isEnable().booleanValue() || (list2 = menuItemModifierSpec.getDefaultModifierList()) == null) continue;
                for (DefaultMenuModifier defaultMenuModifier : list2) {
                    MenuModifier menuModifier = defaultMenuModifier.getModifier();
                    Multiplier multiplier2 = defaultMenuModifier.getMultiplier();
                    if (multiplier2 == null) {
                        multiplier2 = multiplier;
                    }
                    menuModifier.setMenuItemModifierGroup(menuItemModifierSpec);
                    this.a(menuModifier, multiplier2, defaultMenuModifier.getQuantity());
                }
            }
        }
    }

    private void b() {
        this.setTitle(Messages.getString("ModifierSelectionDialog.0"));
        this.setLayout(new BorderLayout(PosUIManager.getSize(5), PosUIManager.getSize(5)));
        this.b = new ModifierGroupView(this.a);
        this.c = new ModifierView(this.a);
        this.d = new TicketItemModifierTableView(this.a);
        this.f = new TransparentPanel();
        this.f.setLayout((LayoutManager)new MigLayout("fill, ins 4", "fill", ""));
        this.e.add(this.d);
        this.add((Component)this.b, "East");
        this.add(this.c);
        this.add((Component)this.e, "West");
        this.createButtonPanel();
        this.setBounds(Application.getPosWindow().getBounds());
        this.d.addModifierSelectionListener(this);
        this.b.addModifierGroupSelectionListener(this);
        this.c.addModifierSelectionListener(this);
        this.b.selectFirst();
    }

    public void createButtonPanel() {
        this.g = new PosButton(Messages.getString("DONE"));
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierSelectionDialog.this.c();
            }
        });
        this.h = new PosButton(POSConstants.CANCEL.toUpperCase());
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierSelectionDialog.this.setCanceled(true);
                ModifierSelectionDialog.this.dispose();
            }
        });
        this.f.add(this.h);
        this.f.add(this.g);
    }

    public ModifierGroupView getModifierGroupView() {
        return this.b;
    }

    public void setModifierGroupView(ModifierGroupView modifierGroupView) {
        this.b = modifierGroupView;
    }

    public ModifierView getModifierView() {
        return this.c;
    }

    public void setModifierView(ModifierView modifierView) {
        this.c = modifierView;
    }

    private void c() {
        List<MenuItemModifierSpec> list = this.a.getMenuItem().getMenuItemModiferSpecs();
        if (list == null) {
            this.dispose();
            return;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            if (!menuItemModifierSpec.isEnable().booleanValue() || ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec)) continue;
            this.a(menuItemModifierSpec);
            this.b.setSelectedModifierGroup(menuItemModifierSpec);
        }
    }

    @Override
    public void modifierGroupSelected(MenuItemModifierSpec menuItemModifierSpec) {
        this.c.setModifierGroup(menuItemModifierSpec);
    }

    @Override
    public void modifierSelected(MenuModifier menuModifier, Multiplier multiplier) {
        this.a(menuModifier, multiplier);
    }

    private void a(MenuModifier menuModifier, Multiplier multiplier) {
        this.a(menuModifier, multiplier, 1.0);
    }

    private void a(MenuModifier menuModifier, Multiplier multiplier, Double d) {
        TicketItem ticketItem = this.a.getTicketItem();
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        int n = ticketItem.countModifierFromGroup(menuItemModifierSpec);
        int n2 = menuItemModifierSpec.getMinQuantity();
        int n3 = menuItemModifierSpec.getMaxQuantity();
        if (n3 < n2) {
            n3 = n2;
        }
        if (n >= n3) {
            POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.3") + menuModifier.getMenuItemModifierGroup().getDisplayName());
            return;
        }
        TicketItemModifier ticketItemModifier = ticketItem.findTicketItemModifierFor(menuModifier, multiplier);
        if (ticketItemModifier == null) {
            OrderType orderType = ticketItem.getTicket().getOrderType();
            TicketItemModifier ticketItemModifier2 = ticketItem.addTicketItemModifier(menuModifier, 1, orderType, multiplier);
            ticketItemModifier2.setItemQuantity(d);
        } else {
            ticketItemModifier.setItemCount(ticketItemModifier.getItemCount() + 1);
        }
        this.d();
        if (n + 1 == n3) {
            this.modifierGroupSelectionDone(menuModifier.getMenuItemModifierGroup());
        }
    }

    private void d() {
        this.a.getTicketItem().calculatePrice();
        this.c.updateView();
        this.d.updateView();
    }

    @Override
    public void clearModifiers(MenuItemModifierSpec menuItemModifierSpec) {
        TicketItem ticketItem = this.a.getTicketItem();
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null) {
            Iterator<TicketItemModifier> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (ticketItemModifier.isPrintedToKitchen().booleanValue()) continue;
                iterator.remove();
            }
        }
        this.d();
    }

    @Override
    public void modifierGroupSelectionDone(MenuItemModifierSpec menuItemModifierSpec) {
        if (!ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec)) {
            this.a(menuItemModifierSpec);
            this.b.setSelectedModifierGroup(menuItemModifierSpec);
            return;
        }
        if (menuItemModifierSpec.isJumpGroup().booleanValue() && this.b.hasNextMandatoryGroup()) {
            this.b.selectNextGroup();
        }
    }

    @Override
    public void finishModifierSelection() {
        TicketItem ticketItem = this.a.getTicketItem();
        List<MenuItemModifierSpec> list = this.a.getMenuItem().getMenuItemModiferSpecs();
        if (list == null) {
            this.setCanceled(false);
            this.dispose();
            return;
        }
        if (!list.isEmpty()) {
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                if (ticketItem.requiredModifiersAdded(menuItemModifierSpec)) continue;
                this.modifierGroupSelected(menuItemModifierSpec);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ModifierSelectionDialog.7"));
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    public ModifierSelectionModel getModifierSelectionModel() {
        return this.a;
    }

    public void setModifierSelectionModel(ModifierSelectionModel modifierSelectionModel) {
        this.a = modifierSelectionModel;
    }

    public static boolean isRequiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        return ticketItem.requiredModifiersAdded(menuItemModifierSpec);
    }

    private void a(MenuItemModifierSpec menuItemModifierSpec) {
        String string = menuItemModifierSpec.getName();
        int n = menuItemModifierSpec.getMinQuantity();
        POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.5") + n + Messages.getString("ModifierSelectionDialog.6") + string);
    }

    @Override
    public void modifierRemoved(TicketItemModifier ticketItemModifier) {
        MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(ticketItemModifier.getGroupId());
        this.c.setModifierGroup(menuItemModifierSpec);
    }
}

