/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.server.BaseDataServiceDao;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class OroMqttMessageReceiver
implements IMqttMessageListener {
    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        String string2 = POSUtil.decompress(mqttMessage.getPayload());
        if (StringUtils.isEmpty((String)string2)) {
            return;
        }
        this.debug("Notification received: ");
        JSONObject jSONObject = new JSONObject(string2);
        if (!this.acceptMessage(jSONObject)) {
            return;
        }
        try {
            this.messageReceived(jSONObject);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void debug(String string) {
        PosLog.debug(OroMqttClient.class, string);
    }

    private boolean acceptMessage(JSONObject jSONObject) {
        String string;
        String string2;
        String string3 = jSONObject.getString("deviceId");
        if (string3 != null && string3.equals(Application.getInstance().getMqttDeviceId())) {
            return false;
        }
        if (!jSONObject.has("request")) {
            this.debug("Empty request");
            return false;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal == null) {
            return false;
        }
        boolean bl = terminal.isMasterTerminal();
        if (!bl) {
            this.debug("Notification skipped. This is not master terminal.");
        }
        if (StringUtils.isEmpty((String)(string2 = Application.getInstance().getCurrentTerminalOutletId()))) {
            this.debug("Notification skipped. No outlet is defined for this terminal.");
            return false;
        }
        String string4 = string = jSONObject.has("outletId") ? jSONObject.getString("outletId") : null;
        if (StringUtils.isNotEmpty((String)string) && !string.equals(string2)) {
            this.debug("Notification skipped. Outlet not match.");
            return false;
        }
        if (bl) {
            Integer n;
            Integer n2 = n = jSONObject.has("blockTerminalId") ? Integer.valueOf(jSONObject.getInt("blockTerminalId")) : null;
            if (n != null && n > 0 && terminal.getId() == n) {
                return false;
            }
        }
        return bl;
    }

    private void messageReceived(JSONObject jSONObject) throws Exception {
        BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.getInstance();
        String string = jSONObject.toString();
        switch (jSONObject.getString("request")) {
            case "Ticket Notification": {
                baseDataServiceDao.saveOrUpdateTickets(string, false);
                break;
            }
            case "Cash Drawer Notification": {
                baseDataServiceDao.saveOrUpdateCashDrawers(string);
                break;
            }
            case "Menu Item": {
                baseDataServiceDao.saveOrUpdateMenuItems(string);
                break;
            }
            case "Menu Group": {
                baseDataServiceDao.saveOrUpdateMenuGroups(string);
                break;
            }
            case "Menu Category": {
                baseDataServiceDao.saveOrUpdateMenuCategories(string);
                break;
            }
            case "Terminal": {
                baseDataServiceDao.saveOrUpdateTerminals(string);
                break;
            }
            case "Order Type": {
                baseDataServiceDao.saveOrUpdateDataList(string, OrderType.class);
                break;
            }
            case "Table Notification": {
                baseDataServiceDao.saveOrUpdateDataList(string, ShopTable.class);
                break;
            }
            case "Kitchen Ticket Notification": {
                baseDataServiceDao.saveOrUpdateKitchenTickets(string);
                break;
            }
            case "Log File Request": {
                MailService.doSendEmailPosLogFile(string);
            }
        }
    }
}

