/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TaxSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class TaxGroupExplorer
extends TransparentPanel
implements ActionListener,
ListSelectionListener {
    private static final long a = 1L;
    private JXTreeTable b;
    private TaxGroupTreeTableModel c;
    private List<TaxGroup> d;

    public TaxGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new JXTreeTable();
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.setRootVisible(false);
        this.doRefreshTree();
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = TaxGroupExplorer.this.b.columnAtPoint(mouseEvent.getPoint());
                if (mouseEvent.getClickCount() == 2 && n == 0) {
                    TaxGroupExplorer.this.b.expandPath(TaxGroupExplorer.this.b.getPathForRow(TaxGroupExplorer.this.b.getSelectedRow()));
                } else if (mouseEvent.getClickCount() == 2 && n != 0) {
                    TaxGroupExplorer.this.c();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.b), "Center");
        this.b();
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
    }

    private void a() {
        if (this.d != null) {
            TaxGroup taxGroup = new TaxGroup();
            taxGroup.setId(Messages.getString("TaxGroupExplorer.0"));
            taxGroup.setName(Messages.getString("TaxGroupExplorer.1"));
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)taxGroup);
            defaultMutableTreeTableNode.setUserObject((Object)taxGroup);
            for (TaxGroup taxGroup2 : this.d) {
                DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)taxGroup2);
                defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
                this.a(defaultMutableTreeTableNode2);
            }
            this.c = new TaxGroupTreeTableModel(defaultMutableTreeTableNode);
            this.b.setTreeTableModel((TreeTableModel)this.c);
        }
    }

    private void a(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        TaxGroup taxGroup = (TaxGroup)defaultMutableTreeTableNode.getUserObject();
        if (taxGroup == null) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<Tax> list = taxGroup.getTaxes();
        for (Tax tax : list) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)tax);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
        }
    }

    private void b() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = new JButton(Messages.getString("TaxGroupExplorer.8"));
        JButton jButton2 = new JButton(Messages.getString("TaxGroupExplorer.9"));
        JButton jButton3 = explorerButtonPanel.getEditButton();
        JButton jButton4 = explorerButtonPanel.getDeleteButton();
        JButton jButton5 = new JButton(Messages.getString("Refresh"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("TaxGroupExplorer.10"));
                    if (string == null) {
                        return;
                    }
                    if (string.length() > 30) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxGroupExplorer.11"));
                        return;
                    }
                    TaxGroup taxGroup = new TaxGroup();
                    GenericDAO.getInstance().checkIdOrNameExists(taxGroup.getId(), string, TaxGroup.class);
                    taxGroup.setName(string);
                    TaxGroupDAO taxGroupDAO = new TaxGroupDAO();
                    taxGroupDAO.saveOrUpdate(taxGroup);
                    if (taxGroup != null) {
                        MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)TaxGroupExplorer.this.c.getRoot();
                        TaxGroupExplorer.this.c.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)taxGroup), mutableTreeTableNode, mutableTreeTableNode.getChildCount());
                    }
                    TaxGroupExplorer.this.b.expandAll();
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaxGroup taxGroup = TaxGroupExplorer.this.getSelectedGroup();
                if (taxGroup == null) {
                    POSMessageDialog.showError(TaxGroupExplorer.this, Messages.getString("TaxGroupExplorer.12"));
                } else {
                    TaxSelectionDialog taxSelectionDialog = new TaxSelectionDialog(taxGroup);
                    taxSelectionDialog.setSize(500, 400);
                    taxSelectionDialog.open();
                    if (taxSelectionDialog.isCanceled()) {
                        return;
                    }
                    List<Tax> list = taxSelectionDialog.getSelectedTaxList();
                    taxGroup.setTaxes(list);
                    TaxGroupDAO.getInstance().saveOrUpdate(taxGroup);
                    TaxGroupExplorer.this.doRefreshTree();
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaxGroupExplorer.this.c();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaxGroupExplorer.this.d();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaxGroupExplorer.this.doRefreshTree();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        transparentPanel.add(jButton5);
        this.add((Component)transparentPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void c() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof TaxGroup) {
                TaxGroup taxGroup = (TaxGroup)defaultMutableTreeTableNode.getUserObject();
                String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), Messages.getString("TaxGroupExplorer.17"), taxGroup.getName());
                if (string == null) {
                    return;
                }
                if (string.length() > 30) {
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxGroupExplorer.18"));
                    return;
                }
                GenericDAO.getInstance().checkIdOrNameExists(taxGroup.getId(), string, TaxGroup.class);
                taxGroup.setName(string);
                TaxGroupDAO taxGroupDAO = new TaxGroupDAO();
                taxGroupDAO.saveOrUpdate(taxGroup);
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof Tax) {
                POSMessageDialog.showError(this, Messages.getString("TaxGroupExplorer.19"));
                return;
            }
            this.doRefreshTree();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    public void doRefreshTree() {
        this.d = TaxGroupDAO.getInstance().findAll();
        this.a();
        this.b.expandAll();
    }

    public Tax getSelectedAtrribute() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof TaxGroup) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TaxGroupExplorer.20"));
                return null;
            }
            if (defaultMutableTreeTableNode.getUserObject() instanceof Tax) {
                return (Tax)defaultMutableTreeTableNode.getUserObject();
            }
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return null;
    }

    public TaxGroup getSelectedGroup() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof TaxGroup) {
                return (TaxGroup)defaultMutableTreeTableNode.getUserObject();
            }
            if (defaultMutableTreeTableNode.getUserObject() instanceof Tax) {
                return (TaxGroup)defaultMutableTreeTableNode.getParent().getUserObject();
            }
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return null;
    }

    public MutableTreeTableNode findTreeNodeForTax(MutableTreeTableNode mutableTreeTableNode, String string) {
        block5: {
            block4: {
                if (!(((DefaultMutableTreeTableNode)mutableTreeTableNode).getUserObject() instanceof TaxGroup)) break block4;
                TaxGroup taxGroup = (TaxGroup)mutableTreeTableNode.getUserObject();
                if (string.equals(taxGroup.getId())) {
                    return mutableTreeTableNode;
                }
                Enumeration enumeration = mutableTreeTableNode.children();
                while (enumeration.hasMoreElements()) {
                    MutableTreeTableNode mutableTreeTableNode2 = (MutableTreeTableNode)enumeration.nextElement();
                    MutableTreeTableNode mutableTreeTableNode3 = this.findTreeNodeForTax(mutableTreeTableNode2, string);
                    if (mutableTreeTableNode3 == null) continue;
                    return mutableTreeTableNode3;
                }
                break block5;
            }
            if (!(((DefaultMutableTreeTableNode)mutableTreeTableNode).getUserObject() instanceof Tax)) break block5;
            Tax tax = (Tax)mutableTreeTableNode.getUserObject();
            if (string.equals(tax.getId())) {
                return mutableTreeTableNode;
            }
            Enumeration enumeration = mutableTreeTableNode.children();
            while (enumeration.hasMoreElements()) {
                MutableTreeTableNode mutableTreeTableNode4 = (MutableTreeTableNode)enumeration.nextElement();
                MutableTreeTableNode mutableTreeTableNode5 = this.findTreeNodeForTax(mutableTreeTableNode4, string);
                if (mutableTreeTableNode5 == null) continue;
                return mutableTreeTableNode5;
            }
        }
        return null;
    }

    private void d() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof TaxGroup) {
                TaxGroup taxGroup = (TaxGroup)defaultMutableTreeTableNode.getUserObject();
                String string = Messages.getString("TaxGroupExplorer.14");
                string = String.format(string, taxGroup.getName());
                if (POSMessageDialog.showYesNoQuestionDialog(this.getRootPane(), string, POSConstants.DELETE) != 0) {
                    return;
                }
                TaxGroupDAO taxGroupDAO = new TaxGroupDAO();
                taxGroupDAO.delete(taxGroup);
                MutableTreeTableNode mutableTreeTableNode = this.findTreeNodeForTax((MutableTreeTableNode)this.c.getRoot(), taxGroup.getId());
                if (mutableTreeTableNode.getParent() != null) {
                    this.c.removeNodeFromParent(mutableTreeTableNode);
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof Tax) {
                Tax tax = (Tax)defaultMutableTreeTableNode.getUserObject();
                TaxGroup taxGroup = (TaxGroup)defaultMutableTreeTableNode.getParent().getUserObject();
                String string = Messages.getString("TaxGroupExplorer.15");
                string = String.format(string, tax.getName(), taxGroup.getName());
                if (POSMessageDialog.showYesNoQuestionDialog(this.getRootPane(), string, POSConstants.DELETE) != 0) {
                    return;
                }
                List<Tax> list = taxGroup.getTaxes();
                if (list == null) {
                    return;
                }
                list.remove(tax);
                TaxGroupDAO.getInstance().update(taxGroup);
                MutableTreeTableNode mutableTreeTableNode = this.findTreeNodeForTax((MutableTreeTableNode)this.c.getRoot(), tax.getId());
                if (mutableTreeTableNode.getParent() != null) {
                    this.c.removeNodeFromParent(mutableTreeTableNode);
                }
            }
            this.doRefreshTree();
            this.b.repaint();
            this.b.revalidate();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    class TaxGroupTreeTableModel
    extends DefaultTreeTableModel {
        private final String[] b;

        public TaxGroupTreeTableModel(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
            super((TreeTableNode)defaultMutableTreeTableNode);
            this.b = new String[]{Messages.getString("TaxGroupExplorer.2"), Messages.getString("NAME"), Messages.getString("TaxGroupExplorer.4")};
        }

        public void setRoot(TreeTableNode treeTableNode) {
            super.setRoot(treeTableNode);
        }

        public int getColumnCount() {
            return this.b.length;
        }

        public String getColumnName(int n) {
            return this.b[n];
        }

        public boolean isCellEditable(Object object, int n) {
            return false;
        }

        public Object getValueAt(Object object, int n) {
            if (object instanceof DefaultMutableTreeTableNode) {
                if (((DefaultMutableTreeTableNode)object).getUserObject() instanceof TaxGroup) {
                    TaxGroup taxGroup = (TaxGroup)((DefaultMutableTreeTableNode)object).getUserObject();
                    if (taxGroup == null) {
                        return "";
                    }
                    switch (n) {
                        case 0: {
                            return taxGroup.getName();
                        }
                    }
                } else if (((DefaultMutableTreeTableNode)object).getUserObject() instanceof Tax) {
                    Tax tax = (Tax)((DefaultMutableTreeTableNode)object).getUserObject();
                    if (tax == null) {
                        return "";
                    }
                    switch (n) {
                        case 1: {
                            return tax.getName();
                        }
                        case 2: {
                            return NumberUtil.trimDecilamIfNotNeeded(tax.getRate()) + "% ";
                        }
                    }
                }
            }
            return null;
        }
    }
}

