/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ChargeConfigurationView;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.OrderViewDisplayConfigurationView;
import com.floreantpos.config.ui.StoreBrandingConfigurationView;
import com.floreantpos.config.ui.StoreConfigurationView;
import com.floreantpos.config.ui.TicketImportConfigurationView;
import com.floreantpos.config.ui.TipsConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.TicketImportPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class StoreConfigurationDialog
extends POSDialog
implements ActionListener,
ChangeListener {
    private static final String a = POSConstants.OK;
    private static final String b = POSConstants.CANCEL;
    private JTabbedPane c = new JTabbedPane();
    private List<ConfigurationView> d = new ArrayList<ConfigurationView>();
    private Store e;

    public StoreConfigurationDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        Application.getInstance().refreshStore();
        this.e = Application.getInstance().getStore();
        this.setTitle(POSConstants.STORE_CONFIGURATION_WINDOW_TITLE);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill", "", "[fill,grow][]"));
        this.c.addChangeListener(this);
        jPanel.add((Component)this.c, "span, grow");
        this.addView(new StoreConfigurationView(this.e));
        this.addView(new ChargeConfigurationView(this.e));
        this.addView(new StoreBrandingConfigurationView(this.e));
        this.addView(new TipsConfigurationView(this.e));
        this.addView(new OrderViewDisplayConfigurationView(this.e));
        TicketImportPlugin ticketImportPlugin = (TicketImportPlugin)ExtensionManager.getPlugin(TicketImportPlugin.class);
        if (ticketImportPlugin != null) {
            this.addView(new TicketImportConfigurationView());
        }
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        JButton jButton = new JButton(b);
        jButton.addActionListener(this);
        jPanel2.add((Component)jButton, "dock east, gaptop 5,gapright 8, gapbottom 10");
        JButton jButton2 = new JButton(a);
        jButton2.addActionListener(this);
        jPanel2.add((Component)jButton2, "dock east, gapright 5, gaptop 5, gapbottom 10");
        this.add((Component)jPanel2, "South");
        this.setDefaultCloseOperation(2);
        this.add((Component)jPanel, "Center");
    }

    public void addView(ConfigurationView configurationView) {
        this.c.addTab(configurationView.getName(), configurationView);
        this.d.add(configurationView);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.stateChanged(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ConfigurationView configurationView = (ConfigurationView)this.c.getSelectedComponent();
        try {
            if (!configurationView.isInitialized()) {
                configurationView.initialize();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (a.equalsIgnoreCase(actionEvent.getActionCommand())) {
            try {
                for (ConfigurationView configurationView : this.d) {
                    if (!configurationView.isInitialized()) continue;
                    configurationView.save();
                }
                StoreDAO.getInstance().saveOrUpdate(this.e);
                Application.getInstance().refreshStore();
                this.setCanceled(false);
                this.dispose();
            }
            catch (PosException posException) {
                POSMessageDialog.showError(this, posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
            }
        } else if (b.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.setCanceled(true);
            this.dispose();
        }
    }
}

