/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.mailservices;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.sendgrid.Attachments;
import com.sendgrid.Content;
import com.sendgrid.Email;
import com.sendgrid.Mail;
import com.sendgrid.Method;
import com.sendgrid.Request;
import com.sendgrid.SendGrid;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class MailService {
    private static String a = "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";
    private static String b = "noreply@orocube.com";

    public static void setApiKey(String string) {
        a = string;
    }

    public static void setSenderEmail(String string) {
        b = string;
    }

    public static void sendTicket(String string, Ticket ticket) throws Exception {
        if (!MailService.isValidEmail(string)) {
            throw new PosException(Messages.getString("MailService.3"));
        }
        byte[] byArray = ReceiptPrintService.createPDFStream(ticket);
        String string2 = "Ticket Receipt";
        if (!MailService.sendMail(string, string2, string2, string2, "TICKET_RECEIPT_" + ticket.getId() + ".pdf", byArray)) {
            throw new PosException(Messages.getString("MailService.8"));
        }
    }

    public static boolean isValidEmail(String string) {
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", 2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static boolean sendMail(String string, String string2, String string3) {
        return MailService.sendMail(string, string2, string3, null, null, null);
    }

    public static boolean sendMail(String string, String string2, String string3, String string4, String string5, byte[] byArray) {
        return MailService.sendMail(string, string2, string3, string4, string5, byArray, "application/pdf");
    }

    public static boolean sendMail(String string, String string2, String string3, String string4, String string5, byte[] byArray, String string6) {
        try {
            Base64 base64;
            Attachments attachments;
            if (StringUtils.isEmpty((String)b) || StringUtils.isEmpty((String)a)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MailService.6"));
                return false;
            }
            SendGrid sendGrid = new SendGrid(a);
            Email email = new Email(b);
            Email email2 = new Email(string);
            Content content = new Content("text/html", string3);
            Mail mail = new Mail(email, string2, email2, content);
            if (byArray != null) {
                attachments = new Attachments();
                base64 = new Base64();
                String string7 = base64.encodeAsString(byArray);
                attachments.setContent(string7);
                attachments.setType(string6);
                attachments.setFilename(string5);
                attachments.setDisposition("attachment");
                attachments.setContentId(string4);
                mail.addAttachments(attachments);
            }
            attachments = new Request();
            attachments.setMethod(Method.POST);
            attachments.setEndpoint("mail/send");
            attachments.setBody(mail.build());
            base64 = sendGrid.api((Request)attachments);
            PosLog.debug(MailService.class, "SendGrid mail send response code: " + base64.getStatusCode());
            PosLog.debug(MailService.class, "SendGrid mail send response header: " + base64.getHeaders());
            PosLog.info(MailService.class, Messages.getString("MailService.11"));
            return true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void doSendEmailPosLogFile(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("data");
            PosLog.debug(MailService.class, "Request received: " + string);
            if (StringUtils.isEmpty((String)string2)) {
                PosLog.error(MailService.class, Messages.getString("MailService.4"));
                return;
            }
            String string3 = VersionInfo.getAppName() + ".log";
            File file = new File(System.getProperty("user.home") + "\\" + string3);
            if (!file.exists()) {
                PosLog.error(MailService.class, Messages.getString("MailService.15"));
                return;
            }
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            String string4 = VersionInfo.getAppName() + " log";
            String string5 = "<html><body>Terminal no: " + terminal.getId() + "<br/>Terminal name: " + terminal.getName() + "</body></html>";
            MailService.sendMail(string2, string4, string5, string3, string3, FileUtils.readFileToByteArray((File)file), "text/plain");
        }
        catch (Exception exception) {
            PosLog.error(MailService.class, exception.getMessage());
        }
    }
}

