/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseDiscount;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Discount
extends BaseDiscount
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final int FREE_AMOUNT = 0;
    public static final int FIXED_PER_CATEGORY = 1;
    public static final int FIXED_PER_ITEM = 2;
    public static final int FIXED_PER_ORDER = 3;
    public static final int PERCENTAGE_PER_CATEGORY = 4;
    public static final int PERCENTAGE_PER_ITEM = 5;
    public static final int PERCENTAGE_PER_ORDER = 6;
    public static final int DISCOUNT_TYPE_AMOUNT = 0;
    public static final int DISCOUNT_TYPE_PERCENTAGE = 1;
    public static final int DISCOUNT_TYPE_REPRICE = 2;
    public static final int DISCOUNT_TYPE_ALT_PRICE = 4;
    public static final int QUALIFICATION_TYPE_ITEM = 0;
    public static final int QUALIFICATION_TYPE_ORDER = 1;
    public static final String[] COUPON_TYPE_NAMES = new String[]{"AMOUNT", "PERCENTAGE", "REPRICE"};
    public static final String[] COUPON_QUALIFICATION_NAMES = new String[]{"ITEM", "ORDER"};
    @XmlTransient
    private List<String> menuItemIds;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public Discount() {
    }

    public Discount(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public double calculateDiscount(ITicketItem iTicketItem) {
        switch (this.getType()) {
            case 0: {
                return iTicketItem.getUnitPriceDisplay();
            }
            case 1: {
                return this.getValue() * iTicketItem.getUnitPriceDisplay() / 100.0;
            }
        }
        return 0.0;
    }

    public double getAmountByType(double d) {
        switch (this.getType()) {
            case 0: {
                return d - this.getValue();
            }
            case 1: {
                return d - this.getValue() / 100.0;
            }
        }
        return 0.0;
    }

    @XmlTransient
    public List<String> getMenuItemIds() {
        return this.menuItemIds;
    }

    public void setMenuItemIds(List<String> list) {
        this.menuItemIds = list;
    }
}

