/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseImageResource;
import com.floreantpos.swing.PosUIManager;
import java.awt.Image;
import java.sql.Blob;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"asIcon", "image", "scaledImage", "buttonImage", "buttonBigImage", "imageIcon"})
public class ImageResource
extends BaseImageResource
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public ImageResource() {
    }

    public ImageResource(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    @Deprecated
    public Blob getImageData() {
        return super.getImageData();
    }

    @Override
    @Deprecated
    public void setImageData(Blob blob) {
        super.setImageData(blob);
    }

    public IMAGE_CATEGORY getImageCategory() {
        return IMAGE_CATEGORY.fromInt(super.getImageCategoryNum());
    }

    public void setImageCategory(IMAGE_CATEGORY iMAGE_CATEGORY) {
        super.setImageCategoryNum(iMAGE_CATEGORY.getType());
    }

    public ImageIcon getScaledImage(int n, int n2) {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
        return new ImageIcon(image);
    }

    public ImageIcon getButtonImage() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        int n = imageIcon.getIconHeight();
        int n2 = imageIcon.getIconWidth();
        if (n2 > n) {
            int n3 = 80;
            int n4 = n * n3 / n2;
            Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n3), PosUIManager.getSize(n4), 4);
            return new ImageIcon(image);
        }
        int n5 = 80;
        int n6 = n2 * n5 / n;
        Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n6), PosUIManager.getSize(n5), 4);
        return new ImageIcon(image);
    }

    public ImageIcon getButtonBigImage() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        int n = imageIcon.getIconHeight();
        int n2 = imageIcon.getIconWidth();
        if (n2 > n) {
            int n3 = 200;
            int n4 = n * n3 / n2;
            Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n3), PosUIManager.getSize(n4), 4);
            return new ImageIcon(image);
        }
        int n5 = 200;
        int n6 = n2 * n5 / n;
        Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n6), PosUIManager.getSize(n5), 4);
        return new ImageIcon(image);
    }

    @XmlTransient
    public Image getImage() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        return new ImageIcon(byArray).getImage();
    }

    public ImageIcon getImageIcon() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        return new ImageIcon(byArray);
    }

    @XmlTransient
    public ImageIcon getAsIcon() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        return this.getButtonImage();
    }

    public static enum IMAGE_CATEGORY {
        UNLISTED(0),
        FLOORPLAN(1),
        PRODUCTS(2),
        PEOPLE(3),
        DELETED(4);

        private int type;

        private IMAGE_CATEGORY(int n2) {
            this.type = n2;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public static IMAGE_CATEGORY fromInt(int n) {
            IMAGE_CATEGORY[] iMAGE_CATEGORYArray;
            for (IMAGE_CATEGORY iMAGE_CATEGORY : iMAGE_CATEGORYArray = IMAGE_CATEGORY.values()) {
                if (iMAGE_CATEGORY.type != n) continue;
                return iMAGE_CATEGORY;
            }
            return UNLISTED;
        }
    }
}

