/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.IdContainer;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "discounts", "menuPages"})
@XmlRootElement(name="menu-group")
public class MenuGroup
extends BaseMenuGroup
implements IdContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    public static String PROP_MENU_PAGES = "menuPages";
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Color buttonColor;
    private Color textColor;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public MenuGroup() {
    }

    public MenuGroup(String string) {
        super(string);
    }

    public MenuGroup(String string, String string2) {
        super(string, string2);
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null || this.getButtonColorCode() == 0) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isShowTranslatedName().booleanValue() && StringUtils.isNotEmpty((String)this.getTranslatedName())) {
            return this.getTranslatedName();
        }
        return super.getName();
    }

    public void setMenuCategory(MenuCategory menuCategory) {
        if (menuCategory == null) {
            this.setMenuCategoryId(null);
            this.setMenuCategoryName(null);
            this.setBeverage(false);
        } else {
            this.setMenuCategoryId(menuCategory.getId());
            this.setMenuCategoryName(menuCategory.getDisplayName());
            this.setBeverage(menuCategory.isBeverage());
        }
    }

    public void setParent(MenuCategory menuCategory) {
        this.setMenuCategory(menuCategory);
    }

    @XmlTransient
    public MenuCategory getParent() {
        String string = this.getMenuCategoryId();
        if (StringUtils.isNotEmpty((String)string)) {
            return MenuCategoryDAO.getInstance().get(string);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @JsonIgnore
    public String getUniqueId() {
        return ("menu_group_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

