/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.Image;
import java.sql.Blob;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"terminalTypes", "categories", "departments", "buttonColor", "textColor", "image", "scaledImage", "properties"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class OrderType
extends BaseOrderType
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String BAR_TAB = "BAR_TAB";
    public static final String FOR_HERE = "FOR HERE";
    public static final String TO_GO = "TO GO";
    @XmlTransient
    private Color buttonColor;
    @XmlTransient
    private Color textColor;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private byte[] imageBytes;

    public OrderType() {
    }

    public TaxGroup getDefaultTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getDefaultTaxGroupId());
    }

    public void setDefaultTaxGroup(TaxGroup taxGroup) {
        this.setDefaultTaxGroupId(taxGroup == null ? null : taxGroup.getId());
    }

    public TaxGroup getForHereTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getForHereTaxGroupId());
    }

    public void setForHereTaxGroup(TaxGroup taxGroup) {
        this.setForHereTaxGroupId(taxGroup == null ? null : taxGroup.getId());
    }

    public TaxGroup getToGoTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getToGoTaxGroupId());
    }

    public void setToGoTaxGroup(TaxGroup taxGroup) {
        this.setToGoTaxGroupId(taxGroup == null ? null : taxGroup.getId());
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    public OrderType(String string) {
        super(string);
    }

    public String name() {
        return super.getName();
    }

    public OrderType valueOf() {
        return this;
    }

    @Override
    public String toString() {
        return this.getName().replaceAll("_", " ");
    }

    @XmlTransient
    public ImageIcon getImage() {
        if (this.imageBytes == null) {
            return null;
        }
        return new ImageIcon(this.imageBytes);
    }

    @Override
    @XmlTransient
    public void setImageData(Blob blob) {
        super.setImageData(blob);
        if (blob != null) {
            try {
                int n = (int)blob.length();
                this.imageBytes = blob.getBytes(1L, n);
            }
            catch (SQLException sQLException) {
                PosLog.error(this.getClass(), sQLException);
            }
        }
    }

    public ImageIcon getScaledImage(int n, int n2) {
        Image image = null;
        if (this.imageBytes != null) {
            ImageIcon imageIcon = new ImageIcon(this.imageBytes);
            image = imageIcon.getImage().getScaledInstance(n, n2, 4);
            return new ImageIcon(image);
        }
        return null;
    }

    public String getUniqueId() {
        return ("order_type_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(string);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(byte[] byArray) {
        this.imageBytes = byArray;
    }
}

