/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Attribute;
import com.floreantpos.model.dao.BaseAttributeDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class AttributeDAO
extends BaseAttributeDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attribute> findAll() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias(Attribute.PROP_GROUP, "g");
            criteria.addOrder(Order.asc((String)"g.name"));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(Attribute attribute, String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Attribute.PROP_NAME, (Object)string).ignoreCase());
            if (attribute.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)Attribute.PROP_ID, (Object)attribute.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateAttributeList(List<Attribute> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Attribute attribute : list) {
                Attribute attribute2 = this.get(attribute.getId());
                if (attribute2 != null) {
                    long l = attribute2.getVersion();
                    PropertyUtils.copyProperties((Object)attribute2, (Object)attribute);
                    attribute2.setVersion(l);
                    attribute2.setUpdateLastUpdateTime(bl);
                    attribute2.setUpdateSyncTime(bl2);
                    this.update(attribute2, session);
                    continue;
                }
                attribute.setUpdateLastUpdateTime(bl);
                attribute.setUpdateSyncTime(bl2);
                this.save(attribute, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

