/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.BaseInventoryVendorItemsDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryVendorItemsDAO
extends BaseInventoryVendorItemsDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByItem(MenuItem menuItem) {
        if (menuItem.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuItem != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)menuItem));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryVendorItems findByItemAndVendor(MenuItem menuItem, InventoryVendor inventoryVendor) {
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuItem != null && inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)menuItem));
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                InventoryVendorItems inventoryVendorItems = null;
                return inventoryVendorItems;
            }
            InventoryVendorItems inventoryVendorItems = (InventoryVendorItems)list.get(0);
            return inventoryVendorItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vendorHasItem(InventoryVendor inventoryVendor, MenuItem menuItem, Session session) {
        if (menuItem.getId() == null) {
            return false;
        }
        boolean bl = false;
        try {
            List list;
            if (session == null) {
                session = this.createNewSession();
                bl = true;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuItem != null && inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)menuItem));
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (Exception exception) {
            PosLog.error(InventoryVendorDAO.class, exception.getMessage(), exception);
        }
        finally {
            if (bl && session != null) {
                session.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveItems(PurchaseOrder purchaseOrder) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
            for (PurchaseOrderItem purchaseOrderItem : list) {
                MenuItem menuItem = purchaseOrderItem.getMenuItem();
                InventoryVendor inventoryVendor = purchaseOrder.getVendor();
                if (this.vendorHasItem(inventoryVendor, menuItem, null)) continue;
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(menuItem);
                inventoryVendorItems.setVendor(inventoryVendor);
                session.saveOrUpdate((Object)inventoryVendorItems);
            }
            session.saveOrUpdate((Object)purchaseOrder);
            transaction.commit();
        }
    }

    public void saveItems(InventoryTransaction inventoryTransaction, Session session) {
        try {
            MenuItem menuItem = inventoryTransaction.getMenuItem();
            InventoryVendor inventoryVendor = null;
            if (inventoryTransaction.getVendorId() != null) {
                inventoryVendor = InventoryVendorDAO.getInstance().get(inventoryTransaction.getId());
            }
            if (!this.vendorHasItem(inventoryVendor, menuItem, session)) {
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(menuItem);
                inventoryVendorItems.setVendor(inventoryVendor);
                session.saveOrUpdate((Object)inventoryVendorItems);
            }
        }
        catch (Exception exception) {
            PosLog.error(InventoryVendorDAO.class, exception.getMessage(), exception);
        }
    }

    public void saveAll(List<InventoryVendorItems> list) {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveAll(list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveAll(List<InventoryVendorItems> list, Session session) {
        for (InventoryVendorItems inventoryVendorItems : list) {
            this.saveOrUpdate(inventoryVendorItems, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByVendor(InventoryVendor inventoryVendor) {
        if (inventoryVendor.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVendorItems(PaginatedListModel paginatedListModel, InventoryVendor inventoryVendor) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginatedListModel.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            List list = criteria.list();
            for (Object e : list) {
                InventoryVendorItems inventoryVendorItems;
                if (!(e instanceof InventoryVendorItems) || (inventoryVendorItems = (InventoryVendorItems)e).getItem() == null || inventoryVendorItems.getItem().getId() == null) continue;
                paginatedListModel.setData(criteria.list());
            }
        }
    }

    public void saveOrUpdateInventoryVendorItems(List<InventoryVendorItems> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryVendorItems inventoryVendorItems : list) {
                InventoryVendorItems inventoryVendorItems2 = this.get(inventoryVendorItems.getId());
                if (inventoryVendorItems2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(inventoryVendorItems.getLastUpdateTime(), inventoryVendorItems2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), inventoryVendorItems.getId() + " already updated");
                        continue;
                    }
                    long l = inventoryVendorItems2.getVersion();
                    PropertyUtils.copyProperties((Object)inventoryVendorItems2, (Object)inventoryVendorItems);
                    inventoryVendorItems2.setVersion(l);
                    inventoryVendorItems2.setUpdateLastUpdateTime(bl);
                    inventoryVendorItems2.setUpdateSyncTime(bl2);
                    this.update(inventoryVendorItems2, session);
                    continue;
                }
                inventoryVendorItems.setUpdateLastUpdateTime(bl);
                inventoryVendorItems.setUpdateSyncTime(bl2);
                this.save(inventoryVendorItems, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

