/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.GiftCardTransactionsReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class GiftCardTransactionReportView
extends TransparentPanel {
    private JButton a;
    private JPanel b;
    private JXDatePicker c;
    private JXDatePicker d;
    private JTextField e;

    public GiftCardTransactionReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() throws Exception {
        String string = this.e.getText();
        Date date = this.c.getDate();
        Date date2 = this.d.getDate();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("EnterCardNumber"));
            this.b.removeAll();
            return;
        }
        if (date.after(date2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            this.b.removeAll();
            return;
        }
        GiftCard giftCard = GiftCardDAO.getInstance().get(string);
        if (giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionReportView.1"));
            this.b.removeAll();
            return;
        }
        List<PosTransaction> list = PosTransactionDAO.getInstance().findTransactionListByGiftCardNumber(string, date, date2);
        if (list.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("GiftCardTransactionReportView.2"));
            this.b.removeAll();
            return;
        }
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("gift_card_transaction_report"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("reportTitle", Messages.getString("GiftCardTransactionsReport"));
        hashMap.put("reportTime", ReportService.formatFullDate(new Date()));
        hashMap.put("titleAmount", "Amount (" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("cardNo", giftCard.getCardNumber() != null ? giftCard.getCardNumber() : "");
        hashMap.put("cardOwner", giftCard.getOwnerName() != null ? giftCard.getOwnerName() : "");
        hashMap.put("endBalance", giftCard.getBalance() != null ? CurrencyUtil.getCurrencySymbol() + " " + NumberUtil.formatNumber(giftCard.getBalance()) : "");
        hashMap.put("activeDate", ReportService.formatFullDate(giftCard.getActivationDate()));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new GiftCardTransactionsReportModel(list)));
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.b.removeAll();
        this.b.add((Component)jRViewer);
        this.b.revalidate();
    }

    private void b() {
        JLabel jLabel = new JLabel(Messages.getString("GiftCardTransactionReportView.11"));
        this.e = new JTextField(20);
        this.c = UiUtil.getCurrentMonthStart();
        this.d = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GiftCardTransactionReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(jLabel);
        jPanel.add((Component)this.e, "grow");
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.d.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.d);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.b = new JPanel(new BorderLayout());
        jPanel2.add(this.b);
        this.add(jPanel2);
    }
}

