/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PrintTicketAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseAddress;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.KitchenStickerModel;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.LabelPrinterTableModel;
import com.floreantpos.report.OrderDataSource;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PrintServiceUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterAbortException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import us.fatehi.magnetictrack.bankcard.BankCardMagneticTrack;

public class ReceiptPrintService {
    private static final String a = "data";
    private static final String b = "title";
    private static final String c = "ORDER-";
    public static final String PROP_PRINTER_NAME = "printerName";
    private static final String d = "tipAmount";
    private static final String e = "serviceCharge";
    private static final String f = "deliveryCharge";
    private static final String g = "taxAmount";
    private static final String h = "discountAmount";
    private static final String i = "headerLine1";
    private static final String j = "reportDate";
    private static final String k = "showFooter";
    private static final String l = "showHeaderSeparator";
    private static final String m = "showSubtotal";
    private static final String n = "receiptType";
    private static final String o = "subTotalText";
    private static final String p = "quantityText";
    private static final String q = "itemText";
    private static Log r = LogFactory.getLog(ReceiptPrintService.class);
    public static final String CUSTOMER_COPY = "Customer Copy";
    public static final String DRIVER_COPY = "Driver Copy";
    public static final String CENTER = "center";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String OROPOS_PDF_PRINTER = Messages.getString("ReceiptPrintService.11");
    private static File s;

    public static void printGenericReport(String string, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(b, string);
        hashMap.put(a, string2);
        JasperPrint jasperPrint = ReceiptPrintService.createJasperPrint(ReportUtil.getReport("generic-receipt"), hashMap, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
        ReceiptPrintService.printQuitely(jasperPrint);
    }

    public static void testPrinter(String string, String string2, String string3) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(b, string2);
        hashMap.put(a, string3);
        JasperPrint jasperPrint = ReceiptPrintService.createJasperPrint(ReportUtil.getReport("test-printer"), hashMap, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty(PROP_PRINTER_NAME, string);
        ReceiptPrintService.printQuitely(jasperPrint);
    }

    public static JasperPrint createJasperPrint(JasperReport jasperReport, Map<String, Object> map, JRDataSource jRDataSource) throws Exception {
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)jRDataSource);
        return jasperPrint;
    }

    public static JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction posTransaction) throws Exception {
        TicketDataSource ticketDataSource = new TicketDataSource(ticket);
        ReciptPaperSize reciptPaperSize = ReceiptPrintService.b("main.recipt.paper_size");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-recipt")), map, (JRDataSource)new JRTableModelDataSource((TableModel)ticketDataSource));
    }

    public static JasperPrint createPurchaseOrderPrint(PurchaseOrder purchaseOrder) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap hashMap = ReceiptPrintService.populatePurchaseOrderProperties(purchaseOrder, ticketPrintProperties, null);
        hashMap.put("copyType", "");
        OrderDataSource orderDataSource = new OrderDataSource(purchaseOrder);
        String string = "order_receipt";
        hashMap.put("previousDueText", "Previous Due  ");
        hashMap.put("previousDue", "");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(string), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)orderDataSource));
    }

    public static JasperPrint createPurchaseOrderItemsBarcodePrint(List<LabelItem> list) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        LabelPrinterTableModel labelPrinterTableModel = new LabelPrinterTableModel(list);
        String string = "barcode_report";
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(string), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)labelPrinterTableModel));
    }

    public static JasperPrint printKitchenStickerItems(List<KitchenStickerModel.KitchenSticker> list) throws Exception {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            KitchenStickerModel kitchenStickerModel = new KitchenStickerModel(list);
            String string = "kitchenStickerReport";
            return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(string), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenStickerModel));
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception.getMessage(), exception);
            return null;
        }
    }

    public static byte[] createPDFStream(Ticket ticket) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
            return null;
        }
    }

    public static void printTicket(Ticket ticket) {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
        ReceiptPrintService.printTicket(ticket, hashMap);
    }

    public static void printTicket(Ticket ticket, HashMap hashMap) {
        try {
            boolean bl;
            boolean bl2 = ReceiptPrintService.a(ticket);
            if (!bl2 && !ReceiptPrintService.a(ticket, hashMap)) {
                return;
            }
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            boolean bl3 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
            if (bl) {
                paymentGatewayPlugin.printTicket(ticket);
                if (!bl2) {
                    ReceiptPrintService.e(ticket);
                }
                return;
            }
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            if (list == null) {
                return;
            }
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                r.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), string, ticket.getTotalAmount()));
                ReceiptPrintService.a(hashMap, string);
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, null);
                jasperPrint.setName(c + ticket.getId() + string);
                jasperPrint.setProperty(PROP_PRINTER_NAME, string);
                ReceiptPrintService.printQuitely(jasperPrint);
                if (bl2) continue;
                ReceiptPrintService.e(ticket);
            }
            Object object = Messages.getString("ReceiptPrintService.13");
            object = String.format((String)object, new Date(), ticket.getId(), ticket.getTotalAmount());
            ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), Messages.getString("ReceiptPrintService.19"), (String)object);
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    private static boolean a(Ticket ticket) {
        return ticket.getProperty("previewTicket") == null ? false : Boolean.parseBoolean(ticket.getProperty("previewTicket"));
    }

    private static boolean a(Ticket ticket, HashMap hashMap) throws NumberFormatException {
        String string = ticket.getProperty("printCount");
        int n = Integer.parseInt(string == null ? String.valueOf(0) : string);
        if (n > 0) {
            PrintTicketAction printTicketAction = new PrintTicketAction(ticket, hashMap);
            printTicketAction.setMandatoryPermission(true);
            if (!printTicketAction.hasPermission(Application.getCurrentUser(), UserPermission.PERFORM_MANAGER_TASK)) {
                return false;
            }
        }
        return true;
    }

    public static void printTicket(Ticket ticket, String string) {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
        hashMap.put("copyType", string);
        hashMap.put("cardPayment", true);
        ReceiptPrintService.printTicket(ticket, hashMap);
    }

    public static void printTicket(Ticket ticket, Terminal terminal) {
        try {
            Printer printer;
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            List<TerminalPrinters> list = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            for (TerminalPrinters serializable : list) {
                int n = serializable.getVirtualPrinter().getType();
                if (n != 1) continue;
                printer = new Printer(serializable.getVirtualPrinter(), serializable.getPrinterName());
                arrayList.add(printer);
            }
            for (Printer printer2 : arrayList) {
                String string = printer2.getDeviceName();
                if (string == null) continue;
                ReceiptPrintService.a(hashMap, string);
                printer = ReceiptPrintService.createPrint(ticket, hashMap, null);
                printer.setName(c + ticket.getId() + string);
                printer.setProperty(PROP_PRINTER_NAME, string);
                ReceiptPrintService.printQuitely((JasperPrint)printer);
            }
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static JasperPrint createRefundPrint(Ticket ticket, HashMap hashMap) throws Exception {
        TicketDataSource ticketDataSource = new TicketDataSource(ticket);
        ReciptPaperSize reciptPaperSize = ReceiptPrintService.b("main.recipt.paper_size");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-recipt")), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)ticketDataSource));
    }

    public static void printRefundTicket(Ticket ticket, List<PosTransaction> list) {
        try {
            if (list == null || list.isEmpty()) {
                return;
            }
            double d = 0.0;
            if (list != null) {
                for (PosTransaction serializable2 : list) {
                    if (!(serializable2 instanceof RefundTransaction) && !serializable2.isVoided().booleanValue()) continue;
                    d += serializable2.getAmount().doubleValue();
                }
            }
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            hashMap.put("refundAmountText", Messages.getString("ReceiptPrintService.1"));
            hashMap.put("refundAmount", NumberUtil.formatNumber(d));
            hashMap.put("cashRefundText", Messages.getString("ReceiptPrintService.2"));
            hashMap.put("cashRefund", NumberUtil.formatNumber(d));
            JasperPrint jasperPrint = ReceiptPrintService.createRefundPrint(ticket, hashMap);
            jasperPrint.setName("REFUND_" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printRefundTicket(Ticket ticket, RefundTransaction refundTransaction) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, refundTransaction);
            hashMap.put("refundAmountText", Messages.getString("ReceiptPrintService.1"));
            hashMap.put("refundAmount", NumberUtil.formatNumber(refundTransaction.getAmount()));
            hashMap.put("cashRefundText", Messages.getString("ReceiptPrintService.2"));
            hashMap.put("cashRefund", NumberUtil.formatNumber(refundTransaction.getAmount()));
            JasperPrint jasperPrint = ReceiptPrintService.createRefundPrint(ticket, hashMap);
            jasperPrint.setName("REFUND_" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printVoidTicket(Ticket ticket) {
        try {
            JasperPrint jasperPrint;
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** VOID RECEIPT ***", true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            String string = "";
            if (ticket.getTransactions() != null) {
                jasperPrint = ticket.getTransactions();
                double d = 0.0;
                if (jasperPrint != null) {
                    for (PosTransaction posTransaction : jasperPrint) {
                        if (!(posTransaction instanceof RefundTransaction) && !posTransaction.isVoided().booleanValue()) continue;
                        d += posTransaction.getAmount().doubleValue();
                    }
                }
                d = NumberUtil.roundToTwoDigit(d);
            }
            hashMap.put("additionalProperties", "<html><b>" + string + "</b></html>");
            hashMap.put("additionalPaymentProperties", "");
            jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, null);
            jasperPrint.setName("VOID_" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printTransaction(PosTransaction posTransaction, HashMap hashMap) {
        try {
            boolean bl;
            Ticket ticket = posTransaction.getTicket();
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            boolean bl2 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
            if (bl) {
                paymentGatewayPlugin.printTransaction(posTransaction, false, false);
                return;
            }
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                r.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), string, ticket.getTotalAmount()));
                ReceiptPrintService.a(hashMap, string);
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, posTransaction);
                jasperPrint.setName(c + ticket.getId() + string);
                jasperPrint.setProperty(PROP_PRINTER_NAME, string);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printTransaction(PosTransaction posTransaction) {
        boolean bl;
        Ticket ticket = posTransaction.getTicket();
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        boolean bl2 = posTransaction.getPaymentType().equals((Object)PaymentType.CASH);
        boolean bl3 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
        if (bl && bl2) {
            return;
        }
        if (bl) {
            paymentGatewayPlugin.printTransaction(posTransaction, false, false);
            return;
        }
        String string = Application.getPrinters().getReceiptPrinter();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
        if (posTransaction != null && posTransaction.isCard()) {
            hashMap.put("cardPayment", true);
            hashMap.put("copyType", Messages.getString("ReceiptPrintService.4"));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
            hashMap.put("copyType", Messages.getString("ReceiptPrintService.5"));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        } else if (posTransaction.getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
            hashMap.put("additionalPaymentProperties", ReceiptPrintService.b(posTransaction.getTicket()));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        } else {
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        }
    }

    public static void printTransaction(PosTransaction posTransaction, boolean bl) {
        ReceiptPrintService.printTransaction(posTransaction, false, bl);
    }

    public static void printTransaction(PosTransaction posTransaction, boolean bl, boolean bl2) {
        try {
            Ticket ticket = posTransaction.getTicket();
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            if (paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal()) {
                paymentGatewayPlugin.printTransaction(posTransaction, bl, bl2);
                return;
            }
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            if (posTransaction != null && posTransaction.isCard()) {
                hashMap.put("cardPayment", true);
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.7"));
                ReceiptPrintService.printTransaction(posTransaction, hashMap);
                if (bl2) {
                    hashMap.put("copyType", Messages.getString("ReceiptPrintService.8"));
                    ReceiptPrintService.printTransaction(posTransaction, hashMap);
                }
            } else {
                ReceiptPrintService.printTransaction(posTransaction, hashMap);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String b(Ticket ticket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<br/>");
        Customer customer = CustomerDAO.getInstance().findById(ticket.getCustomerId());
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("ReceiptPrintService.25"));
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("ReceiptPrintService.26") + customer.getId());
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("NAME") + customer.getName());
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("Balance") + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumberAcceptNegative(customer.getBalance()));
        ReceiptPrintService.b(stringBuilder);
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static JasperPrint getTransactionReceipt(PosTransaction posTransaction) {
        try {
            Ticket ticket = posTransaction.getTicket();
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            if (posTransaction != null && posTransaction.isCard()) {
                CardReader cardReader = CardReader.fromString(posTransaction.getCardReader());
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    return null;
                }
                hashMap.put("cardPayment", true);
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.4"));
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, posTransaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-CustomerCopy");
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.5"));
                jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, posTransaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-MerchantCopy");
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                return jasperPrint;
            }
            JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, posTransaction);
            jasperPrint.setName("Ticket-" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return jasperPrint;
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
            return null;
        }
    }

    private static void a(StringBuilder stringBuilder) {
        stringBuilder.append("<div>");
    }

    private static void b(StringBuilder stringBuilder) {
        stringBuilder.append("</div>");
    }

    private static void a(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<span>" + string + "</span>");
    }

    public static HashMap populateTicketProperties(Ticket ticket, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction) {
        return ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction, false);
    }

    public static HashMap populateTicketProperties(Ticket ticket, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction, boolean bl) {
        boolean bl2;
        Serializable serializable;
        CharSequence charSequence;
        Object object;
        Serializable serializable2;
        Object object2;
        Object object3;
        Application.getInstance().refreshStore();
        Store store = Application.getInstance().getStore();
        Terminal terminal = Application.getInstance().getTerminal();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        OrderType orderType = ticket.getOrderType();
        String string6 = "";
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (orderType != null) {
            string6 = orderType.getId();
        }
        if (bl) {
            string = ReceiptUtil.getReceiptSection(store, "kitchen.header", string6);
            string4 = ReceiptUtil.getReceiptSection(store, "kitchen.order.info", string6);
            string5 = ReceiptUtil.getReceiptSection(store, "kitchen.order.extrainfo1", string6);
            string2 = ReceiptUtil.getReceiptSection(store, "kitchen.footer", string6);
            string3 = ReceiptUtil.getReceiptSection(store, "kitchen.bottom", string6);
        } else {
            string = ReceiptUtil.getReceiptSection(store, "ticket.header", string6);
            string4 = ReceiptUtil.getReceiptSection(store, "ticket.order.info", string6);
            string5 = ReceiptUtil.getReceiptSection(store, "ticket.order.extrainfo1", string6);
            string2 = ReceiptUtil.getReceiptSection(store, "ticket.footer", string6);
            string3 = ReceiptUtil.getReceiptSection(store, "ticket.bottom", string6);
            ReceiptPrintService.a(hashMap, DataProvider.get().getPrinters().getReceiptPrinter());
        }
        boolean bl3 = Boolean.valueOf(ReceiptUtil.getReceiptSection(store, bl ? "kitchen.header.logo.show" : "ticket.header.logo.show", string6));
        double d = ticket.getTotalAmount();
        double d2 = 0.0;
        String string7 = CurrencyUtil.getCurrencySymbol();
        hashMap.put(ReceiptParam.STORE_NAME.getParamName(), store.getName());
        hashMap.put(ReceiptParam.STORE_ADDRESS1.getParamName(), store.getAddressLine1());
        hashMap.put(ReceiptParam.STORE_ADDRESS2.getParamName(), store.getAddressLine2());
        hashMap.put(ReceiptParam.STORE_ADDRESS3.getParamName(), store.getAddressLine3());
        hashMap.put(ReceiptParam.STORE_PHONE_NO.getParamName(), store.getTelephone());
        hashMap.put(ReceiptParam.CURRENCY_SYMBOL.getParamName(), string7);
        hashMap.put(ReceiptParam.TICKET_ID.getParamName(), ticket.getId());
        hashMap.put(ReceiptParam.TICKET_SHORT_ID.getParamName(), ticket.getShortId());
        hashMap.put(ReceiptParam.ORDER_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate()));
        hashMap.put(ReceiptParam.TOKEN_NO.getParamName(), "" + ticket.getTokenNo());
        if (ticket.getOrderType().isDelivery().booleanValue() || ticket.getOrderType().isPickup().booleanValue()) {
            if (ticket.isCustomerWillPickup().booleanValue()) {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "PICKUP");
            } else {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "DELIVERY");
            }
            hashMap.put(ReceiptParam.DELIVERY_ADDRESS.getParamName(), ticket.getDeliveryAddress() + ticket.getExtraDeliveryInfo());
            object3 = ticket.getDeliveryDate();
            if (object3 != null) {
                hashMap.put(ReceiptParam.DELIVERY_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString((Date)object3));
            }
        } else {
            hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), ticket.getOrderType());
        }
        hashMap.put(ReceiptParam.TERMINAL_ID.getParamName(), ticket.getTerminal().getId());
        hashMap.put(ReceiptParam.TERMINAL_NAME.getParamName(), ticket.getTerminal().getName());
        hashMap.put(ReceiptParam.SERVER_NAME.getParamName(), ticket.getOwner().getFullName());
        hashMap.put(ReceiptParam.SERVER_ID.getParamName(), ticket.getOwner().getId());
        hashMap.put(ReceiptParam.GUEST_COUNT.getParamName(), ticket.getNumberOfGuests().toString());
        object3 = ticket.getProperty("printCount");
        int n = Integer.parseInt((String)(object3 == null ? String.valueOf(0) : object3));
        if (n > 0) {
            hashMap.put(ReceiptParam.PRINT_COUNT.getParamName(), n);
        }
        if (terminal.isShowTableNumber()) {
            hashMap.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getTableNumbers() != null ? ticket.getTableNumbers().toString() : "");
        } else {
            hashMap.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getTableNames());
        }
        if (ticket.getCustomer() != null) {
            object2 = ticket.getCustomer();
            hashMap.put(ReceiptParam.CUSTOMER_NAME.getParamName(), ((Customer)object2).getName());
            hashMap.put(ReceiptParam.CUSTOMER_ID.getParamName(), ((BaseCustomer)object2).getMemberId() != null ? ((BaseCustomer)object2).getMemberId() : "");
            hashMap.put(ReceiptParam.CUSTOMER_PHONE.getParamName(), ((BaseCustomer)object2).getMobileNo());
            hashMap.put(ReceiptParam.CUSTOMER_SIGNATURE.getParamName(), ((BaseCustomer)object2).getSignatureImageId());
        }
        if (ticket.getSalesArea() != null) {
            object2 = ticket.getSalesArea();
            hashMap.put(ReceiptParam.SALES_AREA.getParamName(), ((BaseSalesArea)object2).getName());
        }
        if (ticket.getTransactions() != null) {
            object2 = PosTransactionDAO.getInstance().findLastTxPaymentTypeName(ticket);
            hashMap.put(ReceiptParam.PAYMENT_TYPE.getParamName(), object2);
        }
        if (ticket.getAssignedDriver() != null) {
            object2 = ticket.getAssignedDriver();
            hashMap.put(ReceiptParam.DRIVER_NAME.getParamName(), ((User)object2).getFullName());
            hashMap.put(ReceiptParam.DRIVER_ID.getParamName(), ((BaseUser)object2).getId());
        }
        if (string.contains((CharSequence)(object2 = ReceiptParam.BARCODE.getParamName())) || string4.contains((CharSequence)object2) || string5.contains((CharSequence)object2) || string2.contains((CharSequence)object2) || string3.contains((CharSequence)object2)) {
            hashMap.put(object2, String.valueOf(ticket.getId()));
        }
        hashMap.put(ReceiptParam.RECEIPT_TYPE.getParamName(), ticketPrintProperties.getReceiptTypeName());
        String string8 = ticket.getProperty("SPLIT_TICKET");
        if (StringUtils.isNotEmpty((String)string8)) {
            hashMap.put("splitTicketId", string8);
        }
        hashMap.put(ReceiptParam.PRINT_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(new Date()));
        hashMap.put(q, POSConstants.RECEIPT_REPORT_ITEM_LABEL);
        hashMap.put(p, POSConstants.RECEIPT_REPORT_QUANTITY_LABEL);
        hashMap.put(o, POSConstants.RECEIPT_REPORT_SUBTOTAL_LABEL);
        hashMap.put(m, ticketPrintProperties.isShowSubtotal());
        hashMap.put(l, Boolean.TRUE);
        hashMap.put(k, ticketPrintProperties.isShowFooter());
        String string9 = ReceiptPrintService.a(hashMap, string4);
        if (ticket.isVoided().booleanValue()) {
            string9 = string9 + Messages.getString("ReceiptPrintService.16") + "<br>";
        }
        hashMap.put("ticketHeader", string9);
        hashMap.put("additionalOrderInfo", ReceiptPrintService.a(hashMap, string5));
        hashMap.put(i, ReceiptPrintService.a(hashMap, string));
        if (ticketPrintProperties.isShowFooter()) {
            if (ticket.getDiscountAmount() > 0.0) {
                hashMap.put(h, NumberUtil.formatNumber(ticket.getDiscountAmount()));
            }
            if (ticket.getTaxAmount() != 0.0) {
                hashMap.put(g, NumberUtil.formatNumber(ticket.getTaxAmount(), true));
            }
            if (ticket.getServiceCharge() > 0.0) {
                hashMap.put(e, NumberUtil.formatNumber(ticket.getServiceCharge()));
            }
            if (ticket.getDeliveryCharge() > 0.0) {
                hashMap.put(f, NumberUtil.formatNumber(ticket.getDeliveryCharge()));
            }
            if (ticket.getGratuity() != null) {
                d2 = ticket.getGratuity().getAmount();
                hashMap.put(d, NumberUtil.formatNumber(d2));
            }
            hashMap.put("totalText", POSConstants.SUBTOTAL + string7);
            hashMap.put("discountText", POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + string7);
            hashMap.put("taxText", POSConstants.RECEIPT_REPORT_TAX_LABEL + string7);
            hashMap.put("serviceChargeText", POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + string7);
            hashMap.put("deliveryChargeText", POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL + string7);
            hashMap.put("tipsText", POSConstants.RECEIPT_REPORT_TIPS_LABEL + string7);
            hashMap.put("netAmountText", POSConstants.RECEIPT_REPORT_TOTAL_LABEL + string7);
            hashMap.put("paidAmountText", POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + string7);
            hashMap.put("dueAmountText", POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + string7);
            hashMap.put("changeAmountText", POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + string7);
            hashMap.put("feeAmountText", POSConstants.FEE_AMOUNT + string7);
            if (ticket.getFeeAmount() > 0.0) {
                hashMap.put("feeAmount", NumberUtil.formatNumber(ticket.getFeeAmount()));
            }
            hashMap.put("netAmount", NumberUtil.formatNumber(d, true));
            hashMap.put("paidAmount", NumberUtil.formatNumber(ticket.getPaidAmount()));
            serializable2 = ticket.getRefundAmount();
            if (posTransaction != null) {
                object = posTransaction.getTenderAmount();
                hashMap.put("tenderAmountText", POSConstants.RECEIPT_TENDERED_AMOUNT_LABEL + string7);
                hashMap.put("tenderAmount", NumberUtil.formatNumber((Double)object, true));
            }
            if ((Double)serializable2 > 0.0) {
                hashMap.put("refundAmountText", Messages.getString("ReceiptPrintService.40") + string7);
                hashMap.put("refundAmount", NumberUtil.formatNumber((Double)serializable2));
            }
            hashMap.put("dueAmount", NumberUtil.formatNumber(ticket.getDueAmount() - ticket.getGratuityAmount()));
            hashMap.put("grandSubtotal", NumberUtil.formatNumber(ticket.getSubtotalAmount(), true));
            hashMap.put("footerMessage", ReceiptPrintService.a(hashMap, string2));
            hashMap.put("bottomMessage", ReceiptPrintService.a(hashMap, string3));
            hashMap.put("copyType", ticketPrintProperties.getReceiptCopyType());
            if (ticket.isRefunded().booleanValue()) {
                ReceiptPrintService.a(posTransaction, ticket.getTransactions(), hashMap);
            }
            if (StringUtils.isEmpty((String)string8) || posTransaction != null || !ticket.isClosed().booleanValue()) {
                // empty if block
            }
            if (posTransaction != null) {
                double d3 = posTransaction.getTenderAmount() - posTransaction.getAmount();
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                hashMap.put("changedAmount", NumberUtil.formatNumber(d3));
                if (posTransaction.isCard()) {
                    if (!orderType.isRetailOrder().booleanValue()) {
                        hashMap.put("cardPayment", true);
                    }
                    if (StringUtils.isEmpty((String)(charSequence = CardConfig.getPaymentGateway().getProcessor().getCardInformationForReceipt(posTransaction)))) {
                        charSequence = ReceiptPrintService.a(posTransaction);
                    }
                    hashMap.put("approvalCode", charSequence);
                }
                if (posTransaction instanceof CustomerAccountTransaction && !orderType.isRetailOrder().booleanValue()) {
                    hashMap.put("cardPayment", true);
                }
            }
            object = null;
            if (StringUtils.isEmpty((String)string8)) {
                object = ReceiptPrintService.d(ticket);
            }
            if (object != null) {
                hashMap.put("additionalPaymentProperties", ((StringBuilder)object).toString());
            }
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
                serializable = ReceiptPrintService.b(ticket, ticketPrintProperties);
                if (serializable != null) {
                    hashMap.put("additionalProperties", ((StringBuilder)serializable).toString());
                } else {
                    charSequence = ReceiptPrintService.a(ticket, ticketPrintProperties);
                    if (charSequence != null && string8 == null) {
                        hashMap.put("additionalProperties", charSequence.toString());
                    }
                }
            }
        }
        if (bl3 && (serializable2 = store.getStoreLogo()) != null) {
            try {
                object = ReceiptPrintService.a(((ImageIcon)serializable2).getImage());
                serializable = null;
                try {
                    hashMap.put("storeLogoIcon", object);
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (serializable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            }
        }
        boolean bl4 = bl2 = store.getProperty(string6 + "." + "receipt.show_tips_suggestion") == null ? false : Boolean.valueOf(store.getProperty(string6 + "." + "receipt.show_tips_suggestion"));
        if (bl2) {
            hashMap.put("showTips", ReceiptPrintService.c(ticket));
        }
        boolean bl5 = store.getProperty(string6 + "." + "receipt.show_tips_block") == null ? false : Boolean.valueOf(store.getProperty(string6 + "." + "receipt.show_tips_block"));
        hashMap.put("showTipsBlock", bl5);
        boolean bl6 = store.getProperty(string6 + "." + "receipt.show_tax_breakdown") == null ? false : Boolean.valueOf(store.getProperty(string6 + "." + "receipt.show_tax_breakdown"));
        hashMap.put("isShowTaxBreakdown", bl6);
        if (bl6 && (charSequence = ReceiptPrintService.getTaxBreakdown(ticket)) != null) {
            hashMap.put("taxBreakdownText", charSequence.toString());
        }
        return hashMap;
    }

    private static InputStream a(Image image) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private static void a(HashMap hashMap, String string) {
        if (string != null && string.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            hashMap.put("IS_IGNORE_PAGINATION", false);
        }
    }

    private static void a(HashMap hashMap, String string, boolean bl) {
        if (string != null && string.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            hashMap.put("IS_IGNORE_PAGINATION", bl);
        }
    }

    private static String a(Map map, String string) {
        ReceiptParam[] receiptParamArray;
        if (string == null) {
            return "";
        }
        for (ReceiptParam receiptParam : receiptParamArray = ReceiptParam.values()) {
            String string2;
            String string3 = receiptParam.getParamName();
            Object v = map.get(string3);
            if (v == null || StringUtils.isEmpty((String)v.toString()) || v.toString().equals("[]")) {
                string2 = "<" + receiptParam.getParamName() + ">.*</" + receiptParam.getParamName() + ">";
                string = string.replaceAll("<br>" + string2, "");
                string = string.replaceAll(string2, "");
                continue;
            }
            string2 = v.toString();
            try {
                string = string.replaceAll("\\$" + string3, string2);
            }
            catch (Exception exception) {
                string = string.replaceAll("\\$" + string3, "\\" + string2);
            }
        }
        String string4 = ReceiptPrintService.a(string);
        return string4;
    }

    private static String a(String string) {
        Pattern pattern = Pattern.compile("\\{\\{(\\d+)\\}\\}");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                int n = Integer.parseInt(string2);
                String string3 = "";
                for (int i = 0; i < n; ++i) {
                    string3 = string3 + "&nbsp;";
                }
                matcher.appendReplacement(stringBuffer, string3);
            }
            catch (Exception exception) {}
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static void a(PosTransaction posTransaction, Set<PosTransaction> set, HashMap hashMap) {
        if (set == null) {
            return;
        }
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        double d = 0.0;
        for (PosTransaction posTransaction2 : set) {
            if (!(posTransaction2 instanceof RefundTransaction) && !posTransaction2.isVoided().booleanValue()) continue;
            d += posTransaction2.getAmount().doubleValue();
        }
        Object object = "";
        object = posTransaction != null ? "<br>" + (Object)((Object)posTransaction.getPaymentType()) + Messages.getString("ReceiptPrintService.66") + CurrencyUtil.getCurrencySymbol() + "&nbsp;" + posTransaction.getAmount() : "<br>" + Messages.getString("ReceiptPrintService.68") + CurrencyUtil.getCurrencySymbol() + "&nbsp;" + NumberUtil.formatNumber(d);
        hashMap.put("additionalProperties", "<html><b>" + (String)object + "</b></html>");
    }

    public static HashMap populatePurchaseOrderProperties(PurchaseOrder purchaseOrder, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction) {
        Object object;
        String string;
        CharSequence charSequence;
        Store store = StoreDAO.getRestaurant();
        double d = purchaseOrder.getTotalAmount();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReceiptPrintService.a(hashMap, DataProvider.get().getPrinters().getReceiptPrinter());
        String string2 = CurrencyUtil.getCurrencySymbol();
        ImageIcon imageIcon = IconFactory.getIcon("/icons/", "header_logo.png");
        if (imageIcon != null) {
            hashMap.put("logo", imageIcon.getImage());
        }
        hashMap.put("currencySymbol", string2);
        hashMap.put("nameText", "Vendor: ");
        hashMap.put("addressText", "Address: ");
        hashMap.put("slNoText", "Sl. No.");
        hashMap.put(q, "Description");
        hashMap.put(p, "Quantity");
        hashMap.put("priceText", "Unit Cost (" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("unitText", "Unit");
        hashMap.put(o, "Amount (" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("note", Messages.getString("ReceiptPrintService.75"));
        hashMap.put("shipDateTxt", Messages.getString("ReceiptPrintService.76"));
        String string3 = purchaseOrder.getShipDate() != null ? DateUtil.formatFullDateAndTimeAsString(purchaseOrder.getShipDate()) : null;
        hashMap.put("shipDate", string3);
        hashMap.put("signature1", "Signature");
        hashMap.put("signature2", "Verified By");
        InventoryVendor inventoryVendor = purchaseOrder.getVendor();
        if (inventoryVendor != null) {
            charSequence = inventoryVendor.getName();
            string = inventoryVendor.getAddress();
            object = inventoryVendor.getPhone();
            hashMap.put("customerName", charSequence);
            String string4 = "";
            if (string != null && !string.isEmpty()) {
                string4 = string4 + string;
            }
            if (object != null && !((String)object).isEmpty()) {
                string4 = string4 + ", Cell:" + (String)object;
            }
            hashMap.put("customerAddress", StringUtils.isNotEmpty((String)string4) ? string4 : null);
        }
        hashMap.put(n, ticketPrintProperties.getReceiptTypeName());
        hashMap.put(m, ticketPrintProperties.isShowSubtotal());
        hashMap.put(l, Boolean.TRUE);
        hashMap.put(k, ticketPrintProperties.isShowFooter());
        hashMap.put(j, POSConstants.RECEIPT_REPORT_DATE_LABEL + DateUtil.formatFullDateAndTimeAsString(new Date()));
        charSequence = ReceiptPrintService.a(purchaseOrder, ticketPrintProperties);
        hashMap.put("ticketHeader2", ((StringBuilder)charSequence).toString());
        hashMap.put("ticketHeader3", "Purchase Order");
        string = purchaseOrder.getInvoiceNumber() != null ? Messages.getString("ReceiptPrintService.77") + purchaseOrder.getInvoiceNumber() : null;
        hashMap.put("invoiceNumber", string);
        hashMap.put(i, store.getName());
        hashMap.put("headerLine9", store.getTelephone());
        object = store.getAddress();
        if (object != null) {
            hashMap.put("headerLine2", ((BaseAddress)object).getAddressLine());
            hashMap.put("headerLine3", ((BaseAddress)object).getAddressLine2());
            hashMap.put("headerLine4", ((BaseAddress)object).getStreet());
            hashMap.put("headerLine5", ((BaseAddress)object).getCity());
            hashMap.put("headerLine6", ((BaseAddress)object).getState());
            hashMap.put("headerLine7", ((BaseAddress)object).getZipCode());
            hashMap.put("headerLine8", ((BaseAddress)object).getCountry());
        } else {
            hashMap.put("headerLine2", store.getAddressLine1());
            hashMap.put("headerLine3", store.getAddressLine2());
            hashMap.put("headerLine4", store.getAddressLine3());
            hashMap.put("headerLine6", store.getZipCode());
        }
        if (ticketPrintProperties.isShowFooter()) {
            if (purchaseOrder.getDiscountAmount() > 0.0) {
                hashMap.put(h, NumberUtil.formatNumber(purchaseOrder.getDiscountAmount()));
            }
            if (purchaseOrder.getTaxAmount() > 0.0) {
                hashMap.put(g, NumberUtil.formatNumber(purchaseOrder.getTaxAmount()));
            }
            hashMap.put("totalText", POSConstants.RECEIPT_REPORT_TOTAL_LABEL + string2);
            hashMap.put("discountText", POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + string2);
            hashMap.put("taxText", POSConstants.RECEIPT_REPORT_TAX_LABEL + string2);
            hashMap.put("serviceChargeText", POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + string2);
            hashMap.put("tipsText", POSConstants.RECEIPT_REPORT_TIPS_LABEL + string2);
            hashMap.put("netAmountText", POSConstants.RECEIPT_REPORT_NETAMOUNT_LABEL + string2);
            hashMap.put("paidAmountText", POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + string2);
            hashMap.put("dueAmountText", POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + string2);
            hashMap.put("changeAmountText", POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + string2);
            hashMap.put("netAmount", NumberUtil.formatNumber(d));
            hashMap.put("paidAmount", NumberUtil.formatNumber(purchaseOrder.getPaidAmount()));
            hashMap.put("dueAmount", NumberUtil.formatNumber(purchaseOrder.getDueAmount()));
            hashMap.put("grandSubtotal", NumberUtil.formatNumber(purchaseOrder.getSubtotalAmount()));
            hashMap.put("footerMessage", store.getTicketFooterMessage());
            hashMap.put("copyType", ticketPrintProperties.getReceiptCopyType());
            if (posTransaction != null) {
                double d2 = posTransaction.getTenderAmount() - posTransaction.getAmount();
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                hashMap.put("changedAmount", NumberUtil.formatNumber(d2));
                if (posTransaction.isCard()) {
                    hashMap.put("cardPayment", true);
                    if (StringUtils.isNotEmpty((String)posTransaction.getCardTrack())) {
                        BankCardMagneticTrack bankCardMagneticTrack = BankCardMagneticTrack.from((String)posTransaction.getCardTrack());
                        String string5 = posTransaction.getCardType();
                        string5 = string5 + "<br/>APPROVAL: " + posTransaction.getCardAuthCode();
                        try {
                            string5 = string5 + "<br/>ACCT: " + ReceiptPrintService.a(bankCardMagneticTrack);
                            string5 = string5 + "<br/>EXP: " + bankCardMagneticTrack.getTrack1().getExpirationDate();
                            string5 = string5 + "<br/>CARDHOLDER: " + bankCardMagneticTrack.getTrack1().getName();
                        }
                        catch (Exception exception) {
                            r.error((Object)exception);
                        }
                        hashMap.put("approvalCode", string5);
                    } else {
                        String string6 = "APPROVAL: " + posTransaction.getCardAuthCode();
                        string6 = string6 + "<br/>Card processed in ext. device.";
                        hashMap.put("approvalCode", string6);
                    }
                }
            }
            String string7 = "<html>";
            string7 = string7 + "</html>";
            hashMap.put("additionalProperties", string7);
        }
        return hashMap;
    }

    private static String c(Ticket ticket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        double d = ticket.getTotalAmountWithTips();
        double d2 = d * 15.0 / 100.0;
        double d3 = d * 18.0 / 100.0;
        double d4 = d * 20.0 / 100.0;
        double d5 = d * 25.0 / 100.0;
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "<br>" + Messages.getString("ReceiptPrintService.90") + NumberUtil.formatNumber(d5) + "<br>" + Messages.getString("ReceiptPrintService.88") + NumberUtil.formatNumber(d4) + "<br>" + Messages.getString("ReceiptPrintService.86") + NumberUtil.formatNumber(d3) + "<br>" + Messages.getString("ReceiptPrintService.84") + NumberUtil.formatNumber(d2));
        ReceiptPrintService.b(stringBuilder);
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static StringBuilder a(PurchaseOrder purchaseOrder, TicketPrintProperties ticketPrintProperties) {
        String string = " ";
        if (purchaseOrder.getOrderId() != null) {
            string = purchaseOrder.getOrderId();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        InventoryLocation inventoryLocation = purchaseOrder.getInventoryLocation();
        String string2 = "";
        String string3 = "";
        if (inventoryLocation != null) {
            string2 = inventoryLocation.getName();
            string3 = inventoryLocation.getAddress();
        }
        if (purchaseOrder.getVarificationDate() != null) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Date: " + DateUtil.formatFullDateAndTimeAsString(purchaseOrder.getVarificationDate()));
            ReceiptPrintService.b(stringBuilder);
        }
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "Purchase Order #" + string);
        ReceiptPrintService.b(stringBuilder);
        if (StringUtils.isNotEmpty((String)string2)) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Inventory Location: " + string2);
            ReceiptPrintService.b(stringBuilder);
        }
        if (StringUtils.isNotEmpty((String)string3)) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Inventory Location Address: " + string3);
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</html>");
        return stringBuilder;
    }

    public static StringBuilder getTaxBreakdown(Ticket ticket) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        List<TicketItem> list = ticket.getTicketItems();
        ArrayList<TicketItemTax> arrayList = new ArrayList<TicketItemTax>();
        for (TicketItem object : list) {
            for (TicketItemTax ticketItemTax : object.getTaxes()) {
                string = ticketItemTax.getName();
                Double d = (Double)hashMap.get(string);
                if (d == null) {
                    d = 0.0;
                }
                d = d + ticketItemTax.getTaxAmount();
                hashMap.put(string, d);
                arrayList.add(ticketItemTax);
            }
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        String string2 = CurrencyUtil.getCurrencySymbol();
        for (Map.Entry entry : hashMap.entrySet()) {
            String string3 = NumberUtil.formatNumber((Double)entry.getValue());
            string = (String)entry.getKey();
            int n = 24;
            int n2 = (int)(Math.log10((Double)entry.getValue()) + 1.0);
            n = n2 > 2 ? ++n : (n2 > 1 ? (n += 2) : (n += 3));
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string + (String)string2, n, RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string3, n, RIGHT));
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    private static StringBuilder a(Ticket ticket, TicketPrintProperties ticketPrintProperties) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        String string = "------------------------------------";
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "<b>Currency breakdown</b>");
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("", 10, CENTER));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Net Amount", 10, CENTER));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Due", 10, CENTER));
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        int n = 0;
        List<Currency> list = CurrencyUtil.getAllCurrency();
        if (list != null) {
            for (Currency currency : list) {
                if (currency == null) continue;
                String string2 = currency.getName();
                double d = currency.getExchangeRate();
                ReceiptPrintService.a(stringBuilder);
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string2, 10, LEFT));
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(ticket.getTotalAmountWithTips() * d), 10, RIGHT));
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(ticket.getDueAmount() * d), 10, RIGHT));
                ReceiptPrintService.b(stringBuilder);
                ++n;
            }
        }
        if (n == 0) {
            return null;
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    private static StringBuilder b(Ticket ticket, TicketPrintProperties ticketPrintProperties) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        String string = "------------------------------------";
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.b(stringBuilder);
        String string2 = ticket.getProperty("GROUP_SETTLE_TICKETS");
        if (string2 == null) {
            string2 = "";
        }
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string2 + "<b>Currency breakdown</b>");
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("", 10, CENTER));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Paid", 10, CENTER));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Cashback", 10, CENTER));
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        int n = 0;
        for (Currency currency : CurrencyUtil.getAllCurrency()) {
            if (currency == null) continue;
            String string3 = currency.getName();
            String string4 = ticket.getProperty(string3);
            String string5 = ticket.getProperty(string3 + "_CASH_BACK");
            if (string4 == null) {
                string4 = "0";
            }
            if (string5 == null) {
                string5 = "0";
            }
            Double d = Double.valueOf(string4);
            Double d2 = Double.valueOf(string5);
            if (d == 0.0 && d2 == 0.0) continue;
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string3, 10, LEFT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(d), 10, RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(d2), 10, RIGHT));
            ReceiptPrintService.b(stringBuilder);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    private static StringBuilder d(Ticket ticket) {
        Set<PosTransaction> set = ticket.getTransactions();
        if (set == null || set.size() <= 1) {
            return null;
        }
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(set);
        Collections.sort(arrayList, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                return posTransaction.getTransactionTime().compareTo(posTransaction2.getTransactionTime());
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.a(stringBuilder, "&nbsp;");
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "Settlements:");
        ReceiptPrintService.b(stringBuilder);
        String string = "";
        String string2 = "";
        for (PosTransaction posTransaction : arrayList) {
            ReceiptPrintService.a(stringBuilder);
            string = posTransaction.isVoided() != false ? "<strike>" : "";
            string2 = posTransaction.isVoided() != false ? "</strike>" : "";
            ReceiptPrintService.a(stringBuilder, string + ReceiptPrintService.getHtmlText(posTransaction.getPaymentType().getDisplayString(), 10, LEFT) + string2);
            ReceiptPrintService.a(stringBuilder, string + ReceiptPrintService.getHtmlText(posTransaction.getTipsAmount() > 0.0 ? NumberUtil.formatNumber(posTransaction.getTipsAmount()) : "", 10, RIGHT) + string2);
            Double d = posTransaction.getAmount();
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string + NumberUtil.formatNumberAcceptNegative(posTransaction instanceof RefundTransaction ? -d.doubleValue() : d), 10, RIGHT) + string2);
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    public static String getHtmlText(String string, int n, String string2) {
        block5: {
            block6: {
                block4: {
                    if (string.length() > 30) {
                        string = string.substring(0, 30);
                    }
                    if (!string2.equals(CENTER)) break block4;
                    int n2 = (n - string.length()) / 2;
                    for (int i = 1; i < n2; ++i) {
                        string = "&nbsp;" + string + "&nbsp;";
                    }
                    break block5;
                }
                if (!string2.equals(RIGHT)) break block6;
                int n3 = n - string.length();
                for (int i = 1; i < n3; ++i) {
                    string = "&nbsp;" + string;
                }
                break block5;
            }
            if (!string2.equals(LEFT)) break block5;
            int n4 = n - string.length();
            for (int i = 1; i < n4; ++i) {
                string = string + "&nbsp;";
            }
        }
        return string;
    }

    public static JasperPrint createKitchenPrint(KitchenTicket kitchenTicket) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("cardPayment", true);
        hashMap.put(l, Boolean.TRUE);
        hashMap.put(l, Boolean.TRUE);
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        ReciptPaperSize reciptPaperSize = ReceiptPrintService.b("kitchen.recipt.paper_size");
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("kitchen-receipt")), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
    }

    public static JasperPrint createKitchenPrint(String string, KitchenTicket kitchenTicket, String string2) throws Exception {
        return ReceiptPrintService.createKitchenPrint(string, kitchenTicket, string2, false);
    }

    public static JasperPrint createKitchenPrint(String string, KitchenTicket kitchenTicket, String string2, boolean bl) throws Exception {
        OrderType orderType;
        String string3;
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(kitchenTicket.getParentTicket(), ticketPrintProperties, null, true);
        ReceiptPrintService.a(hashMap, string2, bl);
        if (ReceiptPrintService.a(kitchenTicket)) {
            hashMap.put(i, "**");
        }
        if (StringUtils.isNotEmpty((String)(string3 = kitchenTicket.getOrderType().toString()))) {
            string3 = string3.replaceAll("_", " ");
        }
        if ((orderType = kitchenTicket.getOrderType()).isDelivery().booleanValue() || orderType.isPickup().booleanValue()) {
            if (kitchenTicket.getParentTicket().isCustomerWillPickup().booleanValue()) {
                hashMap.put("orderType", "*" + Messages.getString("PICKUP") + "*");
            } else {
                hashMap.put("orderType", "*" + Messages.getString("DELIVERY") + "*");
            }
        } else {
            hashMap.put("orderType", "* " + string3 + " *");
        }
        hashMap.put(PROP_PRINTER_NAME, "Printer Name : " + string);
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        String string4 = "kitchen-receipt";
        ReciptPaperSize reciptPaperSize = ReceiptPrintService.b("kitchen.recipt.paper_size");
        if (Application.getInstance().getTerminal().isGroupByCatagoryKitReceipt().booleanValue()) {
            string4 = "kitchen-receipt-with-group";
        }
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size(string4)), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
    }

    private static boolean a(KitchenTicket kitchenTicket) {
        for (KitchenTicketItem kitchenTicketItem : kitchenTicket.getTicketItems()) {
            if (kitchenTicketItem.isVoided().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static JasperPrint createKitchenVoidPrint(String string, KitchenTicket kitchenTicket, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(i, Application.getInstance().getStore().getName());
        hashMap.put("cardPayment", true);
        hashMap.put(l, Boolean.TRUE);
        hashMap.put(l, Boolean.TRUE);
        hashMap.put(ReceiptParam.TICKET_ID.getParamName(), POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + kitchenTicket.getTicketId());
        if (kitchenTicket.getTableNumbers() != null && kitchenTicket.getTableNumbers().size() > 0) {
            hashMap.put(ReceiptParam.TABLE_NO.getParamName(), POSConstants.RECEIPT_REPORT_TABLE_NO_LABEL + kitchenTicket.getTableNumbers());
        }
        if (StringUtils.isNotEmpty((String)kitchenTicket.getCustomerName())) {
            hashMap.put("customer", Messages.getString("ReceiptPrintService.0") + kitchenTicket.getCustomerName());
        }
        hashMap.put(ReceiptParam.SERVER_NAME.getParamName(), POSConstants.RECEIPT_REPORT_SERVER_LABEL + kitchenTicket.getServerName());
        hashMap.put(j, Messages.getString("ReceiptPrintService.119") + DateUtil.getReportDate());
        hashMap.put("ticketHeader", Messages.getString("ReceiptPrintService.12"));
        String string3 = kitchenTicket.getOrderType().toString();
        if (StringUtils.isNotEmpty((String)string3)) {
            string3 = string3.replaceAll("_", " ");
        }
        hashMap.put("orderType", "** VOID **");
        hashMap.put(PROP_PRINTER_NAME, Messages.getString("ReceiptPrintService.14") + string);
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        String string4 = "kitchen-receipt";
        return ReceiptPrintService.createJasperPrint(ReportUtil.getReport(string4), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
    }

    public static void printToKitchen(Ticket ticket) {
        ReceiptPrintService.printToKitchen(ticket, true);
    }

    public static void printToKitchen(Ticket ticket, boolean bl) {
        ReceiptPrintService.printToKitchen(ticket, bl, true);
    }

    public static void printToKitchen(Ticket ticket, boolean bl, boolean bl2) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, bl);
            ReceiptPrintService.a(ticket, list, bl2);
            if (PosWebService.get().isCloudConfigured()) {
                String string = ServiceUtils.convertKitTicketsToJsonString(list);
                PosLog.debug(ReceiptPrintService.class, string);
                OroMqttClient.getInstance().publishData("public", string, true);
            }
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND-KIT-DIS-UPDATE", "3");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static void printItemsToKitchen(Ticket ticket, List<TicketItem> list) {
        try {
            if (ticket == null && list == null) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, true, list);
            ReceiptPrintService.a(ticket, list2, true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private static void a(Ticket ticket, List<KitchenTicket> list, boolean bl) throws Exception {
        for (KitchenTicket kitchenTicket : list) {
            kitchenTicket.setParentTicket(ticket);
            Printer printer = kitchenTicket.getPrinter();
            String string = printer.getDeviceName();
            if (printer.getVirtualPrinter().getType() == 2 && string != null) {
                r.info((Object)("Printing to kitchen using printer: " + string));
                JasperPrint jasperPrint = ReceiptPrintService.createKitchenPrint(printer.getVirtualPrinter().getName(), kitchenTicket, string);
                jasperPrint.setName("KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, string);
                ReceiptPrintService.printQuitely(jasperPrint);
                continue;
            }
            if (printer.getVirtualPrinter().getType() == 6 && string != null) {
                r.info((Object)("Printing to sticker using printer: " + string));
                ReceiptPrintService.a(kitchenTicket, string);
                continue;
            }
            if (printer.getVirtualPrinter().getType() != 4) continue;
            TicketDAO.getInstance().saveKitchenPrintStatus(ticket, kitchenTicket);
        }
        if (bl) {
            ticket.clearDeletedItems();
            TicketDAO.getInstance().saveOrUpdate(ticket);
        }
    }

    public static void doPrintKitchenStickers(Ticket ticket) {
        try {
            List<Printer> list = DataProvider.get().getPrinters().getStickerPrinters();
            if (list.isEmpty()) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, true);
            for (KitchenTicket kitchenTicket : list2) {
                Printer printer = kitchenTicket.getPrinter();
                String string = printer.getDeviceName();
                kitchenTicket.setParentTicket(ticket);
                if (printer.getVirtualPrinter().getType() != 6 || string == null) continue;
                ReceiptPrintService.a(kitchenTicket, string);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private static void a(KitchenTicket kitchenTicket, String string) {
        try {
            List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
            ArrayList<KitchenStickerModel.KitchenSticker> arrayList = new ArrayList<KitchenStickerModel.KitchenSticker>();
            int n = 0;
            int n2 = ReceiptPrintService.a(list);
            for (KitchenTicketItem kitchenTicketItem : list) {
                if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
                int n3 = 0;
                while ((double)n3 < kitchenTicketItem.getQuantity()) {
                    KitchenStickerModel.KitchenSticker kitchenSticker = new KitchenStickerModel.KitchenSticker();
                    kitchenSticker.setToken(kitchenTicket.getTokenNo());
                    String string2 = kitchenTicketItem.getMenuItemName();
                    if (StringUtils.isNotEmpty((String)string2)) {
                        string2 = kitchenTicketItem.getQuantity() > 1.0 ? string2.substring(string2.indexOf(32) + 1) : string2;
                    }
                    kitchenSticker.setItemName(string2);
                    kitchenSticker.setModifiers(kitchenTicket.getModifiersForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setCookingInstructions(kitchenTicket.getCookingInstructionForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setTime(Messages.getString("ReceiptPrintService.102") + DateUtil.formatDateWithTime(new Date()));
                    if (kitchenTicket.getOrderType() != null) {
                        kitchenSticker.setOrderType(kitchenTicket.getOrderType().getName());
                    }
                    kitchenSticker.setItemCount(Messages.getString("ReceiptPrintService.103") + (n + 1) + Messages.getString("ReceiptPrintService.104") + n2);
                    arrayList.add(kitchenSticker);
                    ++n;
                    ++n3;
                }
            }
            JasperPrint jasperPrint = ReceiptPrintService.printKitchenStickerItems(arrayList);
            jasperPrint.setName("Kitchen_Sticker_" + kitchenTicket.getTokenNo());
            jasperPrint.setProperty(PROP_PRINTER_NAME, string);
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception.getMessage(), exception);
        }
    }

    private static int a(List<KitchenTicketItem> list) {
        int n = 0;
        for (KitchenTicketItem kitchenTicketItem : list) {
            if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
            n = (int)((double)n + kitchenTicketItem.getQuantity());
        }
        return n;
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean bl) {
        return ReceiptPrintService.getKitchenJasperPrint(ticket, bl, false);
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean bl, boolean bl2) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, bl);
            for (KitchenTicket kitchenTicket : list) {
                kitchenTicket.setParentTicket(ticket);
                Printer printer = kitchenTicket.getPrinter();
                String string = printer.getDeviceName();
                if (string == null) continue;
                JasperPrint jasperPrint = ReceiptPrintService.createKitchenPrint(printer.getVirtualPrinter().getName(), kitchenTicket, string, bl2);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, string);
                return jasperPrint;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        return null;
    }

    public static void printVoidItemsToKitchen(Ticket ticket) {
        try {
            JasperPrint jasperPrint;
            Serializable serializable;
            Object object;
            Comparable comparable22;
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Comparable comparable22 : ticket.getTicketItems()) {
                VoidItem voidItem = comparable22.getVoidItem();
                if (voidItem == null) continue;
                if (voidItem.getVoidedModifiers() != null) {
                    arrayList.addAll(voidItem.getVoidedModifiers());
                }
                arrayList.add(voidItem);
            }
            HashMap hashMap = new HashMap();
            comparable22 = StoreDAO.getServerTimestamp();
            for (VoidItem comparable3 : arrayList) {
                if (comparable3.isCooked() || (object = ReceiptPrintService.getPrinters((PrinterGroup)(serializable = comparable3.getPrinterGroup()))) == null) continue;
                jasperPrint = object.iterator();
                while (jasperPrint.hasNext()) {
                    Printer printer = jasperPrint.next();
                    KitchenTicket kitchenTicket = (KitchenTicket)hashMap.get(printer);
                    if (kitchenTicket == null) {
                        kitchenTicket = new KitchenTicket();
                        kitchenTicket.setPrinterGroup((PrinterGroup)serializable);
                        kitchenTicket.setTicketId(ticket.getId());
                        kitchenTicket.setTokenNo(ticket.getTokenNo());
                        kitchenTicket.setCreateDate((Date)comparable22);
                        kitchenTicket.setOrderType(ticket.getOrderType());
                        if (ticket.getTableNumbers() != null) {
                            kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                        }
                        kitchenTicket.setServerName(ticket.getOwner().getFirstName());
                        kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                        if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                            kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                        }
                        kitchenTicket.setPrinter(printer);
                        hashMap.put(printer, kitchenTicket);
                    }
                    KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
                    kitchenTicketItem.setTicketItemId(comparable3.getId());
                    kitchenTicketItem.setMenuItemCode(String.valueOf(comparable3.getMenuItemId()));
                    kitchenTicketItem.setMenuItemName(comparable3.getMenuItemName());
                    kitchenTicketItem.setQuantity(comparable3.getQuantity());
                    kitchenTicketItem.setUnitName("");
                    kitchenTicketItem.setMenuItemGroupName("VOID");
                    kitchenTicketItem.setSortOrder(10001);
                    kitchenTicketItem.setStatus(KitchenStatus.VOID.name());
                    kitchenTicketItem.setKitchenTicket(kitchenTicket);
                    kitchenTicket.addToticketItems(kitchenTicketItem);
                }
            }
            for (KitchenTicket kitchenTicket : hashMap.values()) {
                serializable = kitchenTicket.getPrinter();
                object = ((Printer)serializable).getDeviceName();
                jasperPrint = ReceiptPrintService.createKitchenVoidPrint(((Printer)serializable).getVirtualPrinter().getName(), kitchenTicket, (String)object);
                jasperPrint.setName("Void_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, (String)object);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static List<Printer> getPrinters(PrinterGroup printerGroup) {
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        if (printerGroup == null) {
            printerGroup = PrinterGroupDAO.getInstance().getDefaultPrinterGroup();
        }
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        if (printerGroup == null) {
            arrayList.addAll(posPrinters.getKitchenPrinters());
            return arrayList;
        }
        List<String> list = printerGroup.getPrinterNames();
        List<Printer> list2 = posPrinters.getKitchenPrinters();
        for (Printer printer : list2) {
            if (!list.contains(printer.getVirtualPrinter().getName())) continue;
            arrayList.add(printer);
        }
        if (arrayList.isEmpty() && PrintServiceUtil.getFallBackPrinter() != null) {
            arrayList.add(PrintServiceUtil.getFallBackPrinter());
        }
        return arrayList;
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        block4: {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date date = new Date();
                String string = simpleDateFormat.format(date);
                String string2 = jasperPrint.getProperty(PROP_PRINTER_NAME);
                if (string2 != null && string2.equals(OROPOS_PDF_PRINTER)) {
                    String string3 = jasperPrint.getName().replace(string2, "") + "-[" + string + "]";
                    File file = new File(s, string3 + ".pdf");
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)file.getAbsolutePath());
                } else {
                    SimplePrintServiceExporterConfiguration simplePrintServiceExporterConfiguration = new SimplePrintServiceExporterConfiguration();
                    simplePrintServiceExporterConfiguration.setPrintService(PrintServiceUtil.getPrintServiceForPrinter(jasperPrint.getProperty(PROP_PRINTER_NAME)));
                    JRPrintServiceExporter jRPrintServiceExporter = new JRPrintServiceExporter();
                    jRPrintServiceExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    jRPrintServiceExporter.setConfiguration((ExporterConfiguration)simplePrintServiceExporterConfiguration);
                    jRPrintServiceExporter.exportReport();
                }
            }
            catch (Exception exception) {
                if (exception != null && exception.getCause() instanceof PrinterAbortException) break block4;
                String string = "No print selected\n";
                r.error((Object)(string + exception));
            }
        }
    }

    private static String a(BankCardMagneticTrack bankCardMagneticTrack) {
        String string = "";
        try {
            if (bankCardMagneticTrack.getTrack1().hasPrimaryAccountNumber()) {
                string = bankCardMagneticTrack.getTrack1().getPrimaryAccountNumber().getAccountNumber();
                string = "************" + string.substring(12);
            } else if (bankCardMagneticTrack.getTrack2().hasPrimaryAccountNumber()) {
                string = bankCardMagneticTrack.getTrack2().getPrimaryAccountNumber().getAccountNumber();
                string = "************" + string.substring(12);
            }
        }
        catch (Exception exception) {
            r.error((Object)exception);
        }
        return string;
    }

    private static String a(PosTransaction posTransaction) {
        String string = "<br/>" + Messages.getString("ReceiptPrintService.15") + " ------------------------";
        string = string + "<br/>" + Messages.getString("ReceiptPrintService.17") + posTransaction.getCardReader();
        string = string + "<br/>" + Messages.getString("ReceiptPrintService.20") + posTransaction.getCardType();
        try {
            String string2 = posTransaction.getCardNumber();
            if (posTransaction.getCardNumber() != null) {
                string = string + "<br/> " + Messages.getString("ReceiptPrintService.21") + " **** **** **** " + string2.substring(string2.length() - 4, string2.length());
            }
            if (posTransaction.getCardHolderName() != null) {
                string = string + "<br/> " + Messages.getString("ReceiptPrintService.23") + posTransaction.getCardHolderName();
            }
            if (posTransaction.getCardTransactionId() != null) {
                string = string + "<br/> " + Messages.getString("ReceiptPrintService.24") + posTransaction.getCardTransactionId();
            }
            string = string + "<br/>" + Messages.getString("ReceiptPrintService.29") + posTransaction.getCardAuthCode();
        }
        catch (Exception exception) {
            r.error((Object)exception);
        }
        return string;
    }

    public static void printCloudTicket(Ticket ticket, Terminal terminal, PosTransaction posTransaction) {
        try {
            Printer printer;
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            List<TerminalPrinters> list = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            for (TerminalPrinters serializable : list) {
                int n = serializable.getVirtualPrinter().getType();
                if (n != 1) continue;
                printer = new Printer(serializable.getVirtualPrinter(), serializable.getPrinterName());
                arrayList.add(printer);
            }
            if (arrayList == null || arrayList.isEmpty()) {
                JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, null);
                jasperPrint.setName(c + ticket.getId());
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                ReceiptPrintService.printQuitely(jasperPrint);
            } else {
                for (Printer printer2 : arrayList) {
                    String string = printer2.getDeviceName();
                    if (string == null) continue;
                    printer = ReceiptPrintService.createPrint(ticket, hashMap, null);
                    printer.setName(c + ticket.getId() + string);
                    printer.setProperty(PROP_PRINTER_NAME, string);
                    ReceiptPrintService.printQuitely((JasperPrint)printer);
                }
            }
        }
        catch (Exception exception) {
            r.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    private static ReciptPaperSize b(String string) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string2 = terminal.getProperty(string);
        ReciptPaperSize reciptPaperSize = ReciptPaperSize.Eighty;
        try {
            if (StringUtils.isNotEmpty((String)string2)) {
                reciptPaperSize = ReciptPaperSize.valueOf(string2);
            }
        }
        catch (Exception exception) {
            reciptPaperSize = ReciptPaperSize.Eighty;
        }
        return reciptPaperSize;
    }

    public static boolean hasNoReceiptPrinters() {
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        boolean bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        return (list == null || list.isEmpty() || list.size() == 0) && !bl;
    }

    private static void e(final Ticket ticket) {
        AsyncAction.execute(new Runnable(){

            @Override
            public void run() {
                int n = 0;
                try {
                    n = Integer.parseInt(ticket.getProperty("printCount"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ticket.addProperty("printCount", String.valueOf(++n));
                TicketDAO.getInstance().saveOrUpdate(ticket);
            }
        });
    }

    static {
        String string = System.getProperty("user.home");
        s = new File(string, "oropos-pdf-print");
        if (!s.exists()) {
            s.mkdirs();
        }
    }
}

