/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GiftCardTransactionsReportModel
extends ListTableModel {
    private String[] a = new String[]{"txNumber", "ticketNo", "txTime", "desc", "txAmount"};

    public GiftCardTransactionsReportModel(List list) {
        this.setColumnNames(this.a);
        this.setRows(list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
        switch (n2) {
            case 0: {
                return posTransaction.getId();
            }
            case 1: {
                if (StringUtils.isNotEmpty((String)posTransaction.getTicketId())) {
                    return posTransaction.getTicketId();
                }
                return "";
            }
            case 2: {
                if (posTransaction.getTransactionTime() != null) {
                    return DateUtil.formatReportDateAsString(posTransaction.getTransactionTime());
                }
                return "";
            }
            case 3: {
                if (posTransaction instanceof GiftCertificateTransaction) {
                    return Messages.getString("GiftCardTransactionsReportModel.2");
                }
                if (posTransaction instanceof CashTransaction) {
                    return Messages.getString("GiftCardTransactionsReportModel.3");
                }
                return "";
            }
            case 4: {
                if (posTransaction instanceof GiftCertificateTransaction) {
                    return posTransaction.getAmount() * -1.0;
                }
                return posTransaction.getAmount();
            }
        }
        return null;
    }
}

