/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseCashDrawer;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.JournalReportModel;
import com.floreantpos.report.MenuUsageReport;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.report.ServerProductivityReport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ReportService {
    private static SimpleDateFormat a = new SimpleDateFormat("MMM dd yyyy, hh:mm a");
    private static SimpleDateFormat b = new SimpleDateFormat("MMM dd yyyy ");

    public static String formatFullDate(Date date) {
        return a.format(date);
    }

    public static String formatShortDate(Date date) {
        return b.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuUsageReport getMenuUsageReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        MenuUsageReport menuUsageReport = new MenuUsageReport();
        try (Session session = null;){
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(MenuCategory.class);
            List list = criteria.list();
            MenuCategory menuCategory = new MenuCategory();
            menuCategory.setName(POSConstants.MISC_BUTTON_TEXT);
            list.add(menuCategory);
            for (MenuCategory menuCategory2 : list) {
                criteria = session.createCriteria(TicketItem.class, "item");
                criteria.createCriteria("ticket", "t");
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_DISCOUNT_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_ID), (Object)menuCategory2.getId()));
                criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date));
                criteria.add((Criterion)Restrictions.le((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date2));
                criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_PAID), (Object)Boolean.TRUE));
                List list2 = criteria.list();
                if (list2.size() <= 0) continue;
                Object[] objectArray = (Object[])list2.get(0);
                MenuUsageReport.MenuUsageReportData menuUsageReportData = new MenuUsageReport.MenuUsageReportData();
                menuUsageReportData.setCategoryName(menuCategory2.getName());
                if (objectArray.length > 0 && objectArray[0] != null) {
                    menuUsageReportData.setCount(((Number)objectArray[0]).intValue());
                }
                if (objectArray.length > 1 && objectArray[1] != null) {
                    menuUsageReportData.setGrossSales(((Number)objectArray[1]).doubleValue());
                }
                if (objectArray.length > 2 && objectArray[2] != null) {
                    menuUsageReportData.setDiscount(((Number)objectArray[2]).doubleValue());
                }
                menuUsageReportData.calculate();
                menuUsageReport.addReportData(menuUsageReportData);
            }
            MenuUsageReport menuUsageReport2 = menuUsageReport;
            return menuUsageReport2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerProductivityReport getServerProductivityReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        ServerProductivityReport serverProductivityReport = new ServerProductivityReport();
        try (Session session = null;){
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(User.class);
            List list = criteria.list();
            criteria = session.createCriteria(MenuCategory.class);
            List list2 = criteria.list();
            MenuCategory menuCategory = new MenuCategory();
            menuCategory.setName(POSConstants.MISC_BUTTON_TEXT);
            list2.add(menuCategory);
            for (User user : list) {
                ServerProductivityReport.ServerProductivityReportData serverProductivityReportData = new ServerProductivityReport.ServerProductivityReportData();
                serverProductivityReportData.setServerName(user.getId() + "/" + user.toString());
                criteria = session.createCriteria(Ticket.class);
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)(user == null ? null : user.getId())));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.TRUE));
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add(Projections.rowCount());
                projectionList.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TOTAL_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                Object[] objectArray = (Object[])criteria.uniqueResult();
                int n = 0;
                double d = 0.0;
                if (objectArray != null) {
                    int n2;
                    if (objectArray.length > 0 && objectArray[0] != null) {
                        n = n2 = ((Number)objectArray[0]).intValue();
                        serverProductivityReportData.setTotalCheckCount(n);
                    }
                    if (objectArray.length > 1 && objectArray[1] != null) {
                        n2 = ((Number)objectArray[1]).intValue();
                        serverProductivityReportData.setTotalGuestCount(n2);
                    }
                    if (objectArray.length > 2 && objectArray[2] != null) {
                        d = ((Number)objectArray[2]).doubleValue();
                        serverProductivityReportData.setTotalSales(d);
                    }
                }
                serverProductivityReportData.calculate();
                serverProductivityReport.addReportData(serverProductivityReportData);
                for (MenuCategory menuCategory2 : list2) {
                    serverProductivityReportData = new ServerProductivityReport.ServerProductivityReportData();
                    serverProductivityReportData.setServerName(user.getId() + "/" + user.toString());
                    criteria = session.createCriteria(TicketItem.class, "item");
                    criteria.createCriteria(TicketItem.PROP_TICKET, "t");
                    projectionList = Projections.projectionList();
                    criteria.setProjection((Projection)projectionList);
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                    projectionList.add((Projection)Projections.sum((String)("t." + Ticket.PROP_DISCOUNT_AMOUNT)));
                    projectionList.add(Projections.rowCount());
                    criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_NAME), (Object)menuCategory2.getName()));
                    criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date));
                    criteria.add((Criterion)Restrictions.le((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date2));
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_ID), (Object)(user == null ? null : user.getId())));
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_PAID), (Object)Boolean.TRUE));
                    List list3 = criteria.list();
                    if (list3.size() <= 0) continue;
                    Object[] objectArray2 = (Object[])list3.get(0);
                    serverProductivityReportData.setCategoryName(menuCategory2.getName());
                    serverProductivityReportData.setTotalCheckCount(n);
                    if (objectArray2.length > 0 && objectArray2[0] != null) {
                        int n3 = ((Number)objectArray2[0]).intValue();
                        serverProductivityReportData.setCheckCount(n3);
                    }
                    if (objectArray2.length > 1 && objectArray2[1] != null) {
                        double d2 = ((Number)objectArray2[1]).doubleValue();
                        serverProductivityReportData.setGrossSales(d2);
                    }
                    if (objectArray2.length > 2 && objectArray2[2] != null) {
                        double d3 = ((Number)objectArray2[2]).doubleValue();
                        serverProductivityReportData.setSalesDiscount(d3);
                    }
                    if (serverProductivityReportData.getGrossSales() != 0.0 && d != 0.0) {
                        serverProductivityReportData.setAllocation(serverProductivityReportData.getGrossSales() / d * 100.0);
                    } else {
                        serverProductivityReportData.setAllocation(0.0);
                    }
                    serverProductivityReportData.calculate();
                    serverProductivityReport.addReportData(serverProductivityReportData);
                }
            }
            ServerProductivityReport serverProductivityReport2 = serverProductivityReport;
            return serverProductivityReport2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalReportModel getJournalReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        JournalReportModel journalReportModel = new JournalReportModel();
        Session session = null;
        journalReportModel.setFromDate(date);
        journalReportModel.setToDate(date2);
        journalReportModel.setReportTime(new Date());
        try {
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(ActionHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)ActionHistory.PROP_ACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)ActionHistory.PROP_ACTION_TIME, (Object)date2));
            List list = criteria.list();
            for (ActionHistory actionHistory : list) {
                JournalReportModel.JournalReportData journalReportData = new JournalReportModel.JournalReportData();
                journalReportData.setAction(actionHistory.getActionName());
                journalReportData.setUserInfo(actionHistory.getPerformer().getId() + "/" + actionHistory.getPerformer());
                journalReportData.setTime(actionHistory.getActionTime());
                journalReportData.setComments(actionHistory.getDescription());
                journalReportModel.addReportData(journalReportData);
            }
            JournalReportModel journalReportModel2 = journalReportModel;
            return journalReportModel2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesBalanceReport getSalesBalanceReport(Date date, Date date2, User user) {
        GenericDAO genericDAO = new GenericDAO();
        SalesBalanceReport salesBalanceReport = new SalesBalanceReport();
        Session session = null;
        salesBalanceReport.setFromDate(date);
        salesBalanceReport.setToDate(date2);
        salesBalanceReport.setReportTime(new Date());
        try {
            session = genericDAO.getSession();
            salesBalanceReport.setNetSalesAmount(this.i(session, date, date2, user));
            salesBalanceReport.setGrossTaxableSalesAmount(this.a(session, date, date2, user, true));
            salesBalanceReport.setGrossNonTaxableSalesAmount(this.a(session, date, date2, user, false));
            salesBalanceReport.setDiscountAmount(this.g(session, date, date2, user));
            salesBalanceReport.setSalesTaxAmount(this.h(session, date, date2, user));
            salesBalanceReport.setCashTipsAmount(this.e(session, date, date2, user));
            salesBalanceReport.setChargedTipsAmount(this.f(session, date, date2, user));
            salesBalanceReport.setCashReceiptsAmount(this.d(session, date, date2, user));
            salesBalanceReport.setCreditCardReceiptsAmount(this.a(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setDebitCardReceiptsAmount(this.d(session, DebitCardTransaction.class, date, date2, user));
            salesBalanceReport.setMemberPaymentAmount(this.f(session, CustomerAccountTransaction.class, date, date2, user));
            salesBalanceReport.setCustomPaymentAmount(this.e(session, CustomPaymentTransaction.class, date, date2, user));
            salesBalanceReport.setGiftCertReceipts(this.calculateGiftCertReceipts(session, date, date2, user));
            salesBalanceReport.setCashBackAmount(this.b(session, RefundTransaction.class, date, date2, user));
            salesBalanceReport.setCashRefundAmount(this.c(session, RefundTransaction.class, date, date2, user));
            salesBalanceReport.setToleranceAmount(this.j(session, date, date2, user));
            salesBalanceReport.setServiceChargeAmnt(this.c(session, date, date2, user));
            salesBalanceReport.setGrossTipsPaidAmount(this.b(session, date, date2, user));
            salesBalanceReport.setCashPayoutAmount(this.a(session, date, date2, user));
            this.a(session, salesBalanceReport, date, date2, user);
            salesBalanceReport.setVisaCreditCardAmount(this.g(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setMasterCardAmount(this.h(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setAmexAmount(this.i(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setDiscoveryAmount(this.j(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.calculate();
            SalesBalanceReport salesBalanceReport2 = salesBalanceReport;
            return salesBalanceReport2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void a(Session session, SalesBalanceReport salesBalanceReport, Date date, Date date2, User user) {
        double d;
        Criteria criteria = session.createCriteria(CashDrawer.class);
        criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)date2));
        this.a(user, criteria, CashDrawer.PROP_ASSIGNED_USER_ID);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)CashDrawer.PROP_DRAWER_ACCOUNTABLE));
        projectionList.add((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
        criteria.setProjection((Projection)projectionList);
        Object[] objectArray = (Object[])criteria.uniqueResult();
        if (objectArray.length > 0 && objectArray[0] instanceof Number) {
            d = ((Number)objectArray[0]).doubleValue();
            salesBalanceReport.setDrawerPullsAmount(d);
        }
        if (objectArray.length > 1 && objectArray[1] instanceof Number) {
            d = ((Number)objectArray[1]).doubleValue();
            salesBalanceReport.setDrawerPullsAmount(salesBalanceReport.getDrawerPullsAmount() - d);
        }
    }

    private double a(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PayOutTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double b(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.createAlias(Ticket.PROP_GRATUITY, "gratuity");
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)("gratuity." + Gratuity.PROP_PAID), (Object)Boolean.TRUE));
        this.a(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)("gratuity." + Gratuity.PROP_AMOUNT)));
        return this.a(criteria.uniqueResult());
    }

    private double a(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CreditCardTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double b(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double c(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double c(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        this.a(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SERVICE_CHARGE));
        return this.a(criteria.uniqueResult());
    }

    private double d(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double e(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double d(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(CashTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)CashTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)CashTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        this.a(user, criteria, CashTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)CashTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    public double calculateGiftCertReceipts(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(GiftCertificateTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        this.a(user, criteria, GiftCertificateTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)GiftCertificateTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double e(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double f(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double f(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double g(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
        this.a(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double a(Object object) {
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    private double h(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        this.a(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double i(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        this.a(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double j(Session session, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, CashTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private Criteria a(Session session, Class clazz) {
        Criteria criteria = session.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class) || clazz.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private double a(Session session, Date date, Date date2, User user, boolean bl) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
        this.a(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TAX_EXEMPT, (Object)(!bl ? 1 : 0)));
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesExceptionReport getSalesExceptionReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesExceptionReport salesExceptionReport = new SalesExceptionReport();
        Session session = null;
        salesExceptionReport.setFromDate(date);
        salesExceptionReport.setToDate(date2);
        salesExceptionReport.setReportTime(new Date());
        try {
            Object object;
            Object object22;
            Object object32;
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(RefundTransaction.class);
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            List list = criteria.list();
            for (Object object32 : list) {
                salesExceptionReport.addRefundToRefundData((RefundTransaction)object32);
            }
            Criteria criteria2 = session.createCriteria(Ticket.class);
            criteria2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria2.add((Criterion)Restrictions.le((String)Ticket.PROP_CLOSING_DATE, (Object)date2));
            criteria2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            list = criteria2.list();
            for (Object object22 : list) {
                salesExceptionReport.addVoidToVoidData((Ticket)object22);
            }
            criteria2 = session.createCriteria(Ticket.class);
            criteria2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria2.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            list = criteria2.list();
            for (Object object22 : list) {
                salesExceptionReport.addDiscountOnTicket((Ticket)object22);
                object = ((Ticket)object22).getTicketItems();
                Iterator<TicketItem> iterator = object.iterator();
                while (iterator.hasNext()) {
                    TicketItem ticketItem = iterator.next();
                    salesExceptionReport.addDiscountOnTicketItem(ticketItem);
                }
            }
            object32 = new DiscountDAO();
            object22 = ((DiscountDAO)object32).getValidCoupons();
            salesExceptionReport.addEmptyDiscounts((List<Discount>)object22);
            object = salesExceptionReport;
            return object;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesDetailedReport getSalesDetailedReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesDetailedReport salesDetailedReport = new SalesDetailedReport();
        Session session = null;
        salesDetailedReport.setFromDate(date);
        salesDetailedReport.setToDate(date2);
        salesDetailedReport.setReportTime(new Date());
        try {
            Object object;
            Comparable comparable2;
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(CashDrawer.class);
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)date2));
            List list = criteria.list();
            for (Comparable comparable2 : list) {
                object = new SalesDetailedReport.DrawerPullData();
                ((SalesDetailedReport.DrawerPullData)object).setDrawerPullId(((BaseCashDrawer)comparable2).getId());
                ((SalesDetailedReport.DrawerPullData)object).setTicketCount(((BaseCashDrawer)comparable2).getTicketCount());
                ((SalesDetailedReport.DrawerPullData)object).setIdealAmount(((BaseCashDrawer)comparable2).getDrawerAccountable());
                ((SalesDetailedReport.DrawerPullData)object).setActualAmount(((BaseCashDrawer)comparable2).getCashToDeposit());
                ((SalesDetailedReport.DrawerPullData)object).setVarinceAmount(((BaseCashDrawer)comparable2).getDrawerAccountable() - ((BaseCashDrawer)comparable2).getCashToDeposit());
                salesDetailedReport.addDrawerPullData((SalesDetailedReport.DrawerPullData)object);
            }
            criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Comparable comparable2 : list) {
                salesDetailedReport.addCreditCardData((CreditCardTransaction)comparable2);
            }
            criteria = session.createCriteria(DebitCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Comparable comparable2 : list) {
                salesDetailedReport.addCreditCardData((DebitCardTransaction)comparable2);
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setGiftCertReturnCount(((Number)((Object)comparable2[0])).intValue());
            }
            if (comparable2 != null && ((Comparable)comparable2).length > 1 && comparable2[1] instanceof Number) {
                salesDetailedReport.setGiftCertReturnAmount(((Number)((Object)comparable2[1])).doubleValue());
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            criteria.add((Criterion)Restrictions.gt((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT, (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setGiftCertChangeCount(((Number)((Object)comparable2[0])).intValue());
            }
            if (comparable2 != null && ((Comparable)comparable2).length > 1 && comparable2[1] instanceof Number) {
                salesDetailedReport.setGiftCertChangeAmount(((Number)((Object)comparable2[1])).doubleValue());
            }
            criteria = session.createCriteria(Ticket.class);
            criteria.createAlias(Ticket.PROP_GRATUITY, "g");
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_AMOUNT), (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)("g." + Gratuity.PROP_AMOUNT)));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setTipsCount(((Number)((Object)comparable2[0])).intValue());
            }
            if (comparable2 != null && ((Comparable)comparable2).length > 1 && comparable2[1] instanceof Number) {
                salesDetailedReport.setChargedTips(((Number)((Object)comparable2[1])).doubleValue());
            }
            criteria = session.createCriteria(Ticket.class);
            criteria.createAlias(Ticket.PROP_GRATUITY, "g");
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_AMOUNT), (Object)0.0));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_PAID), (Object)Boolean.TRUE));
            projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)("g." + Gratuity.PROP_AMOUNT)));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setTipsPaid(((Number)((Object)comparable2[0])).doubleValue());
            }
            object = salesDetailedReport;
            return object;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesDetailedReport getCloudSalesDetailedReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesDetailedReport salesDetailedReport = new SalesDetailedReport();
        Session session = null;
        salesDetailedReport.setFromDate(date);
        salesDetailedReport.setToDate(date2);
        salesDetailedReport.setReportTime(new Date());
        try {
            Object object;
            Comparable comparable2;
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(CashDrawer.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME), (Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME), (Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)date2)));
            List list = criteria.list();
            for (Comparable comparable2 : list) {
                object = new SalesDetailedReport.DrawerPullData();
                ((SalesDetailedReport.DrawerPullData)object).setDrawerPullId(((BaseCashDrawer)comparable2).getId());
                ((SalesDetailedReport.DrawerPullData)object).setTicketCount(((BaseCashDrawer)comparable2).getTicketCount());
                ((SalesDetailedReport.DrawerPullData)object).setIdealAmount(((BaseCashDrawer)comparable2).getDrawerAccountable());
                ((SalesDetailedReport.DrawerPullData)object).setActualAmount(((BaseCashDrawer)comparable2).getCashToDeposit());
                ((SalesDetailedReport.DrawerPullData)object).setVarinceAmount(((BaseCashDrawer)comparable2).getDrawerAccountable() - ((BaseCashDrawer)comparable2).getCashToDeposit());
                salesDetailedReport.addDrawerPullData((SalesDetailedReport.DrawerPullData)object);
            }
            criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Comparable comparable2 : list) {
                salesDetailedReport.addCreditCardData((CreditCardTransaction)comparable2);
            }
            criteria = session.createCriteria(DebitCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Comparable comparable2 : list) {
                salesDetailedReport.addCreditCardData((DebitCardTransaction)comparable2);
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setGiftCertReturnCount(((Number)((Object)comparable2[0])).intValue());
            }
            if (comparable2 != null && ((Comparable)comparable2).length > 1 && comparable2[1] instanceof Number) {
                salesDetailedReport.setGiftCertReturnAmount(((Number)((Object)comparable2[1])).doubleValue());
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            criteria.add((Criterion)Restrictions.gt((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT, (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setGiftCertChangeCount(((Number)((Object)comparable2[0])).intValue());
            }
            if (comparable2 != null && ((Comparable)comparable2).length > 1 && comparable2[1] instanceof Number) {
                salesDetailedReport.setGiftCertChangeAmount(((Number)((Object)comparable2[1])).doubleValue());
            }
            object = salesDetailedReport;
            return object;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private double g(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.VISA.name()));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double h(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.MASTER_CARD.name().replaceAll("_", "")));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double i(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.AMERICAN_EXPRESS.name()), (Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)"AMEX")));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double j(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.DISCOVER.name()));
        this.a(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private void a(User user, Criteria criteria, String string) {
        if (user != null) {
            PosLog.info(this.getClass(), "setting multi user filter for root user '" + user.getFullName() + "', id: " + user.getId());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)string, (Object)user.getId()));
            List<User> list = user.getLinkedUser();
            if (list != null) {
                for (User user2 : list) {
                    if (user2.getId().equals(user.getId())) continue;
                    PosLog.info(this.getClass(), "linked user '" + user2.getFullName() + "', id: " + user2.getId());
                    disjunction.add((Criterion)Restrictions.eq((String)string, (Object)user2.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    public static SalesReportModel prepareItemSalesReportModel(List<TicketItem> list) {
        SalesReportModel salesReportModel = new SalesReportModel();
        if (list != null && list.size() > 0) {
            LinkedHashMap<String, ReportItem> linkedHashMap = new LinkedHashMap<String, ReportItem>();
            String string = null;
            for (TicketItem ticketItem : list) {
                String string2 = ticketItem.getMenuItemId();
                string = (string2 == null ? ticketItem.getName() : string2) + "-" + ticketItem.getUnitPrice() + "-" + ticketItem.getUnitName();
                ReportItem reportItem = (ReportItem)((HashMap)linkedHashMap).get(string);
                if (reportItem == null) {
                    reportItem = new ReportItem();
                    reportItem.setId(string);
                    reportItem.setPrice(ticketItem.getUnitPrice());
                    reportItem.setUnit(ticketItem.getUnitName());
                    reportItem.setCost(ticketItem.getUnitCost());
                    reportItem.setName(ticketItem.getName());
                    reportItem.setTaxRate(ticketItem.getTotalTaxRate());
                    reportItem.setGroupName(ticketItem.getGroupName());
                    reportItem.setBarcode(string2);
                    reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
                    linkedHashMap.put(string, reportItem);
                }
                reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
                reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItem.getAdjustedTotalWithoutModifiers());
                reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscountWithoutModifiers());
                reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTaxWithoutModifiers());
                reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
                double d = ticketItem.isTaxIncluded() != false ? ticketItem.getAdjustedTotalWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers() : ticketItem.getAdjustedSubtotalWithoutModifiers();
                reportItem.setNetTotal(reportItem.getNetTotal() + d);
            }
            salesReportModel.setItems(new ArrayList<ReportItem>(((HashMap)linkedHashMap).values()));
        }
        return salesReportModel;
    }

    public static Map<String, Integer> prepareTicketForDashBoard(List<Date> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (list != null && list.size() > 0) {
            int n = 0;
            for (Date date : list) {
                String string = DateUtil.formatAsDefaultMonthDate(date);
                if (hashMap.get(string) == null) {
                    n = 1;
                }
                if (hashMap.containsKey(string)) {
                    ++n;
                }
                hashMap.put(string, n);
            }
        }
        return hashMap;
    }
}

