/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class POSFileChooser
extends JFileChooser {
    FileNameExtensionFilter a = new FileNameExtensionFilter(Messages.getString("POSFileChooser.0"), "jpg", "jpeg", "png", "gif");

    public POSFileChooser() {
        this.setDialogTitle("FloreantPOS");
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(this.a);
        this.setAccessory(new ImagePreview(this));
        this.setFileView(new FileView(){

            @Override
            public Icon getIcon(File file) {
                return FileSystemView.getFileSystemView().getSystemIcon(file);
            }
        });
    }

    public POSFileChooser(String string) {
        super(string);
        this.setDialogTitle("FloreantPOS");
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(this.a);
        this.setAccessory(new ImagePreview(this));
        this.setFileView(new FileView(){

            @Override
            public Icon getIcon(File file) {
                return FileSystemView.getFileSystemView().getSystemIcon(file);
            }
        });
    }

    public class ImagePreview
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon a = null;
        File b = null;

        public ImagePreview(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(300, 200));
            jFileChooser.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.b == null) {
                this.a = null;
                return;
            }
            ImageIcon imageIcon = new ImageIcon(this.b.getPath());
            if (imageIcon != null) {
                this.a = imageIcon.getIconWidth() > 90 ? new ImageIcon(imageIcon.getImage().getScaledInstance(280, -1, 1)) : imageIcon;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = false;
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                this.b = null;
                bl = true;
            } else if ("SelectedFileChangedProperty".equals(string)) {
                this.b = (File)propertyChangeEvent.getNewValue();
                bl = true;
            }
            if (bl) {
                this.a = null;
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.a == null) {
                this.loadImage();
            }
            if (this.a != null) {
                int n = this.getWidth() / 2 - this.a.getIconWidth() / 2;
                int n2 = this.getHeight() / 2 - this.a.getIconHeight() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 5) {
                    n = 5;
                }
                this.a.paintIcon(this, graphics, n, n2);
            }
        }
    }
}

