/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.ui.order.TicketListView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class OrderFilterPanel
extends JXCollapsiblePane {
    private ITicketList a;
    private TicketListView b;
    private POSToggleButton c;
    private POSToggleButton d;

    public OrderFilterPanel(ITicketList iTicketList) {
        this.a = iTicketList;
        this.b = (TicketListView)iTicketList;
        this.setCollapsed(true);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("fill", "fill, grow", ""));
        this.a();
        this.b();
        this.c();
    }

    private void a() {
        this.c = new POSToggleButton(PaymentStatusFilter.OPEN.getDisplayString());
        this.c.setActionCommand(PaymentStatusFilter.OPEN.name());
        this.d = new POSToggleButton(PaymentStatusFilter.CLOSED.getDisplayString());
        this.d.setActionCommand(PaymentStatusFilter.CLOSED.name());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.c);
        buttonGroup.add(this.d);
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        switch (paymentStatusFilter) {
            case OPEN: {
                this.c.setSelected(true);
                break;
            }
            case PAID: {
                break;
            }
            case CLOSED: {
                this.d.setSelected(true);
            }
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                String string2 = string.replaceAll("\\s", "_");
                TerminalConfig.setPaymentStatusFilter(string2);
                OrderFilterPanel.this.d();
            }
        };
        this.c.addActionListener(actionListener);
        this.d.addActionListener(actionListener);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "fill, grow", ""));
        jPanel.setBorder(new TitledBorder(Messages.getString("SwitchboardView.3")));
        jPanel.add(this.c);
        jPanel.add(this.d);
        this.getContentPane().add(jPanel);
    }

    private void b() {
        OrderTypeFilterButton orderTypeFilterButton = new OrderTypeFilterButton(null);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "fill, grow", ""));
        jPanel.setBorder(new TitledBorder(Messages.getString("SwitchboardView.4")));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(orderTypeFilterButton);
        jPanel.add(orderTypeFilterButton);
        List<OrderType> list = Application.getInstance().getOrderTypes();
        for (OrderType orderType : list) {
            OrderTypeFilterButton orderTypeFilterButton2 = new OrderTypeFilterButton(orderType);
            buttonGroup.add(orderTypeFilterButton2);
            jPanel.add(orderTypeFilterButton2);
        }
        this.getContentPane().add(jPanel);
    }

    private void c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "fill, grow", ""));
        jPanel.setBorder(new TitledBorder(Messages.getString("OrderFilterPanel.7")));
        POSToggleButton pOSToggleButton = new POSToggleButton(POSConstants.MY_TICKETS);
        jPanel.add((Component)pOSToggleButton, "");
        pOSToggleButton.setSelected(TerminalConfig.isFilterByOwner());
        pOSToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    TerminalConfig.setFilterByOwner(true);
                    OrderFilterPanel.this.d();
                } else {
                    TerminalConfig.setFilterByOwner(false);
                    OrderFilterPanel.this.d();
                }
            }
        });
        this.getContentPane().add(jPanel);
    }

    private void d() {
        this.a.updateTicketList();
        this.b.updateButtonStatus();
    }

    private class OrderTypeFilterButton
    extends POSToggleButton
    implements ActionListener {
        public OrderTypeFilterButton(OrderType orderType) {
            String string = TerminalConfig.getOrderTypeFilter();
            if (orderType != null) {
                if (string.equals(orderType.getId())) {
                    this.setSelected(true);
                }
                this.setText(orderType.getName());
                this.setActionCommand(orderType.getId());
            } else {
                if (string.equals(POSConstants.ALL)) {
                    this.setSelected(true);
                }
                this.setText(POSConstants.ALL);
                this.setActionCommand(POSConstants.ALL);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelected(true);
            String string = actionEvent.getActionCommand();
            TerminalConfig.setOrderTypeFilter(string);
            OrderFilterPanel.this.d();
        }
    }
}

