/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.config.TerminalConfig;
import jssc.SerialPort;
import jssc.SerialPortException;

public class DrawerUtil {
    private boolean a;
    private static int b = 216;
    private static int c = 180;
    private static int d = 127;
    private static final float e = 2.54f;
    private static final char f = '\u001b';
    private static final char g = '@';
    private static final char h = '\n';
    private static final char i = '(';
    private static final char j = '\\';
    private static final char k = '\r';
    private static final char l = '\t';
    private static final char m = '\f';
    private static final char n = 'g';
    private static final char o = 'p';
    private static final char p = 't';
    private static final char q = 'l';
    private static final char r = 'x';
    private static final char s = 'E';
    private static final char t = 'F';
    private static final char u = 'J';
    private static final char v = 'P';
    private static final char w = 'Q';
    private static final char x = '$';
    private static final char y = '\u0000';
    private static final char z = '\u0001';
    private static final char A = '\u0002';
    private static final char B = '\u0003';
    private static final char C = '\u0004';
    private static final char D = '\u0005';
    private static final char E = '\u0006';
    private static final char F = '\u0007';
    private static final char G = '\u0019';
    private static final char H = 'i';
    private static final char I = '\u0000';
    private static final char J = '\u0001';
    private static final char K = '\u0019';
    private static final char L = '\u00fa';
    private static final char M = '\u03e7';
    private static final char N = '0';
    private static final char O = '7';
    private static final char P = 'y';
    public static final char USA = '\u0001';
    public static final char BRAZIL = '\u0019';
    public static SerialPort serialPort;
    private static char[] Q;

    public void close() {
        try {
            serialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static boolean initialize() {
        try {
            serialPort.openPort();
            serialPort.setParams(9600, 8, 1, 0);
            DrawerUtil.setCharacterSet('\u0001');
        }
        catch (SerialPortException serialPortException) {
            return false;
        }
        return true;
    }

    public static boolean printToThePort() {
        try {
            serialPort.openPort();
            serialPort.setParams(9600, 8, 1, 0);
            DrawerUtil.print('\u001b');
            DrawerUtil.print('@');
            DrawerUtil.setCharacterSet('\u0001');
        }
        catch (SerialPortException serialPortException) {
            return false;
        }
        return true;
    }

    public static void select10CPI() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('P');
    }

    public static void select15CPI() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('g');
    }

    public static void selectDraftPrinting() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('x');
        DrawerUtil.print('0');
    }

    public static void selectLQPrinting() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('x');
        DrawerUtil.print('1');
    }

    public static void setCharacterSet(char c) {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('(');
        DrawerUtil.print('t');
        DrawerUtil.print('\u0003');
        DrawerUtil.print('\u0000');
        DrawerUtil.print('\u0001');
        DrawerUtil.print(c);
        DrawerUtil.print('\u0000');
        DrawerUtil.print('\u001b');
        DrawerUtil.print('t');
        DrawerUtil.print('\u0001');
    }

    public static void lineFeed() {
        DrawerUtil.print('\r');
        DrawerUtil.print('\n');
    }

    public static void formFeed() {
        DrawerUtil.print('\r');
        DrawerUtil.print('\f');
    }

    public static void bold(boolean bl) {
        DrawerUtil.print('\u001b');
        if (bl) {
            DrawerUtil.print('E');
        } else {
            DrawerUtil.print('F');
        }
    }

    public static void tear() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('i');
    }

    public static void kick() {
        DrawerUtil.print("Start kicking drawer\n");
        if (Q.length >= 5) {
            DrawerUtil.print(Q[0]);
            DrawerUtil.print(Q[1]);
            DrawerUtil.print(Q[2]);
            DrawerUtil.print(Q[3]);
            DrawerUtil.print(Q[4]);
        } else {
            DrawerUtil.print('\u001b');
            DrawerUtil.print('p');
            DrawerUtil.print('\u0000');
            DrawerUtil.print('\u0019');
            DrawerUtil.print('\u00fa');
        }
        DrawerUtil.print("End kicking drawer\n");
    }

    public static void proportionalMode(boolean bl) {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('p');
        if (bl) {
            DrawerUtil.print('1');
        } else {
            DrawerUtil.print('0');
        }
    }

    public static void advanceVertical(float f) {
    }

    public static void advanceHorizontal(float f) {
        float f2 = f / 2.54f;
        int n = (int)(f2 * 120.0f) % 256;
        int n2 = (int)(f2 * 120.0f) / 256;
        DrawerUtil.print('\u001b');
        DrawerUtil.print('\\');
        DrawerUtil.print((char)n);
        DrawerUtil.print((char)n2);
    }

    public static void setAbsoluteHorizontalPosition(float f) {
        float f2 = f / 2.54f;
        int n = (int)(f2 * 60.0f) % 256;
        int n2 = (int)(f2 * 60.0f) / 256;
        DrawerUtil.print('\u001b');
        DrawerUtil.print('$');
        DrawerUtil.print((char)n);
        DrawerUtil.print((char)n2);
    }

    public static void horizontalTab(int n) {
        for (int i = 0; i < n; ++i) {
            DrawerUtil.print('\t');
        }
    }

    public static void setMargins(int n, int n2) {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('l');
        DrawerUtil.print((char)n);
        DrawerUtil.print('\u001b');
        DrawerUtil.print('Q');
        DrawerUtil.print((char)n2);
    }

    public static void print(String string) {
        try {
            serialPort.writeBytes(string.getBytes());
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static void print(char c) {
        try {
            serialPort.writeByte((byte)c);
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static boolean isInitialized() {
        return true;
    }

    public static String getShare() {
        return "";
    }

    public static void kickDrawer() {
        try {
            PosLog.debug(DrawerUtil.class, "kicking drawer...");
            String string = TerminalConfig.getDrawerPortName();
            char[] cArray = TerminalConfig.getDrawerControlCodesArray();
            DrawerUtil.kickDrawer(string, cArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void kickDrawer(String string, char[] cArray) {
        Q = cArray;
        serialPort = new SerialPort(string);
        DrawerUtil.initialize();
        try {
            DrawerUtil.kick();
            serialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static void setCustomerDisplayMessage(String string, String string2) {
        serialPort = new SerialPort(string);
        DrawerUtil.initialize();
        try {
            DrawerUtil.print('\f');
            serialPort.writeBytes(string2.getBytes());
            serialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static void setItemDisplay(String string, String string2) {
        try {
            serialPort = new SerialPort(string);
            DrawerUtil.initialize();
            DrawerUtil.print('\f');
            DrawerUtil.print(string2);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                serialPort.closePort();
            }
            catch (SerialPortException serialPortException) {}
        }
    }

    public static void testWeightInput() {
        try {
            SerialPort serialPort = new SerialPort("COM1");
            serialPort.openPort();
            serialPort.setParams(9600, 8, 1, 0);
            DrawerUtil.setCharacterSet('\u0001');
            DrawerUtil.print('W');
            DrawerUtil.print('\r');
            byte[] byArray = serialPort.readBytes();
            PosLog.info(DrawerUtil.class, "Response: " + new String(byArray));
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }
}

