/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.POSConstants;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.IdContainer;
import com.floreantpos.model.OrderType;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class PosGuiUtil {
    private static JFileChooser a = new JFileChooser();

    public static int captureGuestNumber() {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
        numberSelectionDialog2.setTitle(POSConstants.ENTER_NUMBER_OF_GUEST);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return 1;
        }
        int n = (int)numberSelectionDialog2.getValue();
        if (n == 0) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.GUEST_NUMBER_CANNOT_BE_0);
            return 1;
        }
        return n;
    }

    public static Customer captureCustomer(OrderType orderType) {
        CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(orderType);
        customerSelectorDialog.setCreateNewTicket(false);
        customerSelectorDialog.updateView(true);
        customerSelectorDialog.openUndecoratedFullScreen();
        if (customerSelectorDialog.isCanceled()) {
            return null;
        }
        return customerSelectorDialog.getSelectedCustomer();
    }

    public static Double parseDouble(JTextComponent jTextComponent) {
        String string = jTextComponent.getText();
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static boolean isModalDialogShowing() {
        Window[] windowArray = Window.getWindows();
        if (windowArray != null) {
            for (Window window : windowArray) {
                if (!window.isShowing() || !(window instanceof Dialog) || !((Dialog)window).isModal()) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumnWidth(JTable jTable, int n, int n2) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setWidth(n2);
    }

    public static TitledBorder createTitledBorder(String string) {
        return new TitledBorder(null, string, 2, 2);
    }

    public static BufferedImage selectImageFile() throws Exception {
        a.setMultiSelectionEnabled(false);
        a.setFileSelectionMode(0);
        int n = a.showOpenDialog(null);
        if (n == 0) {
            File file = a.getSelectedFile();
            BufferedImage bufferedImage = ImageIO.read(file);
            return PosGuiUtil.scale(bufferedImage, 100, 100);
        }
        return null;
    }

    public static BufferedImage scale(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics2D graphics2D = null;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = n4;
        int n7 = n5;
        do {
            if (n4 > n) {
                int n8 = n4 = (n4 /= 2) < n ? n : n4;
            }
            if (n5 > n2) {
                int n9 = n5 = (n5 /= 2) < n2 ? n2 : n5;
            }
            if (bufferedImage3 == null) {
                bufferedImage3 = new BufferedImage(n4, n5, n3);
                graphics2D = bufferedImage3.createGraphics();
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, n4, n5, 0, 0, n6, n7, null);
            n6 = n4;
            n7 = n5;
            bufferedImage2 = bufferedImage3;
        } while (n4 != n || n5 != n2);
        if (graphics2D != null) {
            graphics2D.dispose();
        }
        if (n != bufferedImage2.getWidth() || n2 != bufferedImage2.getHeight()) {
            bufferedImage3 = new BufferedImage(n, n2, n3);
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public static void selectComboItemById(JComboBox<? extends IdContainer> jComboBox, String string) {
        jComboBox.setSelectedItem(null);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            IdContainer idContainer = jComboBox.getItemAt(i);
            if (idContainer == null || string == null || !string.equals(idContainer.getId())) continue;
            jComboBox.setSelectedIndex(i);
            return;
        }
    }
}

