/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleObjectStateException;
import org.hibernate.exception.JDBCConnectionException;

public abstract class ViewChangeAction
extends PosAction {
    private boolean a = true;
    protected UserPermission requiredPermission;

    public ViewChangeAction() {
    }

    public ViewChangeAction(String string) {
        super(string);
    }

    public ViewChangeAction(Icon icon) {
        super(null, icon);
    }

    public ViewChangeAction(String string, Icon icon) {
        super(string, icon);
    }

    public ViewChangeAction(String string, UserPermission userPermission) {
        super(string);
        this.requiredPermission = userPermission;
    }

    public ViewChangeAction(Icon icon, UserPermission userPermission) {
        super(null, icon);
        this.requiredPermission = userPermission;
    }

    @Override
    public UserPermission getRequiredPermission() {
        return this.requiredPermission;
    }

    @Override
    public void setRequiredPermission(UserPermission userPermission) {
        this.requiredPermission = userPermission;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            OrderView orderView = OrderView.getInstance();
            Ticket ticket = orderView.getCurrentTicket();
            if (ticket == null || ticket.getId() == null && ticket.getTicketItems().isEmpty()) {
                this.execute();
                return;
            }
            boolean bl = TerminalDAO.getInstance().isVersionEqual(Ticket.class, ticket.getId(), ticket.getVersion());
            if (!bl) {
                this.execute();
                return;
            }
            User user = Application.getCurrentUser();
            if (user == null) {
                POSMessageDialog.showError("Please login first.");
                return;
            }
            IView iView = RootView.getInstance().getCurrentView();
            if (iView != null && iView.getViewName().equals("ORDER_VIEW") && !orderView.getTicketView().isAllowToLogOut()) {
                POSMessageDialog.showError(Messages.getString("ViewChangeAction.0"));
                return;
            }
            this.a();
            if (this.requiredPermission == null) {
                this.execute();
                return;
            }
            if (!user.hasPermission(this.requiredPermission)) {
                String string = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
                if (StringUtils.isEmpty((String)string)) {
                    return;
                }
                User user2 = UserDAO.getInstance().findUserBySecretKey(string);
                if (user2 == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.1"));
                    return;
                }
                if (!user2.hasPermission(this.requiredPermission)) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.2"));
                    return;
                }
            }
            this.execute();
        }
        catch (JDBCConnectionException jDBCConnectionException) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ViewChangeAction.3"), POSConstants.CONFIRM) == 0) {
                this.execute();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a() {
        OrderView orderView = OrderView.getInstance();
        if (!orderView.isVisible()) {
            return;
        }
        Ticket ticket = orderView.getCurrentTicket();
        if (ticket == null) {
            return;
        }
        if (!ticket.getTicketItems().isEmpty() && this.a(ticket) && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ViewChangeAction.1"), Messages.getString("ViewChangeAction.2")) == 0) {
            try {
                orderView.getTicketView().saveTicketIfNeeded();
            }
            catch (StaleObjectStateException staleObjectStateException) {
                // empty catch block
            }
        }
    }

    private boolean a(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getId() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract void execute();

    @Override
    public boolean isVisible() {
        return this.a;
    }

    @Override
    public void setVisible(boolean bl) {
        this.a = bl;
    }
}

