/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.AttendanceHistoryExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class AttendanceHistoryAction
extends AbstractAction {
    public AttendanceHistoryAction() {
        super(Messages.getString("AttendanceHistoryAction.0"));
    }

    public AttendanceHistoryAction(String string) {
        super(string);
    }

    public AttendanceHistoryAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            AttendanceHistoryExplorer attendanceHistoryExplorer = null;
            int n = jTabbedPane.indexOfTab(Messages.getString("AttendanceHistoryAction.0"));
            if (n == -1) {
                attendanceHistoryExplorer = new AttendanceHistoryExplorer();
                jTabbedPane.addTab(Messages.getString("AttendanceHistoryAction.0"), attendanceHistoryExplorer);
            } else {
                attendanceHistoryExplorer = (AttendanceHistoryExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(attendanceHistoryExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

