/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.ui.ConfigurationSubEditor;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.LicenseValidationUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.InvalidPluginDialog;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFloreantPlugin
implements FloreantPlugin,
LicenseSelectionListener {
    private OroLicense a;

    @Override
    public boolean requireLicense() {
        return true;
    }

    @Override
    public void initLicense() {
        String string = this.getProductName();
        String string2 = string + ".license.pin";
        String string3 = this.getProductVersion();
        try {
            this.a = LicenseUtil.loadAndValidate((String)string, (String)string3, (String)TerminalUtil.getSystemUID());
            if (this.a.isDemoLicense()) {
                boolean bl = LicenseValidationUtil.doCheckPinNumber(this.a, string2, true);
                this.a.setPinVarified(bl);
            }
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.a();
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
        }
    }

    private void a() {
        String string = this.getProductName();
        String string2 = string + ".license.pin";
        String string3 = this.getProductVersion();
        try {
            this.a = LicenseUtil.loadAndValidate((String)string, (String)string3, (String)TerminalUtil.getOldSystemUID());
            if (this.a.isDemoLicense()) {
                boolean bl = LicenseValidationUtil.doCheckPinNumber(this.a, string2, true);
                this.a.setPinVarified(bl);
            }
        }
        catch (InvalidLicenseException invalidLicenseException) {
            PosWindow posWindow = Application.getPosWindow();
            String string4 = Messages.getString("AbstractFloreantPlugin.1");
            InvalidPluginDialog.show((LicenseSelectionListener)this, (Component)posWindow, (String)invalidLicenseException.getMessage(), (String)string4, (String)string, (String)string3, (String)TerminalUtil.getSystemUID());
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
        }
    }

    public void checkForUpdate() {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (!this.isUpdateAvailable()) {
            POSMessageDialog.showMessage(backOfficeWindow, Messages.getString("AbstractFloreantPlugin.2"));
            return;
        }
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        Integer n = this.getProductNumericVersion();
        if (n == null) {
            return;
        }
        String string3 = this.getUpdateServerURL();
        UpdateManager updateManager = new UpdateManager();
        updateManager.setParentWindow(backOfficeWindow == null ? Application.getPosWindow() : backOfficeWindow);
        updateManager.checkForPluginUpdate(string3, string, string2, n);
    }

    public boolean isUpdateAvailable() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        Integer n = this.getProductNumericVersion();
        if (n == null) {
            return false;
        }
        String string3 = this.getUpdateServerURL();
        UpdateManager updateManager = new UpdateManager();
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        updateManager.setParentWindow(backOfficeWindow == null ? Application.getPosWindow() : backOfficeWindow);
        return updateManager.isUpdateAvailable(string3, string, string2, n);
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getProductName();

    public abstract String getProductVersion();

    public abstract Integer getProductNumericVersion();

    public abstract Component getParent();

    public abstract String getUpdateServerURL();

    public void licenseFileSelected(File file) throws Exception {
        try {
            OroLicense oroLicense = LicenseUtil.loadAndValidate((File)file, (String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
            LicenseUtil.copyLicenseFile((File)file, (String)this.getProductName());
            this.setLicense(oroLicense);
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
            throw exception;
        }
    }

    @Override
    public boolean hasValidLicense() {
        if (this.a != null) {
            if (this.a.isDemoLicense()) {
                return this.a.isValid() && this.a.isPinVarified();
            }
            return this.a.isValid();
        }
        return false;
    }

    public OroLicense getLicense() {
        return this.a;
    }

    public void setLicense(OroLicense oroLicense) {
        this.a = oroLicense;
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    @Override
    public void initConfigurationView(JDialog jDialog) {
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public List<ConfigurationSubEditor> getSubEditors() {
        return null;
    }

    @Override
    public void initUI(PosWindow posWindow) {
    }

    public void restartPOS(boolean bl) {
    }
}

