/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseDiscountDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class DiscountDAO
extends BaseDiscountDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Discount getInitialized(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)string));
            Discount discount = (Discount)criteria.uniqueResult();
            Hibernate.initialize(discount.getMenuItems());
            Hibernate.initialize(discount.getMenuGroups());
            Hibernate.initialize(discount.getMenuCategories());
            Discount discount2 = discount;
            return discount2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> findAllValidCoupons() {
        Session session = null;
        Date date = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getValidItemCoupons() {
        Session session = null;
        Date date = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getValidCoupon(MenuItem menuItem) {
        Session session = null;
        Date date = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getTicketValidCoupon() {
        Session session = null;
        Date date = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)1), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicable(String string, String string2) {
        Session session = null;
        Date date = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)string2));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Discount getDiscountByBarcode(String string, int n) {
        Session session = null;
        Criteria criteria = null;
        Date date = new Date();
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Discount.class);
            criteria.add((Criterion)Restrictions.like((String)Discount.PROP_BARCODE, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)(n == 0 ? 0 : 1)), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                Discount discount = null;
                return discount;
            }
            Discount discount = (Discount)list.get(0);
            return discount;
        }
        finally {
            this.closeSession(session);
        }
    }

    public String getCurrentDayPropertyName(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string = "";
        int n = calendar.get(7);
        switch (n) {
            case 7: {
                string = Discount.PROP_APPLY_TO_SATURDAY_ONLY;
                break;
            }
            case 1: {
                string = Discount.PROP_APPLY_TO_SUNDAY_ONLY;
                break;
            }
            case 2: {
                string = Discount.PROP_APPLY_TO_MONDAY_ONLY;
                break;
            }
            case 3: {
                string = Discount.PROP_APPLY_TO_TUESDAY_ONLY;
                break;
            }
            case 4: {
                string = Discount.PROP_APPLY_TO_WEDNESDAY_ONLY;
                break;
            }
            case 5: {
                string = Discount.PROP_APPLY_TO_THURSDAY_ONLY;
                break;
            }
            case 6: {
                string = Discount.PROP_APPLY_TO_FRIDAY_ONLY;
                break;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Discount> getValidCoupons() {
        Session session = null;
        Date date = new Date();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateDiscountList(List<Discount> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Discount discount : list) {
                Discount discount2 = this.get(discount.getId());
                if (discount2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(discount.getLastUpdateTime(), discount2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), discount.getName() + " already updated");
                        continue;
                    }
                    long l = discount2.getVersion();
                    PropertyUtils.copyProperties((Object)discount2, (Object)discount);
                    discount2.setVersion(l);
                    discount2.setUpdateLastUpdateTime(bl);
                    discount2.setUpdateSyncTime(bl2);
                    this.update(discount2, session);
                    continue;
                }
                discount.setUpdateLastUpdateTime(bl);
                discount.setUpdateSyncTime(bl2);
                this.save(discount, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

