/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.BasePurchaseOrderDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class PurchaseOrderDAO
extends BasePurchaseOrderDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(purchaseOrder, bl, session);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateWithItemAvailBalance(PurchaseOrder purchaseOrder) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.updateAvailableUnit(purchaseOrder, session);
            transaction.commit();
        }
    }

    private void updateAvailableUnit(PurchaseOrder purchaseOrder, Session session) {
        List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
        if (list == null) {
            return;
        }
        for (PurchaseOrderItem purchaseOrderItem : list) {
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            Double d = purchaseOrderItem.getItemQuantity();
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d, true, false, session);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    public void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl, Session session) {
        if (purchaseOrder.getId() == null) {
            purchaseOrder.setCreatedDate(new Date());
            purchaseOrder.setStatus(0);
        }
        if (bl) {
            this.adjustInventoryItems(session, purchaseOrder);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl, boolean bl2) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (purchaseOrder.getId() == null) {
                purchaseOrder.setCreatedDate(new Date());
                purchaseOrder.setStatus(0);
            }
            if (bl) {
                this.adjustInventoryItems(session, purchaseOrder, bl2);
            }
            session.saveOrUpdate((Object)purchaseOrder);
            transaction.commit();
        }
    }

    private void adjustInventoryItems(Session session, PurchaseOrder purchaseOrder) {
        this.adjustInventoryItems(session, purchaseOrder, true);
    }

    private void adjustInventoryItems(Session session, PurchaseOrder purchaseOrder, boolean bl) {
        List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
        if (list == null) {
            return;
        }
        boolean bl2 = true;
        for (PurchaseOrderItem purchaseOrderItem : list) {
            purchaseOrderItem.setQuantityReceived(purchaseOrderItem.getQuantityReceived() + purchaseOrderItem.getQuantityToReceive());
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setQuantity(purchaseOrderItem.getQuantityToReceive());
            Double d = purchaseOrderItem.getUnitPrice();
            inventoryTransaction.setUnitCost(d);
            inventoryTransaction.setToInventoryLocation(purchaseOrder.getInventoryLocation());
            inventoryTransaction.setTransactionDate(purchaseOrder.getReceivingDate());
            inventoryTransaction.setVendor(purchaseOrder.getVendor());
            inventoryTransaction.setUnit(purchaseOrderItem.getItemUnitName());
            inventoryTransaction.setTotal(inventoryTransaction.getQuantity() * d);
            inventoryTransaction.setTransactionDate(new Date());
            if (purchaseOrder.getType().equals(PurchaseOrder.DEBIT)) {
                inventoryTransaction.setReason("PURCHASE");
                inventoryTransaction.setTransactionType(InventoryTransactionType.IN);
            } else {
                inventoryTransaction.setReason("RETURN");
                inventoryTransaction.setTransactionType(InventoryTransactionType.OUT);
            }
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session, bl, true);
            if (purchaseOrderItem.getQuantityReceived().doubleValue() != purchaseOrderItem.getItemQuantity().doubleValue()) {
                bl2 = false;
            }
            purchaseOrderItem.setQuantityToReceive(0.0);
        }
        if (bl2) {
            purchaseOrder.setStatus(4);
        } else {
            purchaseOrder.setStatus(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextOrderSequenceNumber() {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)PurchaseOrder.PROP_ORDER_ID));
            Object object = criteria.uniqueResult();
            if (object == null) {
                String string = "10001";
                return string;
            }
            String string = String.valueOf(Integer.parseInt((String)object) + 1);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PurchaseOrder> findBy(String string, InventoryVendor inventoryVendor, Date date, Date date2, Boolean bl) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)PurchaseOrder.PROP_ORDER_ID, (String)string.trim(), (MatchMode)MatchMode.START));
            }
            if (inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_VENDOR, (Object)inventoryVendor));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)PurchaseOrder.PROP_CREATED_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)PurchaseOrder.PROP_CREATED_DATE, (Object)date2));
            }
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_STATUS, (Object)4));
            }
            List list = criteria.list();
            return list;
        }
    }
}

