/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.BaseShiftDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ShiftDAO
extends BaseShiftDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Shift> findAllActive() {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PriceShift.PROP_ENABLE, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)PriceShift.PROP_PRIORITY));
            List list = criteria.list();
            return list;
        }
    }

    public boolean exists(String string) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Shift.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            throw new PosException("An error occured while trying to check Shift duplicacy", exception);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Shift getByName(String string) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Shift.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Shift shift = (Shift)list.get(0);
                return shift;
            }
            Shift shift = null;
            return shift;
        }
        catch (Exception exception) {
            throw new PosException("An error occured while trying to check Shift duplicacy", exception);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void refresh(Shift shift) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shift);
        }
        catch (Exception exception) {
            throw new PosException("An error occured while refreshing Shift state.", exception);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Shift findByName(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Shift.PROP_NAME, (Object)string));
            Shift shift = (Shift)criteria.uniqueResult();
            return shift;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void saveOrUpdateShifts(List<Shift> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Shift shift : list) {
                Shift shift2 = this.get(shift.getId());
                if (shift2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(shift.getLastUpdateTime(), shift2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), shift.getName() + " already updated");
                        continue;
                    }
                    long l = shift2.getVersion();
                    PropertyUtils.copyProperties((Object)shift2, (Object)shift);
                    shift2.setVersion(l);
                    shift2.setUpdateLastUpdateTime(bl);
                    shift2.setUpdateSyncTime(bl2);
                    this.update(shift2, session);
                    continue;
                }
                shift.setUpdateLastUpdateTime(bl);
                shift.setUpdateSyncTime(bl2);
                this.save(shift, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

